  program primadorac
!------------------------------------written by P. Procacci 2017 ----------------------------
!  read a pdb file (with charges) in the format
!
!  A30,3f8.3,f13.6 [string, x,y,x, esp_charge]
!
!  and reorganizes the file in connected groups printing out the associated tpg for orac simulation
!  with a reasonable GAFF assignment of the atoms
!
!---------------------------------------------------------------------------------------------
    implicit NONE
    real*8, allocatable :: x(:),y(:),z(:),esp(:),ddc(:),charge(:)
    real*8  :: threshold,threshold0,dd,bmat(10,10)
    character*132 string
    character*2, allocatable :: ato2(:),types(:),bcc_bond(:,:),bcc_types(:)
    character*1  ato
    character*2  atoms(80)
    character*4 atom4
    character*3 resname,ato3
    character*3, allocatable ::  hybrid(:)
    character*4, allocatable ::  atom_name(:)
    character*7 filename
    logical, allocatable ::  mask(:)
    integer, allocatable :: c(:,:),grpt(:,:),conn(:),igrp(:),bondi(:),bondj(:),impr(:,:),iring(:),kring(:,:),bond(:,:),in_ring(:),bcc_bond_index(:,:),bcc_index(:)
    integer i,j,k,k0,k1,ki,n,jg,ngrp,ngrph,iat,jat,ierr,iostat,nadd,nat,ig,ibond,nr,nrr,nbeg,iline,nb,i1,i2,nunits,nknown
    logical foundh,nocharges,lok,lbcc
    data atoms /"h ","c ","n ","o ","p ","s ","f ","cl","br","i ", & 
                "c1","c0","c2","c3","c4","c5","c6","c7","c8","c9", &
                "h1","h0","h2","h3","h4","h5","h6","h7","h8","h9", &
                "n1","n0","n2","n3","n4","n5","n6","n7","n8","n9", &
                "o9","o1","o0","o2","o3","o4","o5","o6","o7","o8", &
                "s1","s0","s2","s3","s4","s5","s6","s7","s8","s9", &
                "p1","p0","p2","p3","p4","p5","p6","p7","p8","p9", &
                "cb","ha","hb","nb","ox","ot","cx","c*","h*","n*" /
    n=0
    nknown=80
    threshold=1.7
    nocharges=.false.
!-->find out size of the molecule by reading input file
    nbeg=0
    iline=0
    lbcc=.true.
    do
       iline=iline+1
       read(5,2,end=1) string
2      format(A132)
       if(string(1:5).EQ."NOBCC") lbcc=.false.
       if(string(1:4).EQ."ATOM".OR.string(1:4).EQ."HETA")  THEN
          n=n+1
          if(nbeg.eq.0) THEN 
             nbeg=iline
             resname = string(18:20)
          end if

          if(string(35:35).ne.".") THEN
             write(6,3)
3            format(//" ------------** ERROR **---------------------------", / &
                      " - Coordinates misaligned. Expected format is:    -", / &
                      " - A30,3f8.3,f13.6 [string, x,y,x, esp_charge].   -", / &
                      " - Fix the pdb file and rerun                     -", /  &
                      " --------------------------------------------------" //  )
             STOP
          endif
          if(string(61:61).ne.".") THEN
             if(iline.eq.nbeg) write(6,4)
4            format(//"   -----------------** WARNING **-----------------------------", / &
                      "   - AM1 Mulliken charges misaligned or absent.              -", / &
                      "   - Expected format is :                                    -", / & 
                      "   - A30,3f8.3,f13.6 [string, x,y,x, esp_charge]             -", / & 
                      "   -                                                         -", / & 
                      "   - Progam will continue with Mulliken charges set to zero. -", / &
                      "   - Bond charge corrections (BCC) will be computed anyway   -", / &
                      "   -----------------------------------------------------------"//  )
             nocharges=.true. 
          endif
       endif
    end do

1   call up_low(resname,3)
    filename=resname//".pdb"
    open(unit=1,file=filename,form="formatted")
    filename=resname//".tpg"
    open(unit=2,file=filename,form="formatted")
    filename=resname//".log"
    open(unit=3,file=filename,form="formatted")

    write(3,*) n, " --> atoms found."
    nr=n
!---> memory allocation
    allocate(x(n),y(n),z(n),esp(n),ddc(n),charge(n),stat=ierr)
    allocate(c(n,7),stat=ierr)
    allocate(conn(n),stat=ierr)
    allocate(iring(n),stat=ierr)
    allocate(kring(6,nr),stat=ierr)
    allocate(bond(n,2),stat=ierr)
    allocate(igrp(n),bondi(7*n),bondj(7*n),in_ring(n),stat=ierr)
    allocate(atom_name(n),hybrid(n),stat=ierr)
    allocate(types(n),stat=ierr)
    allocate(ato2(n),stat=ierr)
    allocate(grpt(20,n),stat=ierr )
    allocate(impr(4,n),stat=ierr )
    allocate(mask(n),stat=ierr)
    allocate(bcc_bond(n,7),stat=ierr)
    allocate(bcc_bond_index(n,7),stat=ierr)
    allocate(bcc_index(n),stat=ierr)
    allocate(bcc_types(n),stat=ierr)
    rewind(5)

    if(nbeg.gt.1) THEN  
       do i=1,nbeg-1
          read(5,*)
       end do
    end if   
    do i=1,n
       if(nocharges) THEN
          read(5,10) string,x(i),y(i),z(i)
       else
          read(5,10) string,x(i),y(i),z(i),esp(i)
       end if
!      finds out two-digits atoms name 
       ato3=string(13:15)
       call stripspaces(ato3)
       ato2(i)=ato3(1:2)
10     FORMAT(A30,3f8.3,f13.6)
       lok=.false.
       call up_low(ato2(i),2)
       do j=1,nknown
          if(ato2(i).eq.atoms(j)) THEN 
             lok=.true.
             exit
          end if
       end do
       if(.not.lok) THEN 
          write(6,*) "** FATAL ERROR: atom ", ato2(i), i , " is not recognized"
          stop
       end if
    end do

!-->finds connection table
    dd=100.d0
    call bonds_matrix(bmat)
    mask=.false.
    impr=0
    igrp=0
    ibond=0
    do i=1,n
       call up_low(ato2(i),2)
       threshold0=threshold
       ato=ato2(i)
       k=0
       do j=1,n
          call up_low(ato2(j),2)
          ato=ato2(j)
          threshold0=threshold
          if(i.ne.j) THEN
             call get_threshold(ato2(i),ato2(j),threshold,bmat)
             threshold0=threshold*(1+0.1)
             dd= sqrt((x(i)-x(j))**2+(y(i)-y(j))**2+(z(i)-z(j))**2)
             if(dd.lt.threshold0) THEN

                ibond=ibond+1
                k=k+1
                if(k.gt.6) THEN 
                   write(6,*) "** FATAL ERROR: atom ", i , " has connectivity > 6 "
                   stop
                end if
                c(i,k)=j
             end if
             conn(i)= k   ! this is the number of neighbors.
          end if
       end do
    end do
    iring = 0
    in_ring = 0

    call find_units(conn,c,n,nunits)

    if(nunits.gt.1) THEN 
       write(6,*) "** FATAL ERROR:", nunits, " molecules found; Program stops; do one molecule at a time "  
       stop
    end if
     
    call finds_rings(c,conn,n,iring,kring,in_ring,nr,nrr)

    write(3,*) nrr, " --> rings found"

    call finds_conjg(c,conn,n,ato2,iring,x,y,z,ddc,nb,bond) 

    ngrp=0
!   assign all groups with hydrogens based on 4- and 3- connections atoms.
!   i.e.: XH3 XH2 or XH with X being an non hydrogen atoms
    do i=1,n
       if(conn(i).ge.3.and.(.not.mask(i))) THEN ! i-th atom is a nonH
          foundh=.false.
          do j=1,conn(i)
             iat=c(i,j)
             ato=ato2(iat)  ! check if atom-j attached to atom i  is an hydrogen
             call up_low(ato,1)
             if(ato.eq."h") THEN
                ngrp = ngrp+1
                grpt(2,ngrp)=i  ! i-th atom has connected H and is pafrt of the group
                igrp(i)=ngrp    ! this is the pointer to group for i-th X-atom
                jg=2
                mask(i)=.true.
                foundh=.true.
                exit
             end if
          end do
          do j=1,conn(i)
             iat = c(i,j)
             ato=ato2(iat)  ! check if atom-j  is an hydrogen
             call up_low(ato,1)
             if(ato.eq."h") THEN
                mask(iat)=.true.
                jg=jg+1
                grpt(jg,ngrp)=iat
                igrp(iat)=ngrp    ! this is the pointer to group for j-th H-atom
             end if
          end do
          if(foundh) grpt(1,ngrp)= jg  ! this is the number of atoms in the group
       end if
    end do
    ngrph=ngrp
    if(.not.nocharges) call  symmetrize_charges(n,ato2,ngrph,grpt,esp)  
    write(3,*) ngrp, " --> XH_n groups found."
!   assign all other groups

    do i=1,n
       if(conn(i).ge.2.and.(.not.mask(i))) THEN
          ngrp=ngrp+1
          grpt(2,ngrp)=i
          igrp(i)=ngrp    ! this is the pointer to group for i-th atom
          jg=2
          mask(i)=.true.
          do j=1,conn(i)
             iat=c(i,j)
             if(.not.mask(iat)) THEN
                mask(iat)=.true.
                jg=jg+1
                grpt(jg,ngrp)=iat
                igrp(iat)=ngrp    ! this is the pointer to group for i-th atom
             end if
          end do
          grpt(1,ngrp)= jg  ! this is the number of atoms in the group
       end if
    end do
    write(3,*) ngrp-ngrph, " --> XYZ.. groups found."

!-->final check for unassigned atoms
    do i=1,n
       if(.not.mask(i)) THEN
          do j=1,conn(i)
             iat=c(i,j)
             ig=igrp(iat)
             if(ig.ne.0) THEN
                nadd=grpt(1,ig)
                grpt(nadd+1,ig)=i
                grpt(1,ig)=nadd+1
                mask(i)=.true.
                igrp(i)=ig
                exit
             endif
          end do
       end if
    end do
    write(3,*) ngrp, " --> total groups found."

!-->write topology file, assign unique labels to atoms and make a tentative
!   GAFF-based assignement of atomic types.
    write(2,400) 
400 format("#"/"# ------ Done with primadorac1.0 --------"/"#")   
    write(2,*) "RESIDUE ",resname
    write(2,*) "atoms"

    call assign_type(n,types,ato2,c,conn,iring,kring,nr,nrr,x,y,z,esp,impr,ki,grpt,ngrp,ngrph,igrp,ddc,bond,nb,in_ring,hybrid)

!   compute bond charges corrections
    if(.not.lbcc) go to 401
    write(3,108) 
108 format(//"--> BOND CHARGE ASSIGNMENT (Jakalian et al JCC 2002)")

    k=0
    do i=1,n 
       if(types(i).eq."x") THEN 
          write(6,*) "** FATAL ERROR: atom ", i , " has no type (x) " 
          k=k+1
       end if
    end do
    if(k.gt.0) STOP

    call bcc(n,ato2,conn,c,types,iring,x,y,z,bcc_types,bcc_index,bcc_bond,bcc_bond_index,charge)  

401 k=0
    k0=0
    k1=0
    do i=1,ngrp
       write(2,*) "group"
       do j=2,grpt(1,i)
          iat=grpt(j,i)
          ato=ato2(iat)
          if(ato.NE."h") THEN
             if(ato2(iat).ne."cl".AND.ato2(iat).ne."br") THEN
                if(ato.ne."f") THEN
                   k=k+1
                   WRITE (atom_name(iat),'(a,i2.2)') ato,k
                else
                   k1=k1+1
                   WRITE (atom_name(iat),'(a,i2.2)') ato,k1
                end if
             ELSE
                k1=k1+1
                WRITE (atom_name(iat),'(a,i2.2)') ato2(iat),k1
             end if
          ELSE
             k0=k0+1
             WRITE (atom_name(iat),'(a,i2.2)') ato,k0
          END IF
          call up_low(atom_name(iat),3)
          write(2,20) atom_name(iat),types(iat), esp(iat)+charge(iat)
20        format(3x,a4,2x,a3,5x,f13.6)
       end do
    end do
    write(2,*) "end"
!   find all bonds
    k=0
    do i=1,n
       do j=1,conn(i)
          if(c(i,j).gt.i) THEN
             k=k+1
             bondi(k)=i
             bondj(k)=c(i,j)
          end if
       end do
    end do

    write(3,*) k, " --> bonds found."
    write(2,*) "bonds"
    write(2,40) (atom_name(bondi(j)),atom_name(bondj(j)),j=1,k)
40  format(4(3x,A4,2x,A4,3x))
    write(2,*) "end"
    write(3,*) ki, " --> improper torsions found."
    if(ki.gt.0) THEN 
       write(2,*) "imphd"
       write(2,50) (atom_name(impr(1,j)), atom_name(impr(2,j)), atom_name(impr(3,j)), &
            atom_name(impr(4,j)),j=1,ki)
50     format(2(3x,4(A4,1x)))
       write(2,*) "end"
    end if
    write(2,*) "termatom * *"
    write(2,*) "RESIDUE_END"
    nat=0
    k1=0
    k0=1
    write(3,109) 
109 format(//"--> FINAL ASSIGNMENT (N.B. when nrng>6 atom belongs to more rings)"/ &  
         "index",3x,"index(n)",4x,"label",4x,"label(n)",1x," Q(mull)", "   bcc  ",2x," am1-bcc",5x, & 
         "type",5x,"hybr",1x," nrng", " conn", 5x," neighbors")  
    do i=1,ngrp
       nat=nat+grpt(1,i)-1
       do j=2,grpt(1,i)
          iat=grpt(j,i)
          k1=k1+1
          write(1,30) k1,atom_name(iat),resname,k0,x(iat),y(iat),z(iat),esp(iat)+charge(iat)
30        format("HETATM",I5,1x,A4,1x,A3,2x,i4,4x,3f8.3,f13.6)
          write(3,110) iat,k1,ato2(iat),atom_name(iat),esp(iat),charge(iat),esp(iat)+charge(iat),types(iat),hybrid(iat),iring(iat),conn(iat),(c(iat,k),ato2(c(iat,k)),k=1,conn(iat))
110       format(i5,5x,i5,7x,a2,6x,a3,3x,3f9.4,7x,a2,6x,a3,1x,i5,i5,4(i4,1x,a2))
       end do
    end do

  end program primadorac
