!------------------------------------------------------------------------------------------
  subroutine symmetrize_charges(n,ato2,ngrph,grpt,esp)  
!------------------------------------------------------------------------------------------
!              symmetrize hydrogen charges on X-H_n groups 
!------------------------------------------------------------------------------------------

    implicit none 

!   ----> arguments
    character*2 ato2(n)
    integer n,ngrph,grpt(20,n)
    real*8 esp(n)

!   ----> local variables
    integer i,j,iat,nh
    real*8 tcharge 

!------------------executable statements-----------
    do i=1,ngrph
       tcharge=0.d0
       nh=0
       do j=2,grpt(1,i)
          iat=grpt(j,i)
          call up_low(ato2(iat),2)
          if(ato2(iat)(1:1).eq."h") THEN 
             tcharge=tcharge+esp(iat) 
             nh = nh + 1
          end if
       end do
       tcharge=tcharge/float(nh)
       do j=2,grpt(1,i)
          iat=grpt(j,i)
          call up_low(ato2(iat),2)
          if(ato2(iat)(1:1).eq."h") esp(iat)=tcharge
       end do
    end do
    return
  end subroutine symmetrize_charges
       
