      SUBROUTINE generate_rnd_rot(d)

************************************************************************
*   Time-stamp: <97/02/11 12:27:07 marchi>                             *
*                                                                      *
*                                                                      *
*                                                                      *
*======================================================================*
*                                                                      *
*              Author:  Massimo Marchi                                 *
*              CEA/Centre d'Etudes Saclay, FRANCE                      *
*                                                                      *
*              - Tue Feb 11 1997 -                                     *
*                                                                      *
************************************************************************

*---- This subroutine is part of the program ORAC ----*


*======================== DECLARATIONS ================================*

      IMPLICIT none

*----------------------------- ARGUMENTS ------------------------------*

      REAL*8 d(3,3)

*------------------------- LOCAL VARIABLES ----------------------------*

      REAL*8 ranf,q(0:4),norm

*----------------------- EXECUTABLE STATEMENTS ------------------------*

      q(0)=2.0D0*ranf()-1.0D0
      q(1)=2.0D0*ranf()-1.0D0
      q(2)=2.0D0*ranf()-1.0D0
      q(3)=2.0D0*ranf()-1.0D0
      norm=q(0)**2+q(1)**2+q(2)**2+q(3)**2
      norm=DSQRT(norm)
      q(0)=q(0)/norm
      q(1)=q(1)/norm
      q(2)=q(2)/norm
      q(3)=q(3)/norm


*---- ROTATION MATRIX IN TERMS OF QUATERNIONS: ----------------------*
 
      d(1,1)=-2.d0*q(2)**2-2.d0*q(3)**2+1.d0
      d(1,2)=2.d0*(-q(0)*q(3)+q(1)*q(2))
      d(1,3)=2.d0*(q(0)*q(2)+q(1)*q(3))
      d(2,1)=2.d0*(q(0)*q(3)+q(1)*q(2))
      d(2,2)=-2.d0*q(1)**2-2.d0*q(3)**2+1.d0
      d(2,3)=2.d0*(-q(0)*q(1)+q(2)*q(3))
      d(3,1)=2.d0*(-q(0)*q(2)+q(1)*q(3))
      d(3,2)=2.d0*(q(0)*q(1)+q(2)*q(3))
      d(3,3)=-2.d0*q(1)**2-2.d0*q(2)**2+1.d0

*----------------- END OF EXECUTABLE STATEMENTS -----------------------*

      RETURN
      END
