program volume_lig
  
  ! Compute the vdw volume of a ligand from a PDB file
  ! syntax:
  !  $ volume_lig < file.pdb
  
  IMPLICIT none
  
  real*8, allocatable :: x(:),y(:),z(:),rad(:),xl(:),yl(:),zl(:)
  real*8   xmin,ymin,zmin,xmax,ymax,zmax,rmax,duni,xr,yr,zr,xc,yc,zc,vbox,dist,rad2,find_vdw,volume
  integer n,i,k,npoints,nin,iline,seed,ierr,nbeg
  character*132 string 
  character*2 ato2
  character*3 ato3
  external find_vdw
  seed=187654
  
  iline=0
  n=0
  nbeg=0
  do
     iline=iline+1
     read(5,2,end=1) string
2    format(A132)
     if(string(1:4).EQ."ATOM".OR.string(1:4).EQ."HETA")  THEN
        n=n+1
        if(nbeg.eq.0) THEN 
           nbeg=iline
        end if
        if(string(35:35).ne.".") THEN
           write(6,3)
3          format(//" ------------** ERROR **---------------------------", / &
                " - Coordinates misaligned. Expected format is:    -", / &
                " - A30,3f8.3,f13.6 [string, x,y,x, esp_charge].   -", / &
                " - Fix the pdb file and rerun                     -", /  &
                " --------------------------------------------------" //  )
           STOP
        endif
     endif
  end do
  
1 allocate(x(n),y(n),z(n),xl(n),yl(n),zl(n),rad(n),stat=ierr)
  
  rewind(5)

  if(nbeg.gt.1) THEN  
     do i=1,nbeg-1
        read(5,*)
     end do
  end if
  do i=1,n
     read(5,11) string,x(i),y(i),z(i)
     !      finds out two-digits atoms name 
     ato3=string(13:15)
     call stripspaces(ato3)
     ato2=ato3(1:2)
     call up_low(ato2,2)
     rad(i)=find_vdw(ato2)
11   FORMAT(A30,3f8.3,22x,A2)
  end do
  
  xc=0.d0
  yc=0.d0
  zc=0.d0
  do  i=1,n
     xc = xc + x(i) 
     yc = yc + y(i) 
     zc = zc + z(i) 
  end do
  xc=xc/n
  yc=yc/n
  zc=zc/n
  k=0
  xmax=-1000.0
  ymax=-1000.0
  zmax=-1000.0
  xmin=1000.0
  ymin=1000.0
  zmin=1000.0
  rmax=0.d0
  k=0
  do i=1,n
     k=k+1
     rad2=rad(i)**2
     xl(k) = x(i)-xc
     yl(k) = y(i)-yc
     zl(k) = z(i)-zc
     if(rad2.gt.rmax) rmax=rad(i)
     if(xl(k).gt.xmax) xmax=xl(k)
     if(xl(k).lt.xmin) xmin=xl(k)
     if(yl(k).gt.ymax) ymax=yl(k)
     if(yl(k).lt.ymin) ymin=yl(k)
     if(zl(k).gt.zmax) zmax=zl(k)
     if(zl(k).lt.zmin) zmin=zl(k)
  end do
  xmax=xmax+rmax
  ymax=ymax+rmax
  zmax=zmax+rmax
  xmin=xmin-rmax
  ymin=ymin-rmax
  zmin=zmin-rmax
  vbox=(xmax-xmin)*(ymax-ymin)*(zmax-zmin)
  nin=0
  npoints=vbox/0.2**3  ! grip is 0.2 Angs in  each dir 
  call srand(seed)
  do i=1,npoints
     xr=xmin+rand()*(xmax-xmin)
     yr=ymin+rand()*(ymax-ymin)
     zr=zmin+rand()*(zmax-zmin)
     do k=1,n 
        dist=(xl(k)-xr)**2 +(yl(k)-yr)**2 +(zl(k)-zr)**2 ! distance bewteen random point and sphere center
        if(dist.lt.rad(k)) THEN 
           nin=nin+1
           exit
        end if
     end do
  end do
  volume = vbox*dfloat(nin)/dfloat(npoints)
  write(6,'(A6,2x,f10.3)') "volume", volume
  
  RETURN
end program volume_lig

SUBROUTINE up_low(string,ndim)
!--------------------------------------------------------------------------------------------
!   return string in lower case
!--------------------------------------------------------------------------------------------
  ! args
  INTEGER ndim
  CHARACTER*1 string(ndim)
  !local
  INTEGER n,nstr
  !  --executable statement
  DO n=1,ndim
     nstr=ICHAR(string(n))
     IF(nstr .GE. 65 .AND. nstr .LE.90) THEN
        string(n)=CHAR(nstr+32)
     END IF
  END DO
  
  RETURN
END SUBROUTINE up_low

subroutine StripSpaces(string)
  character(len=*) :: string
  integer :: stringLen 
  integer :: last, actual
  
  stringLen = len (string)
  last = 1
  actual = 1
  
  do while (actual < stringLen)
     if (string(last:last) == ' ') then
        actual = actual + 1
        string(last:last) = string(actual:actual)
        string(actual:actual) = ' '
     else
        last = last + 1
        if (actual < last) &
             actual = last
     endif
  end do
  
end subroutine StripSpaces
function find_vdw(atom)
  real*8 find_vdw
  character*2 atom
  character*1 ato1
  if(atom.eq."cl") then
     find_vdw=1.75
  else if (atom.eq."br") then
     find_vdw=1.85
  else     
     ato1=atom
     if(ato1.eq."c") then
        find_vdw=1.7
     else if(ato1.eq."h") then
        find_vdw=1.2
     else if(ato1.eq."o") then
        find_vdw=1.52
     else if(ato1.eq."n") then
        find_vdw=1.55
     else if(ato1.eq."f") then
        find_vdw=1.47
     else if(ato1.eq."p") then
        find_vdw=1.8
     else if(ato1.eq."s") then
        find_vdw=1.8
     else
        find_vdw=1.5
     endif
  endif
end function find_vdw

