#!/bin/bash
#
# Generate pdb of best docked pose ligand-receptor with vina
# must use autodock4.6.2
# downloaded from http://autodock.scripps.edu/ as autodocksuite-4.2.6-x86_64Linux2.tar
#
# mgltoolst must also be installed in your homedir
# (written by P.Procacci, UNIFI 2020)
#

# setup python instruments

if [ -z $1 ]; then
    echo " " 
    echo " This scripts runs vina on a lig+rec system "
    echo " N.B. mgltools MUST be installed  "
    echo " Syntax: " 
    echo " vina.bash  -l ligand.pdbfile -r receptor.pdbfile -x xcenter -y ycenter -z zcenter" 
    echo " " 
    exit
fi
if [ ! -d ~/mgltools ] ; then
    echo " no mgltools dir found in your home "
    echo "download and install mgltools_x86_64Linux2_1.5.6.tar.gz in your homedir"
    echo "and make a soft link to ~/mgltools" 
    exit
fi

while getopts "l:r:x:y:z:" opt; do 
    case $opt in 
	r) 
	    rec=$OPTARG
	    ;;
	l) 
	    lig=$OPTARG
	    ;;
	x) 
	    x=$OPTARG
	    ;;
	y) 
	    y=$OPTARG; 
	    ;;
	z) 
	    z=$OPTARG; 
	    ;;
	\?) 
	    echo "invalid option"
	    ;;
    esac
done

if [  -z $lig ] || [ ! -f $lig ]; then
    echo " no ligand pdbfile specified or not found"
    exit
fi

if [  -z $rec ] || [ ! -f $rec ]; then
    echo " no receptor pdbfile specified or not found"
    exit
fi

if [  -z $x ]; then
    echo " x-center was given "
    exit
fi
if [  -z $y ]; then
    echo " y-center was given "
    exit
fi
if [  -z $z ]; then
    echo " z-center was given "
    exit
fi


pysh=~/mgltools/bin/pythonsh
plig=~/mgltools/MGLToolsPckgs/AutoDockTools/Utilities24/prepare_ligand4.py
prec=~/mgltools/MGLToolsPckgs/AutoDockTools/Utilities24/prepare_receptor4.py

$pysh  $plig -l $lig    >& /dev/null
$pysh  $prec -r $rec    >& /dev/null


echo vina --receptor ${rec}qt --ligand ${lig}qt  --center_x $x --center_y $y  --center_z $z  --size_x 15.0 --size_y 15.0  --size_z 15.0 
vina --receptor ${rec}qt --ligand ${lig}qt  --center_x $x --center_y $y  --center_z $z  --size_x 15.0 --size_y 15.0  --size_z 15.0
pfx=`echo $lig | sed "s/\.pdb//g"`
grep -v BRANCH ${pfx}_out.pdbqt | grep -v ROOT | grep -v TORS > ${pfx}_poses.pdb

