#!/bin/bash

TOOLPATH=`which orac | sed "s?bin/orac?tools/templates?g"`
OLIBPATH=`which orac | sed "s?bin/orac?lib?g"`


if [ $# == "0" ] ; then
    echo "This script compute the REM flux using the standard method or the"
    echo "method based on the mean passage time(s) from 1 to n and N to n.  "
    echo "See  DOI: 10.1103/PhysRevE.78.061905 " 
    echo "  Syntax: "
    echo "       replica_flux.bash [opt] energy_file"
    echo "       where energy file is *any* energy file in thep PAR dirs "
    echo " "
    echo " Options:                    " 
    echo "        -r " 
    echo "          remove the intermediate XTMP.* files generated by fixrem.awk"
    echo " "
    echo "       Example" 
    echo "       replica_flux.bash -r PAR0001/1.rem"
    exit
fi

remove_TMP=0
# loop on options
while getopts ":r" opt; do 
    case $opt in 
	r) 
	    remove_TMP=1; 
	    ;;
    esac
done

# find  PREFIX_DIR and energy file filename
dire=${!#}
predir=`echo $dire | awk '{print substr($1,1,3)}'`
energy_file=`echo $dire | awk '{print substr($1,9,length($1))}'`

# fix the energy_file files if nprint_rem was greater than nstep_rem

 ((j=0))
for i in  $predir*/$energy_file ; do
    ((j=j+1))
    fixrem.awk $i > XTMP.$j
done
predir=`echo $predir | awk '{print tolower($1)}'`
nrep=`awk 'BEGIN{nmax=0} {if($1>nmax){nmax=$1}} END{print nmax}' XTMP.*`
flux.awk -v nrep=$nrep XTMP.* > $predir.flux
replica_flux.awk -v nrep=$nrep XTMP.* > ${predir}_mpt.flux

if [ $remove_TMP == "1" ]; then
    rm XTMP.* >& /dev/null
fi
