#!/usr/bin/awk -f
# compute energy distribution on the nodes of the replica progression .
# Default energy is the torsional
# syntax:
#      $ replica_dist.awk [ -v npot=npot -v resol=resol ] PAR*/energy_file
#      where 1.rem is is the REM energy file (e.g. 1.rem)
#      npot is an optional parameter for the energy
#        (3:bonded 4:tors 5:nonbond); 4 (torsional pote) is the defailt
#      resol is an optiional parameter for the resolution histogram
#        (default 1 kj/mol) 
#
BEGIN{
    imax=-1E6; imin=1E6; k=0
    if(ARGC==1) {
	print " compute energy distribution on the GE."
	print " Default energy is the torsional"
	print " syntax:"
	print "      $ replica_dist.awk [ -v npot=npot -v resol=resol ] PAR*/energy_file"
	print "      where 1.rem is is the REM energy file (e.g. 1.rem)"
	print "      npot is an optional parameter for the energy"
	print "        (3:bonded 4:tors 5:nonbond); 4+5 (torsional potential+nonbonded ) is the defailt"
	print "      resol is an optiional parameter for the resolution histogram"
	print "      (default 5 kj/mol) "
	exit
    }
}
{
    if(npot !~"[3-5]") {npot=0}; # torsional potential is the default
    if(resol !~"[0-9*]") {resol=5.0}; # 5 kj resolution is the default
    if(npot==0) {
	ibin=int(($4+$5)/resol); # Total energy: resolution is 5 kj 
    }
    else {
	ibin=int($npot/resol); # Selected Energy: resolution is 5 kj 
    }
    d[$NF,ibin]++ ;
    k++;
    if($NF>repmax) repmax=$NF
    if($2>repmax_batt) repmax_batt=$2
    if(ibin>imax) {imax=ibin}
    if(ibin<imin) {imin=ibin}
}
END{
    if(ARGC==1) { exit }
    print "# Nreplica="repmax "  Npoints=" k/repmax " Resol = " resol " NBatt=" repmax_batt/repmax " npot =" npot
    norm = repmax_batt/k
    for(i=imin; i<=imax; i++) {
	printf  "%8.1f", i*resol;
	for(j=1; j<=repmax ; j++) {
	    printf "%8.3f",  norm*d[j,i]
	}
	printf "\n"
    }
}
