#!/bin/bash
# compute free energy change between the end-states using MBAR from HREM run
# for details see J Chem Phys. 2013 Sep 28;139(12):124105. doi: 10.1063/1.4821814.
#
if [ $#  -eq 0 ]; then
   echo " "
   echo " compute free energy change between the end-states using MBAR "
   echo " for details see J Chem Phys. 2013 Sep 28;139(12):124105. doi: 10.1063/1.4821814"
   echo " syntax: "
   echo " $ mbar.bash DIR energy_file [t]"
   echo ""
   echo "            DIR are the three first characters identifying the REM directories."
   echo "            Example: DIR=PAR if REM dirs are PAR0001, PAR0002 ..."
   echo "            energy_file is the name of the file in the REM dirs with scaled energies"
   echo "            (e.g. energy_file=1.rem) " 
   echo "            if t is given the energy files is printed every t fs "
   echo "            N.B: t must be a multiple of print frequence in the energy file"
   exit
fi
# join  all enery files 
dire=$1

if [ -s $3 ] ; then
    cat ${1}0*/$2 | awk '{print $2, $3/2.4942, $4/2.4942, $5/2.4942}' > $1.ene
else
    cat ${1}0*/$2 > tmp.ene
    awk -v n=$3 '{a=int($1); if(a%n==0 && $1 != 0.0) print $2, $3/2.4942, $4/2.4942, $5/2.4942}' tmp.ene > $1.ene
fi

# prepare the scaling factor file
awk '{if($1 ~ "[0-9]" ) print $2, $3,$4}' ${1}0001/REM.set >  $1.par

#  do mbar calculations of the DG_k along the progression. 
#  In this step $1.mbar.w are the MBAR weights for all sampled points in energy_file
mbar $1.par $1.ene  > $1.mbar.w  2> $1.DG; 

# Print out the free energy between the end-states
awk '{if($1 !~ "[dnDp].*") print }' $1.DG  | awk '{dg+=$3}END{print "DG=" 0.596*dg}' 

# add time label to weights
if [ -s $3 ] ; then
    cat ${1}0*/$2 > REM.ene
else
    cat ${1}0*/$2 > tmp.ene
    awk -v n=$3 '{a=int($1); if(a%n==0 && $1 != 0.0) {print}}' tmp.ene > REM.ene
    rm tmp.ene
fi

grep -v ZBRENT $1.mbar.w > tmp.w 
paste tmp.w REM.ene > $1.mbar.w
