#!/usr/bin/awk -f
BEGIN{
    if(ARGC==1) {
	print ""
	print "PROCESS vDSSB TABLE (generated with 'vdssb.bash'):"
	print " "
	print " Example of usage: "
	print "      make_tables.awk FILENAME"   
	print " "
	print "   First line of the FILENAME must specify the desired fields as "
	print "   Field1 Field2 Field3 etc..."
	print "   The vdssb.bash-generated  table follows"
	print " "
	print " " 
	print "Example of vDSSB field-modified Table:" 
	print 
	print  " ql DG1 DG2 DG3 DGj DGq ADb ADu "
	print  "g01 DG= x1 ...."
	print  "g02 DG= x2 ...."
	print  "g03 DG= x3 ...."
	print  "...."
	print
	print "This will print 8 fields of the vDSSB Table"
	print  " corresponding to ql DG1 DG2 DG3 DGj DGq ADb ADu "
	exit
    }
}
{
    if(NR==1) {
	printf "#"
	NFIELDS=NF
	for(i=1; i<=NF; i++) {
	    ff[i]=$i; 
	}
	for(i=1; i<=NFIELDS; i++) {
	    if((substr($i,1,2)=="DG" || substr($i,1,2)=="ms") && $i!="DG") {
		if (i==1) {
		    printf "%12s",ff[i] }
		else {
		    printf "%13s",ff[i]
		}
	    } else {
		if(i==1) {
		    printf "%7s",ff[i]
		}
		else{
		    printf "%8s",ff[i]
		}
	    }
	}  
	printf "\n"
    }
# now parse the data and look for the selected fields 
    if(NR>1) {
	printf "%4s", $1
	for(j=1; j<=NFIELDS; j++) {
#	print j, ff[j]
	    for(i=1; i<=NF; i++) {
		field=substr($i,1,length($i)-1)
#	    print i,field,$i,substr($i,1,length($i)-1)
		if (field==ff[j]) {   # field found
		    printf "%8s",$(i+1); 
		    # print the error if field==DG*
		    if(substr(ff[j],1,2)=="DG" && substr($i,3,1)!="=") {
			printf "%5s",$(i+2);
		    }
		    if(substr(ff[j],1,3)=="msb" && substr($i,3,1)!="=") {
			printf "%5s",$(i+2);
		    }
		    if(substr(ff[j],1,3)=="msu" && substr($i,3,1)!="=") {
			printf "%5s",$(i+2);
		    }
		}
	    }
	}
	printf "\n"
    }
}
