#!/usr/bin/awk -f
BEGIN{
    if(ARGC==1) {
	print " "
	print " computes isothermal compressibility from PDB (cubic sample)" 
	print " "
	print "Syntax:"
	print "    isothermal_compr.awk PDBFILE "
	exit
    }
}
{
    if($1=="REMARK") {
	V+=$6^3; 
	V2+=$6^6
	i++
    }
}
END{
    if(ARGC==1) {exit}
    dv2=V2/i-(V/i)^2;
    V=V/i;
    kbt=8.314*300/6.022E23 # joule
    k=1E-30*dv2/(kbt*V)
    print k
}
