#!/bin/bash 
#
# produce REM.set file with scaling protocol for lambda-hopping/FEP+ emulation with ORAC
# 
if [ $#  -eq 0 ]; then
    echo "This script produces the REM.set file with scaling protocol for lambda-hopping/FEP+"
    echo "emulation with ORAC (see orac manual for starting from a user-defined REM.set)"  
    echo " syntax: "
    echo " $ scaling.bash [opt ] nreplica "
    echo ""
    echo "            where scal_factor is the scaling factor for the hot zone"
    echo "            nreplica is the number of replicas (must be EVEN) "
    echo " Options:                                                                                 " 
    echo "        -b 'nbatteries'" 
    echo "          'nbatteries' is the number of batterise (replicates); default is 1"
    echo "        -s 'max scale for the hot-zone (default is 0.25 as in FEP+) '" 
    echo "          'nbatteries' is the number of batterise (replicates); default is 1"
    echo "        -f " 
    echo "          if given, hot-zone scaling is applied also to bend+bond (default is no)"
    exit
fi

scale=0.25
batt=1
fast=0
while getopts ":b:fs:" opt; do 
    case $opt in 
	b)
	    batt=$OPTARG
	    ;;
	f) 
	    fast=1
	    ;;
	s)
	    scale=$OPTARG
	    ;;
    esac
done

nrep=${!#}
nscal=`echo $nrep | awk '{print $1/2}'`

rm [xX].? >& /dev/null 
awk -v s=$scale -v n=$nscal 'BEGIN{for(i=1;i<=n;i++) printf "%15.6f\n", s^((i-1)/(n-1))}' /dev/null  > x.1
awk -v s=$scale -v n=$nscal 'BEGIN{for(i=1;i<=n;i++) printf "%15.6f\n", s^((i-1)/(n-1))}' /dev/null | tac > x.2
if [ $fast == 1 ] ; then 
    cat x.1 x.2 > X.1
else
    awk -v n=$nrep 'BEGIN{for(i=1; i<=n; i++) {printf "%10.4f\n", 1.0 }}' /dev/null > X.1
fi
cat x.1 x.2 > X.2
# lambda = 0.05 is the last state to be sampled
awk -v s=0.05 -v n=$nrep 'BEGIN{for(i=1;i<=n;i++) printf "%15.6f\n", s^((i-1)/(n-1))}' /dev/null  > X.3
echo "Scaling factors: " > REM.set 
echo "n.Ensemble      Bending+Bonding               Torsions+1-4                  Non-Bonded" >> REM.set

for i in `awk -v n=$batt 'BEGIN{for( i=1; i<=n; i++) {printf "%4d", i}}' /dev/null` ; do 
    (( jbeg=((i-1)*$nrep) ))
    paste X.1 X.2 X.3 | awk -v jb=$jbeg 'BEGIN{i=jb}{i++; printf "%10d%25.6f%25.5f%25.6f\n",  i, $1,$2,$3}' >> REM.set
done
echo "REM.set done!"
echo "Scale="$scale " Nreplica="$nrep " and Replicates(batteries)="$batt
echo " "
echo "Recall to set '2' as fourth argument in 'SETUP' command of '&REM' namelist" 

rm [xX].? >& /dev/null 
exit 



