#!/bin/bash

leave=0
rem=0
wat=opc3

TOOLPATH=`which orac | sed "s?bin/orac?tools/templates?g"`
OLIBPATH=`which orac | sed "s?bin/orac?lib?g"`

while getopts ":rw:" opt; do 
    case $opt in 
	r) 
	    rem=1; 
	    ;;
	w) 
	    wat=$OPTARG; 
	    ;;
    esac
done

if [ $# == "0" ] ; then
    echo "This script generates the restart files for the growth of the ligand in bulk "
    echo " "
    echo "  Syntax: "
    echo "       growth.bash  [-r ] compound"
    echo "  -r is used if rem_test has been generated"
    exit
fi

# syntax is OK; get force_field and cd to compound dir
# and make the restart file 


dire=${!#}
if [ -d $dire ] ; then 
    cd $dire 
else
    echo " No "$dire " directory found"
    exit
fi
grep HETATM $dire.pdb > lig.pdb 
ligand=`grep "RESIDUE " $dire.tpg | awk '{print $2}'`
# overwrite lig.pdb if rem_start is present
if [ -f rem_start.pdb ] ; then
    grep -i $ligand rem_start.pdb > lig.pdb
fi

# make the rem_test dir
if [ $rem == 0 ] ; then
   if [ ! -d rem_test ] ; then 
       mkdir rem_test
   fi
   nscaled=`wc lig.pdb | awk '{print $1}'`
   nrep=`awk -v n=$nscaled 'BEGIN{nr=int(12*sqrt(n/140)); print nr+nr%2}' /dev/null`
   sed "s/ghost/$i/g" $TOOLPATH/rem_growth.in  > rem_test/rem.in
   sed -i "s/ligand/$ligand/g" rem_test/rem.in
   sed -i "s/compound/$dire/g" rem_test/rem.in
   sed -i "s/nreplica/$nrep/g" rem_test/rem.in
   
   # launch the REM on ${dire} arg   
   cd rem_test
   echo "running REM for gas-phase ligand "$ligand"...."
   mpirun -n $nrep orac_mpi < rem.in > rem.out

   cd ../
fi

natoms=`wc -l lig.pdb | awk '{print $1}'`

if [ ! -d RESTART ]; then   # check RESTART dir 
   mkdir RESTART
   echo "RESTART  dir done"
fi
if [ ! -d rem_test ]; then  # check rem_test dir 
    echo " rem_test  dir not found "
    exit
fi


cd rem_test

# generate input files 

sed "s/ghost/$dire/g" $TOOLPATH/do_rest_wat-gaff-on.in > tmp.in
sed -i "s/natoms/$natoms/g" tmp.in
sed -i "s/ligand/$ligand/g" tmp.in
sed -i "s?LIBPATH?$OLIBPATH?g" tmp.in 
sed -i "s?TOOLPATH?$TOOLPATH?g" tmp.in 
#extract ~ 500 sampled state from REM pdbs. 
echo "creating the ghost configurations ..."
get_replica_pdfile.awk PAR*/rem.pdb > tmp.file

# split the files 
((nline=$natoms+2))
split -a 3 -l $nline tmp.file
((jj=0))
nfiles=`ls x??? | wc -l`

echo "generating the restart files.."$nfiles
for i in x???; do 
    ((jj=$jj+1))
    grep -v END $i | grep -v REM | sed "s/  1  /  2  /g" > x.$i 
    indnum=`printf "%04d" $jj`
    cat x.$i $TOOLPATH/tip3p-1728.pdb > start.pdb
    orac < tmp.in > tmp.out
    echo "restart file "$indnum " Done;  FileSize= "`ls -ltr ../RESTART/file.rst | awk '{print $5}'` 
    mv ../RESTART/file.rst ../RESTART/${dire}_$indnum.rst
done
rm tmp.file >&/dev/null

# go back to work dir.

rm -fr ../u-RSTRT
mv ../RESTART ../u-RSTRT 
    
rm x.x??? x??? y.* >& /dev/null; 
cd ../../



