#!/usr/bin/awk -f
#
# this program extracts a single replica-state from a HREM/REM trajectory file
#
# syntax:
# $ get_replica_pdfile.awk [-v nrep=replica_index] xyzfile
#
# replica_index: integer indicating the replica state (if not given, nrep=1)
# pdbfile: HREM pdb trajectory
#
#
# set the default target replica 
BEGIN{
    if(ARGC==1) {
	print ""
	print " This program extracts a single replica-state from a HREM/REM xyz trajectory file"
	print ""
	print " Syntax:"
	print " $ get_replica_xyzile.awk [-v nrep=replica_index] xyzfile"
	print ""
	print " replica_index: integer indicating the replica state (if not given, nrep=1)"
	print ""
	print " Example:  "
	print " get_replica_xyzile.awk -v nrep=8 PAR*/rem.xyz "
	print " extract state/node 8 from REM-generated xyz files in the PAR* directories"
	print ""
	exit
    }
    if(nrep==0) {nrep=1}
}

# scan the file and select only replica=nrep

{   if(NR==1) {n=$1}
    if($1=="Time:") {
	if($NF==nrep) {
	    print n
	    print $0
	    prt =1
	}
	else {
	    prt=0
	}
#	print nrep,prt,$NF
    }
    if(prt==1 && NF==4) {print $0}
}
