#!/usr/bin/awk -f
#
# this program extracts a single replica-state from a HREM/REM trajectory file
#
# syntax:
# $ get_replica_pdfile.awk [-v nrep=replica_index] pdbfile
#
# replica_index: integer indicating the replica state (if not given, nrep=1)
# pdbfile: HREM pdb trajectory
#
# set the default target replica 

BEGIN{
    if(nrep==0) {nrep=1}
    if(ARGC==1) {
	print ""
	print " This program extracts a single replica-state from a HREM/REM trajectory file"
	print ""
	print " Syntax:"
	print " get_replica_pdfile.awk [-v nrep=replica_index] pdbfile"
	print ""
	print " replica_index: integer indicating the replica state (if not given, nrep=1)"
	print " pdbfile: HREM pdb trajectory"
	print ""
	print " Example:  "
	print " get_replica_pdbfile.awk -v nrep=8 PAR*/rem.pdb "
	print " extract state/node 8 from REM-generated pdb files in the PAR* directories"
	print ""
	exit
    }
}

# scan the file and select only replica=nrep

{
    if($1=="REMARK" || $1=="Time:" ) { if($NF==nrep) {
	    prt =1
	}
	else {
	    prt=0
	}
	if(prt==1) print
#	print nrep,prt,$NF
    }
    if ($1=="ATOM" && prt==1) print
    if ($1=="END" && prt==1) print
}

