#!/usr/bin/awk -f
BEGIN{
    start=0;
    end=0
    for(i=1; i<=nrep; i++) {
	   zd[i]=0
	   zu[i]=0
       }

    if(ARGC==1) {
	print " script for computing the flux in replica exchange ( 10.1103/PhysRevE.78.061905 )"
	print " syntax :"
	print "        replica_flux.awk -v nrep=n PAR*/energy-file"
	print "        where energy-file  is the REM scaled energy files."
	print "        nrep is the number of NODES or STATES"
	exit
    }
}
{
    if($NF==1) {
	start=1
	end=0
    }
    if($NF==nrep) {
	end=1
	start=0
      }
      
    for(i=2; i<=nrep-1; i++)  {
	   if($NF==i && start==1) {
		 zu[i]++
	     }
	   if($NF==i && end==1) {
		 zd[i]++
	     }	     
       }
}
END {
    for(i=2; i<=nrep-1; i++)  {
	print  zu[i]/(zu[i]+zd[i]), zu[i],zd[i]
    }
}
