#!/bin/bash
#
# check for disulphid bonds (rec.pdb and seq contains all cysh at this stage)
#
export LC_NUMERIC="en_US.UTF-8"

if [ $# == "0" ] ; then
    echo " Script is used by pdbrestore.bash for fixing cys-cys disulphide "
    echo " "
    echo " Syntax: fix_cys.bash filein filepdb "
    exit
fi
filein=$1
filepdb=$2

rm -fr tmp.disulf >& /dev/null
check_disulphide_PDB.awk $filepdb > tmp.disulf
disl=`wc tmp.disulf | awk '{print $1}'`
if [ $disl != "2" -a $disl != "0" ] ; then
#    echo "     cys-cys bonds found; updating the input accordingly... "
    # remove HG1 atoms by psfgen from pdb   
    for i in `awk '{if(NF==6) printf "%5d%5d", $5,$6}' tmp.disulf `; do
	awk -v n=$i '{if($1!="REMARK" && $1~"^ATOM") {nres=substr($0,23,4); if(nres!=nres_old) {ires++; nres_old=nres}; if(ires==n && $3=="HG1") {found=1}  else {print} }}' $filepdb  > tmp.pdb 
	mv tmp.pdb $filepdb
    done
    # update seq.tmp
    for i in `awk '{if(NF==6) printf "%5d%5d", $5,$6}' tmp.disulf `; do
	awk -v icys=$i '{if(substr($1,1,1)~"[a-z]") {i++; if($1=="cysh" && i==icys) {print "cys", $2,$3} else if($1=="cysh-h") {print "cys-h",$2,$3} else if($1=="cysh-o") {print "cys-o",$2,$3} else {print}}else{print}}' $filein > in.tmp;
	mv in.tmp $filein;
    done
    ncys=`wc -l  tmp.disulf | awk '{print $1}'` 
    for((i=1; i<=$ncys ; i++)) ; do
	linecys="`tail -$i tmp.disulf | head -1`"
        sed -i "s/#TPGCYS/#TPGCYS\n$linecys/g" $filein
    done
else
    exit
fi
