#! /usr/bin/awk -f
# print energies of test_times file relative to the corresponding values at time 0 
BEGIN{
    start=0
    if (ARGC==1) {
	print "" 
	print "Print energies of test_times file relative to the corresponding values at time 0" 
	print "  Syntax: energies.awk [ -v r=1 ] energy_file"
	print "    r=1 is specified if an equilibration part is to be skipped " 
	exit
    }
    if(r!=1) {
	start=1    
    }
}
{
    if(start==1 && NR==2) {
        print "#       time(fs)      ETOT         ESLV         ESLT         ESLV-SLT      EKIN         EPTOT        EREAL          PV         HPOT         KINH       PME"
	ETOT0=$3;
        ELSV0=$4;
        ELST0=$5;
        ESLV_SLT0=$6;
        EKIN0=$7; 
        EPTOT0=$8;
        EREAL0=$9;
        PV0=$10;
        HPOT0=$11;
        KINH0=$12;
        PME0=$3-$9;
    }
    if ( r == 1 && $1 == "time" && $2==0) {
	echo "HEEERE"
	start=1 
        print "#       time(fs)      ETOT         ESLV         ESLT         ESLV-SLT      EKIN         EPTOT        EREAL          PV         HPOT         KINH       PME"
	ETOT0=$3;
        ELSV0=$4;
        ELST0=$5;
        ESLV_SLT0=$6;
        EKIN0=$7; 
        EPTOT0=$8;
        EREAL0=$9;
        PV0=$10;
        HPOT0=$11;
        KINH0=$12;
        PME0=$3-$9;
    }    
    if(start==1 && $1 != "#") {
	printf "%13.2f%13.3f%13.3f%13.3f%13.3f%13.3f%13.3f%13.3f%13.3f%13.3f%13.3f%13.3f\n",\
	$2/1000.0,\
 	$3-ETOT0,\
	$4-ELSV0,\
	$5-ELST0, \
	$6-ESLV_SLT0,\
	$7-EKIN0,\
        $8-EPTOT0,\
	$9-EREAL0,\
	$10-PV0,\
	$11-HPOT0,\
	$12-KINH0,\
        $3-$9-PME0
    }
}
