#!/bin/bash

test=0
slow=0
errpdb=0
ubound=0
fixrem=0
opls=0
odir=`which orac | sed "s?bin/orac??g" | sed "s?$HOME?\~?g"`
CURDIR=`pwd`
TOOLPATH=`which orac | sed "s?bin/orac?tools/templates?g"`
OLIBPATH=`which orac | sed "s?bin/orac?lib?g" | sed "s?$HOME?\~?g"`

function fixreminput {
    slvmol=`grep "Solvent Mol" $1.out | awk '{print $2}'`
    lx=`grep REMARK $1_1.pdb | tail -1 | awk '{print $6}'` 
    ly=`grep REMARK $1_1.pdb | tail -1 | awk '{print $10}'` 
    lz=`grep REMARK $1_1.pdb | tail -1 | awk '{print $14}'`
    solute=`grep Atoms $1.out  | head -1 | awk '{print $2}'`
    ((natoms=`grep "Number of atoms " $1.out  | awk '{print $5}'`))
    ((natoms=natoms+2))
    if [ $1 == "md" ]; then
	namerem="rem.in"
	time=`awk -v n=$natoms 'BEGIN{printf "%7d",  4500000*12000/n }' /dev/null`
    else
	time=`awk -v n=$slvmol 'BEGIN{printf "%6d",  3000000}' /dev/null`
	namerem="urem.in"
    fi
    nbatt=8
    if [ $1 == "md" ] ; then
	nbatt=`awk -v t=$time 'BEGIN{nb=int(8*4.5*1000000/t); print nb +nb%2}' /dev/null`
    fi 
    nscaled=`awk '/define/{a+=$3-$2}END{print a}' $namerem`
    nrep=`awk -v n=$nscaled 'BEGIN{nr=int(12*sqrt(n/140)); print nr+nr%2}' /dev/null`
    nmpi=`awk -v nrep=$nrep -v nbatt="$nbatt" 'BEGIN{print nbatt*nrep}' /dev/null`
    ntotal=`awk -v nmpi=$nmpi 'BEGIN{print nmpi*6}' /dev/null` 
    awk '{if(substr($0,4,16) =="READ_TPG_ASCII ~" || substr($0,4,16) =="READ_TPG_ASCII /" ) {print "  ",$1," LIBPATH/amber99sb-ildn.tpg"} else {print}}' $namerem | \
    awk '{if(substr($0,4,16) =="READ_PRM_ASCII ~" || substr($0,4,16) =="READ_PRM_ASCII /" ) {print "  ",$1," LIBPATH/amber99sb-ildn.prm"} else {print}}' > x.tmp 
    mv x.tmp $namerem
    sed -i "s?LIBPATH?$OLIBPATH?g" $namerem
    sed -i "s?TPG_ASCII ${dire}?TPG_ASCII ../${dire}?g" $namerem
    sed -i "s?PRM_ASCII ${dire}?PRM_ASCII ../${dire}?g" $namerem
    if [ $1 == "md" ] ; then
	tail  -$natoms $1_1.pdb > rem_start.pdb
    else
	tail  -$natoms $1_1.pdb > urem_start.pdb
    fi
    sed -i "s/nmolslv/$slvmol/g" $namerem
    sed -i "s/lxcell/$lx/g" $namerem
    sed -i "s/lycell/$ly/g" $namerem
    sed -i "s/lzcell/$lz/g" $namerem
    sed -i "s/pdbcode/${dire}/g" $namerem
    sed -i "s/remtime/$time/g" $namerem
    sed -i "s/nbatt/$nbatt/g" $namerem
    sed -i "s/nreplica/$nrep/g" $namerem
    sed -i "s/nmpinth/$ntotal/g" $namerem
    sed -i "s/nmpi/$nmpi/g" $namerem
    sed -i "s/0.15/0.0266/g" $namerem
    if [ $1 == "md" ]; then 
	sed -i "s?RESTART/$dire?b-RSTRT/$dire?g" $namerem
    else
	sed -i "s?RESTART/$dire?a-RSTRT/$dire?g" $namerem
    fi
    printf "nw =%5d" $slvmol
    printf "   ns =%5d" $solute
    ((natoms=natoms-2))
    printf "   natoms  =%6d" $natoms
    printf "   lx = %7.2f" $lx
    printf "   ly = %7.2f" $ly
    printf "   lz = %7.2f" $lz
    printf "   time = %7d" $time
    printf "   nbatt = %5d" $nbatt
    printf "\n"
}


while getopts ":tsuoO" opt; do 
    case $opt in 
	t) 
	    test=1; 
	    ;;
	s) 
	    slow=1; 
	    ;;
	u) 
	    ubound=1; 
	    ;;
	o) 
	    fixrem=1; 
	    ;;
	O) 
	    opls=1; 
	    ;;
    esac
done


dire=${!#}

if [ $# == "0" ] ; then 
    echo ""
    echo "This script generates the md.in and rem.in file from a pdbcode instance"
    echo ""
    echo " Syntax: do_md.in.bash [opt] pdbcode"
    echo "          where pdbcode is the directory produced with the script test_pdb_with_orac.bash "  
    echo "          pdbcode dir contains the starting pdb file with the ligand and the target       "  
    echo " Options:                                                                                 " 
    echo "        -t " 
    echo "          test only with energy_then_die option" 
    echo "        -s " 
    echo "          do slowly: 20 steps at low T then starts test " 
    echo "        -u " 
    echo "          do rem.in for unbound ligand (free ligand in bulk water)" 
    echo "        -o " 
    echo "          do rem.in without running orac"
    echo "        -O " 
    echo "          use OPLS ffield"
    echo ""
    exit
fi
if [ ! -d $dire ]; then 
    echo "directory not found ; EXIT "
    exit
fi
#
#   execution starts here

# this is done if -u is given
if [[ $ubound == 1 ]] ; then
   if [[ $fixrem == 1 ]] ; then 
	cd ${dire}
	fixreminput u
	cd ..
	exit
   fi
   grep "HETATM"  ${dire}/${dire}.pdb > tmp.pdb
   uorient
   resname=`grep RESIDUE ${dire}/${dire}.tpg | awk '{print $2}'`
   if [  -s startu.pdb  ] ; then mv startu.pdb ${dire} ; fi
   echo "&PARAMETERS  " > param.tmp
   echo "   READ_TPG_ASCII "${dire}.tpg  >> param.tmp
   echo "   READ_TPG_ASCII ORAC_HOME/lib/amber99sb-ildn.tpg " >> param.tmp
   echo "   READ_PRM_ASCII "${dire}.prm  >> param.tmp
   echo "   READ_PRM_ASCII ORAC_HOME/lib/amber99sb-ildn.prm " >> param.tmp
   echo "   WRITE_TPGPRM_BIN " ${dire}.tpgprm  >> param.tmp
   echo "   JOIN SOLUTE  "  >> param.tmp
   echo "       "$resname  >> param.tmp
   echo "   END  "  >> param.tmp
   echo "   JOIN SOLVENT  "  >> param.tmp
   echo "       tip3 " >> param.tmp
   echo "   END  "  >> param.tmp
   echo "&END  " >> param.tmp
#  do u.in
   
   cat setup.tmp param.tmp solvent.tmp $TOOLPATH/u1.in potential.tmp $TOOLPATH/u2.in > ${dire}/u.in;
   sed -i "s?ORAC_HOME?$odir?g" ${dire}/u.in
   #  do $namerem
   grep -v WRITE_TPGPRM param.tmp > x.0 ; mv x.0 param.tmp;   # we don't want write_tpgprm to be written on PAR
   echo "#!&PAR" > x.0 
   echo "#  YOU WILL NEED ~ nreplica REPLICAS FOR THIS RUN  " >> x.0
   echo "#  THE TOTAL NUMBER OF MPI PROCESSES SHOULD BE nmpi" >> x.0
   echo "#  THE TOTAL NUMBER OF CPU cores SHOULD BE nmpinth"  >> x.0
   cat $TOOLPATH/header_OMP x.0 rem.tmp rem_setup.tmp param.tmp rem_solvent.tmp $TOOLPATH/rem1.in \
       potential.tmp $TOOLPATH/remt.in prop.tmp > ${dire}/urem.in
   sed  -i "s?ORAC_HOME?$odir?g" ${dire}/urem.in
   rm x.0
   cd ${dire}
   printf ${dire}
   printf " -> "  
   if [ $opls == 1 ] ; then
       resname=`awk 'BEGIN{ok=0} {if(ok==1) {print $1; ok=0};if($1=="JOIN" && $2=="SOLUTE") {ok=1}}' u.in`
       sed -i "s/83333/50\n   FFIELD opls/g" u.in  
       sed -i "s/amber99sb-ildn/opls2015/g" u.in
       sed -i "s/${dire}/${dire}-o/g" u.in
       sed -i "s/  $resname/  lig/g" u.in
       sed -i "s/startu/unk/g" u.in
   fi

   orac < u.in >& u.out ;
   fixreminput u ;
   if [ $opls == 1 ] ; then
       sed "s/83333/50\n   FFIELD opls/g" urem.in > urem-o.in
       sed -i "s/amber99sb-ildn/opls2015/g" urem-o.in 
       sed -i "s/${dire}/${dire}-o/g" urem-o.in 
       sed -i "s/  $resname/  lig/g" urem-o.in 
   fi
   if [ ! -d a-RSTRT ]; then
       mkdir a-RSTRT
   fi
   exit
fi    

# do the bound state rem.in and rem_start.pdb
if [[ $fixrem == 1 ]] ; then 
    cd ${dire}
    fixreminput md
    cd ..
    exit
fi
if [ -f ${dire}/1.pdb ] ; then
    nna=`tail -2 ${dire}/1.pdb | head -1 | awk '{print $2+1}'`
    tail -$nna ${dire}/1.pdb | grep -v END | sed "s/  1  /  0  /g" > tmp.pdb
else
    echo "file " ${dire}/1.pdb " (produced by test_orac_pdb,bash) not found "
    exit
fi

orient
mv start.pdb ${dire}

# the following namelist should be generated:
# setup.tmp; solvent.tmp potential.tmp 


# extract PARAMETERS NAMELIST form input 
rm param.tmp >& /dev/null
awk '{if($1=="&PARAMETERS") {ok=1}; if($1=="&END"){ok=0}; if(ok==1) {print}}' ${dire}/${dire}.in  > param.tmp;
echo "   WRITE_TPGPRM_BIN " ${dire}.tpgprm  >> param.tmp
echo "   JOIN SOLVENT " >> param.tmp
echo "       tip3     " >> param.tmp
echo "   END          " >> param.tmp
echo "&END            " >> param.tmp

# do md.in
if [ $test == 1 ] ; then 
    cat setup.tmp param.tmp solvent.tmp $TOOLPATH/1tmd.in potential.tmp $TOOLPATH/2md.in > ${dire}/md.in;
else
    cat setup.tmp param.tmp solvent.tmp $TOOLPATH/1md.in potential.tmp $TOOLPATH/2md.in > ${dire}/md.in;
fi
sed -i "s?ORAC_HOME?$odir?g" ${dire}/md.in

# do rem.in
grep -v WRITE_TPGPRM param.tmp > x.0 ; mv x.0 param.tmp;   # we don't want write_tpgprm to be written on PAR
cat $TOOLPATH/header_OMP rem.tmp rem_setup.tmp param.tmp rem_solvent.tmp $TOOLPATH/rem1.in \
    potential.tmp $TOOLPATH/remt.in prop.tmp > ${dire}/rem.in

cd ${dire}

printf ${dire}
printf " -> "  

if [ $opls == 1 ] ; then
    resname=`awk 'BEGIN{ok=0} {if(ok==1) {print $1; ok=0};if($1=="JOIN" && $2=="SOLUTE") {ok=1}}' rem.in`
    sed -i "s/83333/50\n   FFIELD opls/g" md.in  
    sed -i "s/amber99sb-ildn/opls2015/g" md.in
    sed -i "s/${dire}/${dire}-o/g" md.in
    sed -i "s/  $resname/  lig/g" md.in
fi

if [[ $slow == 1 ]] ; then 
    sed -i "s/HEAVY//g" md.in
    orac < md.in >& md.out ;  
else
    orac < md.in >& md.out ;  
fi 

#check for "file not found" (propblems with ~ expansion?)" 
errpdb=`grep "file not found"  md.out | awk '{print  $NF}'`
if [ ! -z $errpdb ] ; then
    if [ $errpdb == "found" ] ; then
	sed -i "s?\~?$HOME?g" md.in
	orac < md.in > md.out
    fi 
fi

# fix rem.in if run is OK
if [ $test == 1 ] ; then 
    status=`grep STOP  md.out | awk '{print $2}'`
else
    status=`grep COMPLETED md.out | awk '{print $2}'`
fi
if [ ! -s $status ]; then 
    fixreminput md
    if [ $opls == 1 ] ; then
	sed  "s/83333/50\n   FFIELD opls/g" rem.in > rem-o.in
	sed  -i "s/amber99sb-ildn/opls2015/g"  rem-o.in
	sed  -i "s/${dire}/${dire}-o/g"        rem-o.in
	sed  -i "s/  $resname/  lig/g"         rem-o.in
    fi
else
    echo ${dire}" FAILED "
fi
if [ ! -d b-RSTRT ]; then
    mkdir b-RSTRT
fi

cd $CURDIR
