#!/usr/bin/awk -f
BEGIN{
    ok1=-1;ok2=-1;
    x1=0;y1=0;z1=0;
    x2=0;y2=0;z2=0;
    m["C"]=12.0
    m["H"]=1.008
    m["O"]=16.0
    m["N"]=14.01
    m["P"]=30.97
    m["S"]=32.06
    m["CL"]=35.45
    m["BR"]=79.90
    m["I"]=126.90
    m["F"]=19.00
    if(ARGC==1) {
	print " Compute ligand-receptor COM-COM distance from an pdb file"
	print " between to user-selected subsets of atoms"
	print ""
	print " Syntax is:"  
        print " checkcomdist.awk -v s1b=n1b -v s1e=n1e  -v s2b=n2b -v s2e=n2e filename.pdb"
        print "      where s1b s1e are initial and final atom index for subset 1" 
        print "      and s2b s2e are initial and final atom index for subset 2" 
	exit
    }
}
{
#   print $2,ok1,ok2, " sites->    " s1b,s1e,s2b,s2e
    if($2==s1b) {
	ok1=1
    }
    if(ok1==1) {
	x=substr($0,32,8);y=substr($0,40,8);z=substr($0,48,8);
	x1+=m[$NF]*x; 	y1+=m[$NF]*y; 	z1+=m[$NF]*z; m1+=m[$NF]
	print "uno " x,y,z,m[$NF], "     ", x1,y1,z1,m1
    }
    if($2==s1e) {
	ok1=0
	c1x=x1/m1; c1y=y1/m1; c1z=z1/m1;
    }
    if($2==s2b) {
	ok2=1
    }
    if(ok2==1) {
	x=substr($0,32,8);y=substr($0,40,8);z=substr($0,48,8);
	x2+=m[$NF]*x; 	y2+=m[$NF]*y; 	z2+=m[$NF]*z; m2+=m[$NF]
#	print "due ",x2,y2,z2,m2,"     ", x,y,z,m2
    }
    if($2==s2e) {
	ok2=0
	c2x=x2/m2; c2y=y2/m2; c2z=z2/m2;
    }
    if(ok1==0 && ok2 == 0) {
#	print c1x,c1y,c1z,c2x,c2y,c2z
	print $3,sqrt((c1x-c2x)^2+(c1y-c2y)^2+(c1z-c2z)^2)
	exit
    }
}
