#!/usr/bin/awk -f 
# syntax is:  
# checkcomdist.awk -v n=lig_atoms -v S=state filename.xyz
#                 where lig_atoms is the number of atoms in the ligand
#                 and state is the replica index
BEGIN{
    ens=1
    rep=1
    m["c"]=12.0
    m["h"]=1.008
    m["o"]=16.0
    m["n"]=14.01
    m["p"]=30.97
    m["s"]=32.06
    m["cl"]=35.45
    m["br"]=79.90
    m["i"]=126.90
    m["F"]=19.00
    m["C"]=12.0
    m["H"]=1.008
    m["O"]=16.0
    m["N"]=14.01
    m["P"]=30.97
    m["S"]=32.06
    m["CL"]=35.45
    m["BR"]=79.90
    m["I"]=126.90
    m["F"]=19.00
    if(ARGC==1) {
	print " Compute ligand-receptor COM-COM distance from an orac-generated xyz file"
	print ""
	print " Syntax is:"  
        print " checkcomdist.awk -v n=lig_atoms -v S=state filename.xyz"
        print "      where 'lig_atoms' is the number of atoms in the ligand"
        print "      and 'state' is the replica index"
	print " N.B.: ligand coordinates  must be listed first"
	exit
    }
}
{   if(NF==1) {
	nh=$1-n
	ntot=$1
    }
    if($1=="Time:") {
	time=$2 
	ens=$NF
	rep=$(NF-1)
    }
    if(NF==4) {
	i++
	if(i<=n) {
	    xl+=m[$1]*$2; yl+=m[$1]*$3; zl+=m[$1]*$4; 
	    ml+=m[$1]
	    
	} else {
	    xh+=m[$1]*$2; yh+=m[$1]*$3; zh+=m[$1]*$4
	    mh+=m[$1]
	}
    }
    if(i==ntot) {
	i=0
	xl=xl/ml; yl=yl/ml; zl=zl/ml; 
	xh=xh/mh; yh=yh/mh; zh=zh/mh; 
	dx=xl-xh;
	dy=yl-yh;
	dz=zl-zh;
	rcom= sqrt(dx^2+dy^2+dz^2)
#	print $2, rcom, $NF
	if(ens==S || S==0) printf "%10.3f  %9.3f%9.3f%9.3f %12.1f%5d%5d\n", rcom,dx,dy,dz,time,rep,ens
	xl=0;yl=0;zl=0; ml=0
	xh=0;yh=0;zh=0; mh=0
    }
}

