#!/usr/bin/awk -f 
BEGIN{
    if(ARGC==1) {
	print " Compute ligand-receptor Centriod-centroid distance from an pdb file"
	print ""
	print " Syntax is:"  
        print " centroid_dist_pdb.awk -v skip=n filename.pdb"
        print "    where skip [optional] is the number of frames to skipped (default is 0) "
	exit
    }
}
{   
    if($1=="ATOM") {
	if($5==1) {
	    xl+=$6; yl+=$7; zl+=$8; 
	    ml++
	} else if($5==2) {
	    xh+=$6; yh+=$7; zh+=$8
	    mh++
	}
    }
    else if($1=="END") {
	xl=xl/ml; yl=yl/ml; zl=zl/ml; 
	xh=xh/mh; yh=yh/mh; zh=zh/mh; 
	dx=xl-xh;
	dy=yl-yh;
	dz=zl-zh;
	rcom= sqrt(dx^2+dy^2+dz^2)
#	print $2, rcom, $NF
	if($NF==S || S==0) print  $2, rcom,dx,dy,dz
	xl=0;yl=0;zl=0; ml=0
	xh=0;yh=0;zh=0; mh=0
    }
}

