#!/bin/bash

# this script computes the standard deviation SS from the optimal states  distribution of replica walkers 
# i.e. the ideal fraction of time TAU over the total that each replica spend on a scaling state or node is given by
# 1/n for all nodes {1..n}, meaning that ecah replica spend the same amount of time on each node.
# for a give walker in {1..n} SS is defined as SS=sqrt(Var(TAU_obs/TAU_id))
# where TAU_obs (the random variable) is the observed TAU in the walkers                                              

if [ $# == "0" ] ; then 
    echo ""
    echo " This script computes the standard deviation SS from the optimal states "	
    echo " distribution of replica walkers.  The ideal fraction of time TAU	"
    echo " over the total that each replica spends on a scaling state or node is	"
    echo " given by 1/n for all nodes {1..n}, meaning that each replica spends the	"
    echo " same amount of time on each node.  For a give walker in {1..n} SS is	"
    echo " defined as SS_i=sqrt(Var(TAU_obs_i/TAU_id)) where TAU_obs_i (the random	"
    echo "  variable) is the observed TAU in the i-th walker. Ideally SS_i should be "
    echo " ZERO"                       
    echo " Syntax: REM_var.bash PAR energy_file"
    echo "          where 'PAR' are the three characters for the REM dir                              "  
    echo "          and 'energy_file' is the scaled energy file (e.g. 1.rem) in the PAR dirs          "  
    exit
fi


if [ ! -d ${1}0001 ]; then
    echo "REM Directories non found"
    exit
fi
if [ ! -f ${1}0001/$2 ]; then
    echo "energy file not found in "${1}"* dirs"  
    exit
fi

# find out howmany batteries and nodes

batt=`awk '{if($1=="BATTERIES") {print $2}}'  ${1}0001/INPUT `
if [ -z $batt ] ; then
    batt=1
fi


nb=`ls -d ${1}[0-9]??? | wc -l | awk '{print $1}'`
n=`echo $nb $batt | awk '{print $1/$2}' `

((j=0)); 
dire=`echo $1 | tr A-Z a-z`
rm ${dire}*.var >& /dev/null
for ((j=1; j<=n; j++));  do
    j0=`echo $j | awk '{printf "%04d", $1}'`
    rm dist.$j0 >& /dev/null
#    echo "PAR"$j,$j0
     ( for (( k=1; k<=batt; k++))  ; do
	((idx=j+n*(k-1))) ;
	l=`echo $idx | awk '{printf "%04d",$1}'`
 	echo $l,$idx
	awk -v n=$n '{hist[$NF]++;j++}END{for(i=1;i<=n;i++) print i,hist[i]/(j/n)}' ${1}$l/$2
      done )  | awk -v n=$n -v b=$batt '{a[$1]+=$2}END{for(i=1; i<=n; i++) print a[i]/b}' > $dire.$j0.var
done

echo "#  nrep  sigma"
paste ${dire}.*.var | awk '{a=0; a2=0; for(i=1; i<=NF; i++) {a+=$i; a2+=$i^2}; printf "%5d%8.2f\n", NR,sqrt(a2/NF-1)}'
paste ${dire}.*.var > ${dire}.var
awk '{printf "%4d",NR; for(i=1; i<=NF; i++) printf " %5.2f  ", $i; printf "\n"}' $dire.var > x.0 
mv x.0 $dire.var
rm ${dire}.*.var
exit 
