#!/usr/bin/awk -f
# do a weighted mean between orac default scaling on REM.set and simple linear scaling
# i.e: scale_out = scale_linear*w + scale_default*(1-w)
# take as argument replica and scaling
# syntax
#  awk -v n=nrep -v s=max_scale REM.set -v w=weight
#
BEGIN{
    if(ARGC==1) {
	print " "
	print " Do a weighted mean between orac default scaling on REM.set and simple linear scaling"
	print " i.e: scale_out = scale_linear*w + scale_default*(1-w)"
	print " take as argument replica and scaling"
	print " "
	print " Syntax"
	print "  awk -v n=nrep -v s=max_scale REM.set -v w=weight"
	print " "
	exit 
    }
    x1=1; y1=1;
    x2=n; y2=s;
    a=(y2-y1)/(x2-x1);
    b=y1-a*x1
}
{
    if($1 ~ "[0-9]" ){
	y=a*$1+b; printf "%10.4f%10.4f%10.4f%10.4f\n", $1,y,w*y+(1-w)*$3,$3}
}
