#!/bin/bash

test=0
bound=0
ubound=0
gbound=0
opls=0
GG=0
failed=0

TOOLPATH=`which orac | sed "s?bin/orac?tools/templates?g"`
CURDIR=`pwd`

while getopts ":a:b:u:G:o" opt; do 
    case $opt in 
	b) 
	    bound=1; 
	    timeb=$OPTARG; 
	    ;;
	a) 
	    ubound=1; 
	    timeu=$OPTARG; 
	    ;;
	u) 
	    gbound=1; 
	    timeg=$OPTARG; 
	    ;;
	G) 
	    GG=1; 
	    ghost=$OPTARG; 
	    ;;
	o) 
	    opls=1; 
	    ;;
    esac
done

if [ $# == "0" ] ; then 
    echo ""
    echo "This script generates the input files for running NE alchemy"
    echo ""
    echo ""
    echo " Syntax: NE_alchemy.bash [opt] pdbcode"
    echo "          where 'pdbcode' is the directory produced with the script test_pdb_with_orac.bash. "  
    echo "          The 'pdbcode' directory must contains 'rem.in, 'rem_start.pdb' files" 
    echo "          and the 'b-RSTRT and/or 'u-RSTRT' dirs' and/or 'a-RSTRT' dirs'      "  
    echo " Options:                                                                                 " 
    echo "        -b timeb " 
    echo "          make fs input for bound state for time=timeb" 
    echo "          N.B. ligand start at full coupling             " 
    echo "        -a timeu " 
    echo "          make fs input for unbound state for time=timeu" 
    echo "          N.B. ligand start at full coupling             " 
    echo "        -u timeu " 
    echo "          make fs input for unbound state for time=timeu" 
    echo "          N.B. ligand start fully decoupled            " 
    echo "        -G pdbcode_ghost " 
    echo "          make the restart files in the 'pdbcode'/b-'pbdcode_ghost' directory"
    echo "          using the ligand in the 'pdbcode_ghost' directory."
    echo "          N.B.: the ghost1000.pdb file produced with HREM must be present"
    echo "          in the 'pdbcode_ghost' dir"
    echo "        -i incr " 
    echo "          with -G opt sets the increment when looping on restart files (default is 1)" 
    echo "        -o " 
    echo "          use OPLS ffield"
    echo " Examples:                     " 
    echo "          NE_alchemy.bash -b 360 -u 180  pdbcode " 
    echo "          make the ABFE input for bound  annihilation and unbound grwoth "
    echo ""
    echo "          NE_alchemy.bash -b 360 -a 180  pdbcode " 
    echo "          make the ABFE input for bound  and unbound annihilation "
    echo ""
    echo "          NE_alchemy.bash -b 360 -u 180  -G pdbcode_ghost pdbcode " 
    echo ""
    exit
fi
dire=${!#}

#check whether all necessary directories or files are there
if [ ! -d $dire ]; then 
    echo "directory "$dire" not found " 
    failed=1
fi
if [ ! -d $dire/u-RSTRT -a gbound == 1 ]; then
    echo "directory u-RSTRT not found"
    failed=1
fi

if [ ! -d $dire/a-RSTRT -a ubound == 1 ]; then
    echo "directory a-RSTRT not found"
    failed=1
fi

if [ ! -d $dire/b-RSTRT -a bound == 1 ]; then
    echo "directory b-RSTRT not found"
    failed=1
fi

if [ ! -f  $TOOLPATH/$timeb.off  -a $bound == 1 ] ; then 
    echo  "template annihilation file " $timeb.off " not available" 
    echo  "allowed values for off(b) times are 180, 360, 720, 1440, 2880,  5760"
    failed=1
fi

if [ ! -f  $TOOLPATH/$timeu.on  -a $ubound == 1 ] ; then 
    echo  "template growth  file " $timeu.on " not available" 
    echo  "allowed values for on(u)  times are 180, 360, 720, 1440, 2880,  5760"
    failed=1
fi

if [ $failed == "1" ] ;then 
    echo "dir or dirs are missing"
    exit 
fi

echo ${dire} " entered..  " 
if [ $ubound == 1 ]; then
    echo "  will make the 'a' dir for the ANNIHILATION of the ligand in bulk in " $timeu " ps ...."
fi
if [ $gbound == 1 ]; then
    echo "  will make the 'u' dir for the GROWTH of the ligand in bulk in " $timeg " ps ...."
fi
if [ $bound == 1 ]; then
    echo "  will make the 'b' dir for the ANNIHILATION of the ligand in the complex in " $timeb " ps ..."
fi
echo " "

function scanreminput {
    lcx=`awk '/LINKED_CELL/ {print $2}' $1.in` 
    lcy=`awk '/LINKED_CELL/ {print $3}' $1.in` 
    lcz=`awk '/LINKED_CELL/ {print $4}' $1.in` 
    pmx=`awk '/PME/ {print $4}' $1.in` 
    pmy=`awk '/PME/ {print $5}' $1.in` 
    pmz=`awk '/PME/ {print $6}' $1.in` 
    nlig=`awk  '/ligand/ {print $3}' $1.in` 
    unlig=`awk  '/define/ {print $3}' $1.in` 
    ntar1=`awk  '/target/ {print $2}' $1.in`
    ntar2=`awk  '/target/ {print $3}' $1.in`
    comdist=`awk '/force/ {print $3}' $1.in`
    ligname=`awk '/RESIDUE / {print $2}' ${dire}.tpg` 
}
cd $dire

if [[ $bound == 1 ]]; then  
    if [ $opls == "1" ]; then
	cp $TOOLPATH/b-fsdam-o.in b-fsdam.in
    else
	cp $TOOLPATH/b-fsdam.in .
    fi
    if [ $opls == "1" ]; then 
	scanreminput rem_opls
    else
	scanreminput rem
    fi
    echo "making b-fsdam.in ..." 
#  make fs-dam orac input file
    sed -i "s/pdbcode/${dire}/g" b-fsdam.in
    sed -i "s/lcx/$lcx/g" b-fsdam.in
    sed -i "s/lcy/$lcy/g" b-fsdam.in
    sed -i "s/lcz/$lcz/g" b-fsdam.in
    sed -i "s/pmx/$pmx/g" b-fsdam.in
    sed -i "s/pmy/$pmy/g" b-fsdam.in
    sed -i "s/pmz/$pmz/g" b-fsdam.in
    sed -i "s/nlig/$nlig/g" b-fsdam.in
    sed -i "s/ntar1/$ntar1/g" b-fsdam.in
    sed -i "s/ntar2/$ntar2/g" b-fsdam.in
    sed -i "s/comdist/$comdist/g" b-fsdam.in
    sed -i "s/twork/$timeb/g" b-fsdam.in
    cp $TOOLPATH/${timeb}.off .
#   make md.in for tpgprm generation
    echo "making tpgprm for bound state with ligand "$ligname" ..." 
    printf "%s\n"  "#&T NTHREADS    9   CACHELINE   16" > md.in
    printf "%s\n"  "#&T NT-LEVEL1   4   CACHELINE   16" >> md.in
    printf "%s\n"  "#&T NT-LEVEL2   4   CACHELINE   16" >> md.in
    if [ $opls == "1" ] ; then
	inpfile=rem_opls.in
    else
	inpfile=rem.in
    fi
    awk -v pdb=$dire 'BEGIN{pp=0} { if($1=="&SETUP") {pp=1}; if($2== "write") {pp=0};  if(pp==1) {\
    if($1=="&PARAMETERS"){print $1; print "   WRITE_TPGPRM_BIN b-"pdb".tpgprm"  }\
    else {if ($1=="MTS_RESPA") {print "   "$1; print "      energy_then_die"} else  {print}}}\
     }' $inpfile >> md.in
    sed -i "s?\.\./??g" md.in
#   make the tpgprm    
    orac < md.in >&/dev/null
#   make slr submssion script 
    if [ ! -d b ] ; then 
	mkdir b
    fi
    cp b-fsdam.in b 
    echo "making the submission script.." 
    (( nres=`ls b-RSTRT | wc -l` )) 
    (( nodes = ( $nres - 1 )/6 ))
    (( nmpi =  $nodes*6  ))
    (( hours = 4 + ${timeb}/100 ))
    Hh=`printf "%.2d" $hours`
    cat $TOOLPATH/b-fsdam.slr > b/fs-${dire}-b.slr
    sed -i "s/pdbcode/${dire}/g" b/fs-${dire}-b.slr
    sed -i "s/nnodes/$nodes/g" b/fs-${dire}-b.slr
    sed -i "s/nmpi/$nmpi/g" b/fs-${dire}-b.slr
    sed -i "s/Hh/$Hh/g" b/fs-${dire}-b.slr
    cd b-RSTRT

 #  transform battery restart  in one single  big battery list
    (( j=0 )); 
    for i in *.rst; do 
	(( j = j+1 )) ; 
	index=`printf "%.4d\n" $j` ; 
	file=${dire}$index.rst
	if [ $i != $file  ] ; then 
	    mv $i $file
	fi
    done
    cd ../
fi

if [[ $ubound == 1 ]]; then  
    if [ $opls == "1" ]; then
	cp $TOOLPATH/u-fsdam-o.in u-fsdam.in
    else
	cp $TOOLPATH/u-fsdam.in .
    fi
    if [ $opls == "1" ]; then 
	scanreminput urem-o
    else
	scanreminput urem
    fi
    echo "making a-fsdam.in ..." 
    sed -i "s/pdbcode/${dire}/g" u-fsdam.in
    sed -i "s/nlig/$unlig/g" u-fsdam.in
    sed -i "s/twork/$timeu/g" u-fsdam.in
    sed -i "s/pmx/$pmx/g" u-fsdam.in
    sed -i "s/pmy/$pmy/g" u-fsdam.in
    sed -i "s/pmz/$pmz/g" u-fsdam.in
    sed -i "s/u-/a-/g" u-fsdam.in 
    cp $TOOLPATH/${timeu}.off .
    echo "making tpgprm for unbound state of fully coupled ligand "$ligname "..." 
    printf "%s\n"  "#&T NTHREADS    8   CACHELINE   16" > umd.in
    printf "%s\n"  "#&T NT-LEVEL1   2   CACHELINE   16" >> umd.in
    printf "%s\n"  "#&T NT-LEVEL2   4   CACHELINE   16" >> umd.in
    if [ $opls == "1" ] ; then
	inpfile=urem-o.in
    else
	inpfile=urem.in
    fi
    awk -v pdb=$dire 'BEGIN{pp=0} { if($1=="&SETUP") {pp=1}; if($2== "write") {pp=0};  if(pp==1) {\
    if($1=="&PARAMETERS"){print $1; print "   WRITE_TPGPRM_BIN u-"pdb".tpgprm"  }\
    else {if ($1=="MTS_RESPA") {print "   "$1; print "      energy_then_die"} else  {print}}}\
     }' $inpfile >> umd.in
    sed -i "s?\.\./??g" umd.in
#   make the tpgprm
    orac < umd.in >&/dev/null
    mv u-$dire.tpgprm a-$dire.tpgprm
#   make slr submssion script 
    if [ ! -d a ] ; then 
	mkdir a
    fi
    cp u-fsdam.in a/a-fsdam.in
    echo "making the ubound submission script.." 
    (( nres=`ls a-RSTRT | wc -l` )) 
    (( nodes = ( $nres -1 )/6 ))
    (( hours = 1 + ${timeu}/300 ))
    (( nmpi =  $nodes*6  ))
    Hh=`printf "%.2d" $hours`
    cat $TOOLPATH/u-fsdam.slr > a/fs-${dire}-a.slr
    sed -i "s/pdbcode/${dire}/g" a/fs-${dire}-a.slr
    sed -i "s/nnodes/$nodes/g" a/fs-${dire}-a.slr
    sed -i "s/nmpi/$nmpi/g" a/fs-${dire}-a.slr
    sed -i "s/Hh/$Hh/g" a/fs-${dire}-a.slr
    
    cd a-RSTRT

 #  transform battery restart  in one single  big battery list
    (( j=0 )); 
    for i in *.rst; do 
	(( j = j+1 )) ; 
	index=`printf "%.4d\n" $j` ; 
	file=${dire}$index.rst
	if [ $i != $file  ] ; then 
	    mv $i $file
	fi
    done
fi

cd $CURDIR/$dire

if [[ $gbound == 1 ]]; then
    cd u-RSTRT
#  transform battery restart  in one single  big battery list
    (( j=0 )); 
    for i in *.rst; do 
	(( j = j+1 )) ; 
	index=`printf "%.4d\n" $j` ; 
	file=${dire}$index.rst
	if [ $i != $file  ] ; then 
	    mv $i $file
	fi
    done

    echo "making u-fsdam.in ..." 
    echo "making tpgprm for unbound state with decoupled ligand "$ligname" ..." 
    cd $CURDIR/$dire
    nlig=`wc lig.pdb | awk '{print $1}'`
    
    #make u-compound.tpgprm
    if [ -d rem_test ] ; then
	cd rem_test
	sed "s/write 15.0/\!write/g  " tmp.in > tmp1.in
	orac < tmp1.in > tmp1.out
	mv solution.prmtpg ../u-$dire.tpgprm
    else
	echo " "
	echo " FATAL: no rem_test dir; Can't make u directory and u-fsdam.in "
	echo " ACTION: run growth.bash and then rerun this script"
	echo " "
	printf "  growth.bash: "
	growth.bash
	exit
    fi
    cd ..
    if [ ! -d u ] ; then
	mkdir u
    fi
    cd u

    # fix fs-growth  input file 
    sed "s/pdbcode/$dire/g" $TOOLPATH/u-fsdam.in >  u-fsdam.in
    sed -i "s/pmx/32/g" u-fsdam.in 
    sed -i "s/pmy/32/g" u-fsdam.in 
    sed -i "s/pmz/32/g" u-fsdam.in
    sed -i "s/nlig/$nlig/g" u-fsdam.in
    sed -i "s/twork/$timeg/g" u-fsdam.in
    sed -i "s/\.off/\.on/g" u-fsdam.in 
    sed -i "s/ off/ on/g" u-fsdam.in
    cd ../
    cp $TOOLPATH/$timeg.on .
    exit 
fi

cd $CURDIR

exit
