#!/bin/bash
# this to evaluate the mean curtosis and skewness from data using bootstrap.
# NB  the mean kurtosis is zero while skewness is extremely small 
# example for a work file 23.dat
# $1 = filename 
# $2 = bootstrap fraction
#
if [ $# -ne 2 -a $# -ne 1 ]; 
    then 
    echo " Computes Free Energy from  work file using 1-Gaussian estimate"  
    echo " and performs bootstrap analysis on 40 random sample           "  
    echo " Syntax: Free_bs.bash filename [ bootstrap_frac ]"
    echo "        filename [s]       : Work file" 
    echo "        bootstrap_frac  [r]: fraction of the sample to bootstrap"
    echo "        if bootstrap is not given, then bootstrap with resampling on the fulle sample is done "
    echo "  "
    exit
fi

rm $1.tmp.0 >& /dev/null
for j in  {1..50}  ; do 
#	echo $j
    if [ $2 ]; then 
	bs.awk -v seed=$j -v p=$2 $1 >  tmp.0 ; free.awk tmp.0 >> $1.tmp.0  ; 
    else 
       bs_res.awk -v seed=$j $1 > tmp.0 ; free.awk tmp.0 >> $1.tmp.0  ; 
    fi

done 
awk -v fn=$1 '{df+=$5; df2+=$5^2; jdf+=$6; jdf2+=$6^2}; END {printf "%9s%9.3f%9.3f%9.3f%9.3f\n", fn,df/NR,2*sqrt(df2/NR-(df/NR)^2),jdf/NR,2*sqrt(jdf2/NR -(jdf/NR)^2)}' $1.tmp.0
 
rm $1.tmp.0 tmp.0 >& /dev/null

