#!/usr/bin/awk -f
# computes the p-value from Anderson Darling test
# 10.3390/MATH6060088

BEGIN{
    if (ARGC==1) {
	print " Computes the p-value from Anderson Darling test (See 10.3390/MATH6060088)"	
	print " Syntax: "
	print "   AD_pvalue -v x=AD /dev/null"
	print "   where 'AD' is the result of the Anderson Darling test"
	exit
	}
    if(x<0.34) {
	p= 1 - exp(-8.318 + 42.796*x- 59.938*x^2)
    }
    else if(x>0.34 && x<=0.6) {
	p = exp(0.9177 - 4.279*x - 1.38*x^2)
    }
    else {
	p= exp(1.2937 - 5.709*x+ 0.0186*x^2)
    }
    print x,p
}
