 module datafunc
    character*3, allocatable :: ps(:)
    character*3, allocatable :: typea(:),pa(:),pb(:)
    real*8, allocatable :: rvdw(:),gexp(:),calc(:),pup(:),plo(:)
    character*25, allocatable :: filein(:)
    real*8    range
    character*51 orac_call
    character*6  namef(64)
    character*17 string1
    character*24 string3
    character*28 string4
    integer np,nexp,nthr,nstep,nstepmax
    character*5  xout
    logical lprint
  end module datafunc
  program fitsasa
    use datafunc
    implicit none 
    include 'omp_lib.h'       ! OMP layer for all platforms but BGQ
    real*8  ::   ftol,faccy,fone,e,pcheck,fmin,duni,F
    real*8, allocatable :: p(:)
    character*5  name
    integer*4 :: nparm,one,ierr ,i,j,k
    EXTERNAL   F  ! user function F(X,NPARM) 


    nstep=0
    string1= "grep 'ImplSolv ' " 
    xout=    "x.out"
    string3= "| tail -1 | awk -v indx="
    string4= " '{print indx,$9/4.184}' >> "

    write(6,*) " please enter the number of thread" 
    read(5,*) nthr,nstepmax

    if(nthr.le.0) nthr=1
    if(nstepmax.le.0) nstepmax=1

    call OMP_SET_NUM_THREADS(nthr) !set the numbr

    calc=0.d0
    one = 1
    fone = 3.d0
    FACCY  = 1.D-17
    ftol=0.01

!   open i/o units.
    open(unit=9,file="list_exp")    ! Input: list of input filename with experimental hydration energy
    open(unit=10,file="ranges")     ! Input: allowed ranges for SASA parameters
    open(unit=11,file="sasa.fit")   ! Input: SASA parameters definitions 
    open(unit=12,file="sasa.param") ! Output: trial sasam.param for orac computation    
    open(unit=50,file="calc")       ! Outputfile produced by func with hydration energy 

    do i=1,nthr
       WRITE(namef(i), '(a4,i2.2)') "calc",i
       write(6,*) namef(i),i
       open(unit=13+i,file=namef(i))      ! Output: temporary out with calcd SASA hydration energy. 
    end do

    orac_call="~/ORAC/trunk/src/INTEL-FFTW/orac  < " 


!=== Input section  =============================================================

!--------------------------------------------------------------------------
!   read filenames and experimental hydration energy (unit = 9) 
!--------------------------------------------------------------------------
    do i=1,500 
       read(9,*,end=50) 
    end do
50  rewind(9)
    nexp=i-1
    allocate(filein(nexp),gexp(nexp),calc(nexp), stat=ierr) 

    do i=1,nexp
       read(9,*) filein(i),gexp(i)
    end do

!--------------------------------------------------------------------------
!   read  parameters ranges  (unit = 10) 
!--------------------------------------------------------------------------

    do i=1,100 
       read(10,*,end=100) 
    end do
100 rewind(10)
    nparm=i-1
    allocate(p(nparm),pup(nparm),plo(nparm),ps(nparm),stat=ierr) 
!   generate starting point
    pcheck=0.d0
    do i=1,nparm
       read(10,*) ps(i),name,plo(i),pup(i)
       pcheck=pcheck+pup(i)**2
    end do

!--------------------------------------------------------------------------
!   read  SASA parameters definitions with GAFF2 atomic type correspondance 
!--------------------------------------------------------------------------

    do i=1,100
       read(11,*,end=200) 
    end do
200 np=i-1
    rewind(11)
    allocate(typea(np),rvdw(np),pa(np),pb(np),stat=ierr)
    do i=1,np
       read(11,*) typea(i),rvdw(i),pa(i),pb(i)
       write(6,'(A4,f8.3,2a4)') typea(i),rvdw(i),pa(i),pb(i)
    end do

!=== end of reading ================================================================       


!--------------------------------------------------------------------------
!     generate starting point 
!--------------------------------------------------------------------------

    nstep=0
1   continue

    lprint = .false.
    nstep=nstep+1
    range=duni()
!   write one point if all upper bounds are zero
    if(pcheck.eq.0.d0) THEN 
       lprint = .true.
       do i=1,nparm
          p(i)=plo(i)
       end do
       fmin=F(p,nparm)
       write(6,*) "# func is ",fmin
       do i=1,nexp 
          write(6,'(a30,f8.2,f8.2)') filein(i),calc(i),gexp(i)
       end do
       stop
    end if

    do i=1,nparm
       p(i)=plo(i) + duni()*(pup(i)-plo(i))
    end do

    CALL praxis (FTOL,FACCY,fone,NPARM,one,P,F,E)
!   printout final values. 
    lprint = .true.
    fmin=F(p,nparm) 

    write(6,'(20x,"filename",5x,5x, " calc ", 5x,"exp")') 
    do i=1,nexp 
       write(6,'(a30,f8.2,f8.2)') filein(i),calc(i),gexp(i)
    end do
    if(nstep.lt.nstepmax) go to 1

  end program fitsasa

