subroutine open_pdb(unit_counter,unit_number,file_name,file_status,nato)
  implicit none
  integer, intent(inout) :: unit_counter
  integer, intent(out) :: unit_number
  integer, intent(out) :: nato
  character*6, intent(in) :: file_name
  character*3, intent(in) :: file_status
  integer :: err
  character*80 :: line
  
  unit_counter = unit_counter + 1

  unit_number = unit_counter

  select case(file_status)
  case("OLD")
     open(unit=unit_number,file=file_name,status='OLD',iostat=err)
     if(err /= 0) then 
        write(0,*) "error opening unit ", unit_number, "file ", file_name
        stop
     end if
     nato = 0
     read_loop: do 
        read(unit_number,'(A80)',iostat=err) line
        if(err < 0) exit read_loop
        select case(line(1:6))
        case("ATOM  ") 
           nato = nato + 1
        case("END   ","TER   ","ENDMDL") 
           exit  read_loop
        case default 
           cycle read_loop
        end select
     enddo read_loop
     rewind(unit_number)
  case("NEW")
     open(unit=unit_number,file=file_name,status='NEW',iostat=err)
  case("REP")
     open(unit=unit_number,file=file_name,status='REPLACE',iostat=err)
  case("SCR")
     open(unit=unit_number,status='SCRATCH',iostat=err)
  case("UNK")
     open(unit=unit_number,file=file_name,status='UNKNOWN',iostat=err)
  end select

  if(nato == 0) then 
     write(0,*) "file ",file_name,"contains 0 atoms"
     stop
  end if
  
end subroutine open_pdb
