#! /usr/bin/awk -f 
    function acos(x) { 
	return atan2(sqrt(1-x*x), x) 
    }

{
        if($1=="*PTO") {
	nb++ 
	ib1[nb]=$2;  ib2[nb]=$3;  ib3[nb]=$4; ib4[nb]=$5;
	tib1[nb]=$7; tib2[nb]=$8; tib3[nb]=$9; tib4[nb]=$10;
    } 
    if($1=="ATOM" || $1=="HETATM") { 
	na++;
	x[na]=$6; y[na]=$7; z[na]=$8; 
    }	
}
END {n=2 ; ang=180.0 
    print "# "name
    for (i=1; i<=nb; i++) {
	k1=ib1[i]; k2=ib2[i]; k3=ib3[i];  k4=ib4[i]; 
	x23=x[k3]-x[k2];y23=y[k3]-y[k2];z23=z[k3]-z[k2];
	r0=sqrt(x23^2+y23^2+z23^2)
	t1=substr(tib2[i],1,1)
	t2=substr(tib3[i],1,1)
	tb=t1 t2
	if(tb=="cc")            {
	    d1=1.41; d2=1.25; 
	    if(r0>d1)            {k0=0}
	    if(r0<=d1 && r0> d2) {k0=6.650}
	    if(r0<d2)            {k0=0}
	} 
	if(tb=="cn" || tb=="nc"){ 
	    d1=1.41; d2=1.25
	    if(r0>d1)            {k0=0}
	    if(r0<=d1 && r0> d2) {k0=4.50}
	    if(r0<d2)            {k0=0}
	} 
	if(tb=="co" || tb=="oc"){k0=0} 
	if(tb=="cs" || tb=="sc"){k0=0} 
	if(tb=="cp" || tb=="pc"){k0=0} 
	if(tb=="no" || tb=="on"){k0=0} 
	if(tb=="ns" || tb=="sn"){
	    d1=1.7
	    if(r0>d1)            {k0=0}
	    if(r0<=d1)            {k0=4.8}
	} 
	if(tb=="np" || tb=="pn"){
	    d1=1.75
	    if(r0>d1)            {k0=0}
	    if(r0<=d1)            {k0=5.4}
	} 
	if(tb=="po" || tb=="op"){k0=0} 
	if(tb=="ps" || tb=="sp"){k0=0} 
	if(tb=="so" || tb=="os"){k0=0} 
	if(tb=="sf" || tb=="fs"){k0=300} 
	if(tib2[i]=="c3" || tib2[i]=="n3" ) k0=0
	if(tib3[i]=="c3" || tib3[i]=="n3" ) k0=0
	printed=0
	for(j=1; j<i; j++) {
	    if( (tib2[j]==tib2[i] && tib3[j]==tib3[i] ) || (tib2[j]==tib3[i] && tib3[j]==tib2[i] ) ) {printed=1} 
	}
	if(printed==0) {
	    printf "%2s  %2s  %2s   %2s %16.2f %3d  %8.2f\n", "x",tib2[i],tib3[i],"x", k0, n, ang
	}
   }
}


