#! /usr/bin/awk -f 
    function acos(x) { 
	return atan2(sqrt(1-x*x), x) 
    }

{
        if($1=="*PIT") {
	nb++ 
	ib1[nb]=$2;  ib2[nb]=$3;  ib3[nb]=$4; ib4[nb]=$5;
	tib1[nb]=$7; tib2[nb]=$8; tib3[nb]=$9; tib4[nb]=$10;
    } 
    if($1=="ATOM" || $1=="HETATM") { 
	na++;
	x[na]=$6; y[na]=$7; z[na]=$8; 
    }	
}
END {n=2 ; ang=180.0 ;  k0=1.1
    print "# "name
    for (i=1; i<=nb; i++) {
	printed=0
	for(j=1; j<i; j++) {
	    if( (tib3[j]==tib3[i] && tib4[j]==tib4[i] ) || (tib3[j]==tib4[i] && tib4[j]==tib3[i] ) ) {
		if( (tib1[j]==tib1[i] && tib2[j]==tib2[i] ) || (tib1[j]==tib2[i] && tib2[j]==tib1[i] ) ) {
		    printed=1} 
	    }
	}
	if(printed==0) {
	    printf "%2s  %2s  %2s   %2s %16.2f %3d  %8.2f cosine\n", tib1[i],tib2[i],tib3[i],tib4[i], k0, n, ang 
	}
   }
}


