#! /usr/bin/awk -f 
BEGIN{
# Table 3 of Ref. Gaff Dev 2004 JCC 
    k["h,h"]= 105.742      ;  rref["h","h"]= 0.738
    k["h","c"]= 501.197    ;  rref["h","c"]= 1.090
    k["h","n"]= 427.092    ;  rref["h","n"]= 1.010
    k["h","o"]= 328.324    ;  rref["h","o"]= 0.960
    k["h","f"]= 270.426    ;  rref["h","f"]= 0.920
    k["h","l"]= 1029.68    ;  rref["h","l"]= 1.280
    k["h","b"]= 1481.78    ;  rref["h","b"]= 1.410
    k["h","i"]= 2445.49    ;  rref["h","i"]= 1.600
    k["h","p"]= 1418       ;  rref["h","p"]= 1.410
    k["h","s"]= 1116.55    ;  rref["h","s"]= 1.340
    k["c","c"]= 2085.99    ;  rref["c","c"]= 1.526
    k["c","n"]= 1815.29    ;  rref["c","n"]= 1.470
    k["c","o"]= 1551.53    ;  rref["c","o"]= 1.440
    k["c","f"]= 1376.09    ;  rref["c","f"]= 1.370
    k["c","l"]= 3793.33    ;  rref["c","l"]= 1.800
    k["c","b"]= 4807.82    ;  rref["c","b"]= 1.940
    k["c","i"]= 7037.44    ;  rref["c","i"]= 2.160
    k["c","p"]= 3778.19    ;  rref["c","p"]= 1.830
    k["c","s"]= 3350.95    ;  rref["c","s"]= 1.820
    k["n","n"]= 2067.3     ;  rref["n","n"]= 1.441
    k["n","o"]= 1855.67    ;  rref["n","o"]= 1.420
    k["n","f"]= 1763.4     ;  rref["n","f"]= 1.420
    k["n","l"]= 3889.36    ;  rref["n","l"]= 1.750
    k["n","b"]= 5393.77    ;  rref["n","b"]= 1.930
    k["n","i"]= 7808.75    ;  rref["n","i"]= 2.120
    k["n","p"]= 3684.9     ;  rref["n","p"]= 1.720
    k["n","s"]= 3206.71    ;  rrefa["n","s"]= 1.690
    k["o","o"]= 1921.77    ;  rref["o","o"]= 1.460
    k["o","f"]= 1595.59    ;  rref["o","f"]= 1.410
    k["o","l"]= 3284.6     ;  rref["o","l"]= 1.700
    k["o","b"]= 3928.45    ;  rref["o","b"]= 1.790
    k["o","i"]= 7002.34    ;  rref["o","i"]= 2.110
    k["o","p"]= 2855.49    ;  rref["o","p"]= 1.640
    k["o","s"]= 2757.28    ;  rref["o","s"]= 1.650
    k["f","f"]= 1568.7     ;  rref["f","f"]= 1.406
    k["f","l"]= 2827.08    ;  rref["f","l"]= 1.648
    k["l","l"]= 5698.74    ;  rref["l","l"]= 2.031
    k["l","i"]= 11036.9    ;  rref["l","i"]= 2.550
    k["b","i"]= 11849      ;  rref["b","i"]= 2.671
    k["f","p"]= 1982.27    ;  rref["f","p"]= 1.500
    k["f","s"]= 2282.44    ;  rref["f","s"]= 1.580
    k["l","p"]= 5744.51    ;  rref["l","p"]= 2.040
    k["l","s"]= 5535.85    ;  rref["l","s"]= 2.030
    k["b","b"]= 8200.91    ;  rref["b","b"]= 2.337
    k["b","p"]= 6179.55    ;  rref["b","p"]= 2.240
    k["b","s"]= 6173.37    ;  rref["b","s"]= 2.210
    k["i","i"]= 13507.5    ;  rref["i","i"]= 2.836
    k["i","p"]= 8586.96    ;  rref["i","p"]= 2.490
    k["i","s"]= 9518.57    ;  rref["i","s"]= 2.560
    k["p","p"]= 6667.5     ;  rref["p","p"]= 2.324
    k["p","s"]= 4745.73    ;  rref["p","s"]= 2.120
    k["s","s"]= 4088.77    ;  rref["s","s"]= 2.038
}
{  
    if($1=="*BND") {
	nb++ 
	ib1[nb]=$2;  ib2[nb]=$3; 
	tib1[nb]=$5; tib2[nb]=$6;
    } 
    if($1=="ATOM" || $1=="HETATM") { 
	na++;
	x[na]=$6; y[na]=$7; z[na]=$8;
    }	
}
END { 
    print "# "name
    for (i=1; i<=nb; i++) {
	k1=ib1[i]; k2=ib2[i]
	x21=x[k1]-x[k2];y21=y[k1]-y[k2];z21=z[k1]-z[k2];
	r0=sqrt(x21^2+y21^2+z21^2)
	if(tib1[i]=="cl") {t1="l"} else {t1=substr(tib1[i],1,1)}
	if(tib2[i]=="cl") {t2="l"} else {t2=substr(tib2[i],1,1)}
	kr1=k[t1,t2] ; kr2=k[t2,t1]
# implement Eq. 3 of gaff devel JCC 2004
	if(kr1 > 0) { 
	    kr=kr1/r0^4.5
	}
	if(kr2 > 0) { 
	    kr=kr2/r0^4.5
	}
	printed=0
	for(j=1; j<i; j++) {
	    if( (tib1[j]==tib1[i] && tib2[j]==tib2[i] ) || (tib1[j]==tib2[i] && tib2[j]==tib1[i] ) ) {printed=1} 
	}
	if(printed==0) {
	    printf "%2s  %2s  %16.2f %8.2f\n", tib1[i],tib2[i],kr, r0
	}
    }
}


