subroutine bonds_matrix(bmat)
  implicit none
  real*8 bmat(11,11) 
  integer i,j
  !Bondlength (pm) and bond energy (kJ/mol)
  !Bond	Length	Energy	Bond	Length	Energy
  !H--H	74	436	H--C	109	413
  !C--C	154	348	H--N	101	391
  !N--N	145	170	H--O	96	366
  !O--O	148	145	H--F	92	568
  !F--F	142	158	H--Cl	127	432
  !Cl-Cl	199	243	H--Br	141	366
  !Br-Br	228	193	H--I	161	298
  !I--I	267	151	
  !C--C	154	348
  !C--C	154	348	C=C	134	614
  !C--N	147	308	CºC	120	839
  !C--O	143	360
  !C--S	182	272	O--O	148	145
  !C--F	135	488	O=O	121	498
  !C--Cl	177	330
  !C--Br	194	288	N--N	145	170
  !C--I	214	216	NºN	110	945


  ! type 1 = H
  ! type 2 = C
  ! type 3 = N
  ! type 4 = O
  ! type 5 = P
  ! type 6 = S
  ! type 7 = F
  ! type 8 = Cl
  ! type 9 = Br
  ! type 10 = I
  ! type 11 = Si

  ! single bonds 

  ! H 
  bmat(1,1) = 0.74
  bmat(1,2) = 1.09
  bmat(1,3) = 1.09
  bmat(1,4) = 0.96
  bmat(1,5) = 1.44
  bmat(1,6) = 1.34
  bmat(1,7) = 0.92
  bmat(1,8) = 1.27
  bmat(1,9) = 1.41
  bmat(1,10) = 1.61
  bmat(1,11) = 1.50
  ! C 
  bmat(2,2) = 1.54 
  bmat(2,3) = 1.47
  bmat(2,4) = 1.43 
  bmat(2,5) = 1.84 
  bmat(2,6) = 1.82 
  bmat(2,7) = 1.35 
  bmat(2,8) = 1.77
  bmat(2,9) = 1.94
  bmat(2,10) = 2.17
  bmat(2,11) = 1.86
  !N 
  bmat(3,3) = 1.45
  bmat(3,4) = 1.40 
  bmat(3,5) = 1.73   !  arbitrary  
  bmat(3,6) = 1.73   !  arbitrary  
  bmat(3,7) = 1.36 
  bmat(3,8) = 1.75
  bmat(3,9) = 1.94  !  arbitrary  
  bmat(3,10) = 2.16 !  arbitrary   
  bmat(3,11) = 1.74 
  !O 
  bmat(4,4) = 1.48 
  bmat(4,5) = 1.63   
  bmat(4,6) = 1.75   
  bmat(4,7) = 1.75 
  bmat(4,8) = 1.75  ! arbitrary
  bmat(4,9) = 1.94  !  arbitrary  
  bmat(4,10) = 2.14 !  arbitrary   
  bmat(4,11) = 2. !  arbitrary   
  !P
  bmat(5,5) = 2.21   
  bmat(5,6) = 2.00   
  bmat(5,7) = 1.54 
  bmat(5,8) = 2.03 
  bmat(5,9) = 2.03  !  arbitrary  
  bmat(5,10) = 2.03 !  arbitrary   
  bmat(5,11) = 2. !  arbitrary   
  !S
  bmat(6,6) = 2.05
  bmat(6,7) = 1.56
  bmat(6,8) = 2.07 
  bmat(6,9) = 2.03  !  arbitrary  
  bmat(6,10) = 2.03 !  arbitrary   
  bmat(6,11) = 2. !  arbitrary   
  !F
  bmat(7,7) = 1.42
  bmat(7,8) = 2.07 
  bmat(7,9) = 2.03  !  arbitrary  
  bmat(7,10) = 2.03 !  arbitrary   
  bmat(7,11) = 2. !  arbitrary   
  !Cl
  bmat(8,8) = 1.99
  bmat(8,9) = 2.07  !  arbitrary  
  bmat(8,10) = 2.07 !  arbitrary   
  bmat(8,11) = 2. !  arbitrary   
  !Br
  bmat(9,9) = 2.28  !  arbitrary  
  bmat(9,10) = 2.45!  arbitrary   
  bmat(9,11) = 2.45!  arbitrary   
  !I 
  bmat(10,10) = 2.67 !  arbitrary   
  bmat(11,11) = 2.5 !  arbitrary   
  do i=1,10
     do j=i+1,11
        bmat(j,i)=bmat(i,j)
     end do
  end do
end subroutine bonds_matrix

subroutine get_threshold(ato1,ato2,d,bmat)
  implicit none

  character*2 ato1,ato2
  integer i1,i2,i,j
  real*8  d,bmat(11,11)

  if(ato1(1:1).eq."h") i1=1
  if(ato2(1:1).eq."h") i2=1
! check whether is chlorine or carbon
  if(ato1(1:1).eq."c") THEN 
     if(ato1(2:2).ne."l") THEN 
        i1=2
     ELSE
        i1=8
     end if
  end if
  if(ato2(1:1).eq."c") THEN 
     if(ato2(2:2).ne."l") THEN 
        i2=2
     ELSE
        i2=8
     end if
  end if
! check whether is Sulphr or Silcon 
  if(ato1(1:1).eq."s") THEN 
     if(ato1(2:2).ne."i") THEN 
        i1=6
     ELSE
        i1=11
     end if
  end if
  if(ato2(1:1).eq."s") THEN 
     if(ato2(2:2).ne."i") THEN 
        i2=6
     ELSE
        i2=11
     end if
  end if
  if(ato1(1:1).eq."n") i1=3
  if(ato2(1:1).eq."n") i2=3
  if(ato1(1:1).eq."o") i1=4
  if(ato2(1:1).eq."o") i2=4
  if(ato1(1:1).eq."p") i1=5
  if(ato2(1:1).eq."p") i2=5
  if(ato1(1:1).eq."f") i1=7
  if(ato2(1:1).eq."f") i2=7
  if(ato1(1:1).eq."b") i1=9
  if(ato2(1:1).eq."b") i2=9
  if(ato1(1:1).eq."i") i1=10
  if(ato2(1:1).eq."i") i2=10
  do i=1,11
     do j=1,11
        if(i.eq.i1.and.j.eq.i2) THEN 
           d=bmat(i,j) 
           exit
        end if
     end do
  end do
end subroutine get_threshold

