 subroutine bcc_abcg2(n,ato2,conn,c,types,hybrid,iring,in_ring,kring,x,y,z,charge) 
    implicit none 
! args
    integer nt
    parameter(nt=614)
    integer n,conn(n),c(n,7),bcc_bond_index(n,7),iring(n),nn,nrr,counth,in_ring(n),kring(6,n)
    character*2 ato2(n),bcc_bond(n,7), types(n)
    character*3 hybrid(n)
    real*8 x(n),y(n),z(n),charge(n)
!local 
    integer i,j,k,jj
    real*8  bcc_real,bcc_tmp
    character*6 bond
    character(len=6), dimension(nt) :: atype
    character(len=7), dimension(nt) :: bcc
! bond charges are stored in a data statement

! Jakalian 2002 atomic and bond types     
!C4	Tetravalent carbon	                                                  11
!C 	Trivalent carbon, double bonded to carbon	                          12
!C 	Trivalent carbon, double bonded to nitrogen or phosphorus	          13
!C 	Trivalent carbon, double bonded to oxygen or sulfur	                  14
!C1,2	Univalent or divalent carbon	                                          15
!Car	Aromatic carbon	                                                          16
!C 	Aromatic carbon bonded to an aromatic oxygen or nitrogen with a lone pair 17
!N 	Amine nitrogen	                                                          21
!N 	Trivalent nitrogen with a delocalized lone pair	                          22
!N 	Trivalent nitrogen with a highly delocalized lone pair	                  23
!N2	Neutral divalent nitrogen	                                          24
!N 	Univalent or cationic divalent nitrogen	                                  25
!O1,2	Univalent or divalent oxygen	                                          31
!O 	Double-bonded oxygen in an ester or acid	                          32
!O 	Double-bonded oxygen in a lactone or lactam	                          33
!P2,3	Divalent or trivalent phosphorus	                                  41
!P 	Trivalent or tetravalent double-bonded phosphorus	                  42
!S1,2	Univalent or divalent sulfur	                                          51
!S3	Trivalent sulfur	                                                  52
!S4	Tetravalent sulfur	                                                  53
!Si4	Tetravalent silicon	                                                  61
!F1	Fluorine	                                                          71
!Cl1	Chlorine	                                                          72
!Br1	Bromine	                                                                  73
!I1	Iodine	                                                                  74
!H1	Hydrogen	                                                          91
!Single bond	                                                                  01
!Double bond	                                                                  02
!Triple bond	                                                                  03
!Dative bond	                                                                  06
!Aromatic single bond	                                                          07
!Aromatic double bond	                                                          08
!Single bond with charge or delocalized bond	                                  09

! ABCG2 corrections (in column 2 the new type; in column 3 the old type)
! CORR    2X   21     #for ammonium nitrogen
! CORR    2F   21     #for nitrogen connecting to anthraquinone (anthracenedione)
! CORR    2Y   23     #for nitrogen in arginine ion, forming double bond
! CORR    20   23     #for nitrogen in -NO2
! CORR    2W   22     #for nitrogen in -N-C(=O)-c in a ring
! CORR    2V   22     #for nitrogen in -N-C(=O)-benzene
! CORR    2U   22     #for nitrogen in -N-C(=O)-n in a ring
! CORR    2T   22     #for nitrgogen in benzene-N-C(=O)
! CORR    2A   24     #for nitrogen in -N=C=O
! CORR    2B   24     #for nitrogen in -N=C=S
! CORR    2C   24     #
! CORR    2D   24     #for nitrogen in -N=N-
! CORR    2E   24     #for nitrogen in -O-N=C-
! CORR    29   24     #for nitrogen in -N=C-
! CORR    28   24     #for nitrogen in -N= in 5-member rings 
! CORR    27   24     #for nitrogen in -N=C-N= in 6-member rings
! CORR    26   24     #for nitrogen in -N=C-C=N- in 6-member rings 
! CORR    3X   31     #for both oxygen atoms in neutral acids
! CORR    3Y   31     #for both oxygen atoms in charged carboxylic acid 
! CORR    30   31     #for oxygen in poly-alcohols
! CORR    34   31     #for oxygen in -O-C(OC)-O-C-
! CORR    3F   31     #for oxygen in O=P of -P(=O)-F
! CORR    3P   31     #for oxygen in -O- of -P(=O)-O-
! CORR    3Q   31     #for oxygen in -O- of -P(=S)-O-
! CORR    3S   31     #for oxygen in -OH of -O-S(=O)(=O)-OH
! CORR    18   11     #for carbon in terminal -CH3
! CORR    19   11     #for carbon in tertiary alkanes R1-C(R2)(R3)-R4
! CORR    1A   14     #for carbon connecting two bezene rings ph-C(=O)-ph
! CORR    43   42     #for P in -P(=O)- or -P(=S)-
! CORR    44   42     #for P in -P(=S)-ph
! CORR    50   51     #for S in 3-membered ring -C1SC1-
! CORR    54   51     #for S in -S-P(=O)- or -S-P(=S)-
! CORR    7X   71     #for F in -CF3
! CORR    7Y   72     #for Cl in -CCl3
! CORR    7Z   73     #for Br in -CBr3
! CORR    7W   74     #for I  in -CI3

! ---------------executable starts below ----------------------------------------
!   assign to each atom the abcg2_bcc atomic types----
    nn=0
    atype =   [character(len=6) ::   "c1  br","br  c1",& !  "-0.2338","0.2338"
                                     "c1  cl","cl  c1",& !  "-0.0899","0.0899"
                                     "c1   f"," f  c1",& !  "-0.0021","0.0021"
                                     "c1  ha","ha  c1",& !  "0.0300","-0.0300"
                                     "c1   i"," i  c1",& !  "-0.2886","0.2886"
                                     "c1  n1","n1  c1",& !  "-0.4150","0.4150"
                                     "c1   n"," n  c1",& !  "-0.0062","0.0062"
                                     "c1  n3","n3  c1",& !  "-0.0558","0.0558"
                                     "c1  na","na  c1",& !  "0.0543","-0.0543"
                                     "c1  nh","nh  c1",& !  "0.0543","-0.0543"
                                     "c1   o"," o  c1",& !  "-0.2335","0.2335"
                                     "c1  oh","oh  c1",& !  "-0.0286","0.0286"
                                     "c1  os","os  c1",& !  "-0.0286","0.0286"
                                     "c1  p3","p3  c1",& !  "-0.3987","0.3987"
                                     "c1  p5","p5  c1",& !  "-0.3545","0.3545"
                                     "c1  s4","s4  c1",& !  "-0.4586","0.4586"
                                     "c1  s6","s6  c1",& !  "-0.4018","0.4018"
                                     "c1  sh","sh  c1",& !  "-0.2251","0.2251"
                                     "c1  Si","Si  c1",& !  "-0.2343","0.2343"
                                     "c2  br","br  c2",& !  "-0.1257","0.1257"
                                     "c2  c3","c3  c2",& !  "0.0042","-0.0042"
                                     "c2  cl","cl  c2",& !  "-0.1600","0.1600"
                                     "c2   f"," f  c2",& !  "-0.0625","0.0625"
                                     "c2  h4","h4  c2",& !  "0.0500","-0.0500"
                                     "c2  h5","h5  c2",& !  "-0.1292","0.1292"
                                     "c2  ha","ha  c2",& !  "0.0500","-0.0500"
                                     "c2  hx","hx  c2",& !  "0.0500","-0.0500"
                                     "c2   i"," i  c2",& !  "-0.2728","0.2728"
                                     "c2  n1","n1  c2",& !  "-0.1624","0.1624"
                                     "c2   n"," n  c2",& !  "-0.0026","0.0026"
                                     "c2  n2","n2  c2",& !  "-0.2877","0.2877"
                                     "c2  ne","ne  c2",& !  "-0.2877","0.2877"
                                     "c2  nh","nh  c2",& !  "-0.0820","0.0820"
                                     "c2  oh","oh  c2",& !  "-0.0441","0.0441"
                                     "c2  p2","p2  c2",& !  "-0.2496","0.2496"
                                     "c2  p3","p3  c2",& !  "-0.3529","0.3529"
                                     "c2  pe","pe  c2",& !  "-0.2496","0.2496"
                                     "c2  sh","sh  c2",& !  "-0.2406","0.2406"
                                     "c2  ss","ss  c2",& !  "-0.2406","0.2406"
                                     "c3  br","br  c3",& !  "-0.2100","0.2100"
                                     "c3   c"," c  c3",& !  "0.0500","-0.0500"
                                     "c3  c1","c1  c3",& !  "0.0269","-0.0269"
                                     "c3  c2","c2  c3",& !  "-0.0042","0.0042"
                                     "c3  ca","ca  c3",& !  "-0.0073","0.0073"
                                     "c3  ce","ce  c3",& !  "-0.0042","0.0042"
                                     "c3  cl","cl  c3",& !  "-0.1500","0.1500"
                                     "c3   f"," f  c3",& !  "-0.0900","0.0900"
                                     "c3  h1","h1  c3",& !  "-0.0393","0.0393"
                                     "c3  h2","h2  c3",& !  "-0.0393","0.0393"
                                     "c3  h3","h3  c3",& !  "-0.0393","0.0393"
                                     "c3  hc","hc  c3",& !  "-0.0393","0.0393"
                                     "c3  hx","hx  c3",& !  "-0.0393","0.0393"
                                     "c3   i"," i  c3",& !  "-0.2950","0.2950"
                                     "c3   n"," n  c3",& !  "-0.0374","0.0374"
                                     "c3  n2","n2  c3",& !  "-0.1252","0.1252"
                                     "c3  n3","n3  c3",& !  "-0.1582","0.1582"
                                     "c3  n4","n4  c3",& !  "-0.1582","0.1582"
                                     "c3  nh","nh  c3",& !  "-0.1582","0.1582"
                                     "c3  no","no  c3",& !  "-0.0100","0.0100"
                                     "c3  oh","oh  c3",& !  "-0.0950","0.0950"
                                     "c3  os","os  c3",& !  "-0.0950","0.0950"
                                     "c3  p3","p3  c3",& !  "-0.2579","0.2579"
                                     "c3  p5","p5  c3",& !  "-0.2500","0.2500"
                                     "c3  s4","s4  c3",& !  "-0.4263","0.4263"
                                     "c3  s6","s6  c3",& !  "-0.3500","0.3500"
                                     "c3  sh","sh  c3",& !  "-0.2300","0.2300"
                                     "c3  Si","Si  c3",& !  "-0.1540","0.1540"
                                     "c3  ss","ss  c3",& !  "-0.2300","0.2300"
                                     "ca  br","br  ca",& !  "-0.1401","0.1401"
                                     "ca   c"," c  ca",& !  "0.0206","-0.0206"
                                     "ca  c3","c3  ca",& !  "0.0073","-0.0073"
                                     "ca  ce","ce  ca",& !  "0.0118","-0.0118"
                                     "ca  cg","cg  ca",& !  "0.0040","-0.0040"
                                     "ca  cl","cl  ca",& !  "-0.1700","0.1700"
                                     "ca  cx","cx  ca",& !  "0.0073","-0.0073"
                                     "ca   f"," f  ca",& !  "-0.0700","0.0700"
                                     "ca  h4","h4  ca",& !  "-0.0180","0.0180"
                                     "ca  ha","ha  ca",& !  "-0.0180","0.0180"
                                     "ca   i"," i  ca",& !  "-0.4230","0.4230"
                                     "ca   n"," n  ca",& !  "0.0074","-0.0074"
                                     "ca  n4","n4  ca",& !  "-0.2200","0.2200"
                                     "ca  na","na  ca",& !  "0.0750","-0.0750"
                                     "ca  nb","nb  ca",& !  "-0.2630","0.2630"
                                     "ca  ne","ne  ca",& !  "-0.1394","0.1394"
                                     "ca  nh","nh  ca",& !  "-0.2200","0.2200"
                                     "ca  oh","oh  ca",& !  "-0.0451","0.0451"
                                     "ca  p3","p3  ca",& !  "-0.4597","0.4597"
                                     "ca  pb","pb  ca",& !  "-0.2240","0.2240"
                                     "ca  py","py  ca",& !  "-0.3895","0.3895"
                                     "ca  s4","s4  ca",& !  "-0.5416","0.5416"
                                     "ca  sh","sh  ca",& !  "-0.1000","0.1000"
                                     "ca  Si","Si  ca",& !  "-0.1938","0.1938"
                                     "ca  sy","sy  ca",& !  "-0.4445","0.4445"
                                     " c  br","br   c",& !  "-0.1106","0.1106"
                                     " c  c3","c3   c",& !  "-0.0500","0.0500"
                                     " c  ca","ca   c",& !  "-0.0206","0.0206"
                                     " c  cc","cc   c",& !  "0.0693","-0.0693"
                                     "cc  cc","cc  cc",& !  "-0.0866","0.0866"
                                     " c  ce","ce   c",& !  "-0.0192","0.0192"
                                     " c  cg","cg   c",& !  "0.0308","-0.0308"
                                     "cc  h4","h4  cc",& !  "0.0500","-0.0500"
                                     "cc  h5","h5  cc",& !  "-0.1369","0.1369"
                                     "cc  ha","ha  cc",& !  "0.0500","-0.0500"
                                     " c  cl","cl   c",& !  "-0.0486","0.0486"
                                     "cc  na","na  cc",& !  "0.0271","-0.0271"
                                     "cc  nc","nc  cc",& !  "-0.2630","0.2630"
                                     "cc  nd","nd  cc",& !  "-0.2630","0.2630"
                                     "cc  os","os  cc",& !  "-0.0850","0.0850"
                                     "cc  pd","pd  cc",& !  "-0.2496","0.2496"
                                     " c  cy","cy   c",& !  "-0.0500","0.0500"
                                     "cd   c"," c  cd",& !  "-0.0693","0.0693"
                                     "cd  c3","c3  cd",& !  "0.0073","-0.0073"
                                     "cd  cf","cf  cd",& !  "0.0118","-0.0118"
                                     "cd  h4","h4  cd",& !  "-0.1292","0.1292"
                                     "cd  h5","h5  cd",& !  "-0.1369","0.1369"
                                     "cd  ha","ha  cd",& !  "0.0500","-0.0500"
                                     "cd  nc","nc  cd",& !  "-0.2630","0.2630"
                                     "cd  nh","nh  cd",& !  "-0.2200","0.2200"
                                     "ce  c3","c3  ce",& !  "0.0042","-0.0042"
                                     "ce  cc","cc  ce",& !  "-0.0118","0.0118"
                                     "ce  ce","ce  ce",& !  "0.0866","-0.0866"
                                     "ce  cg","cg  ce",& !  "-0.0302","0.0302"
                                     "ce  h4","h4  ce",& !  "0.0500","-0.0500"
                                     "ce  h5","h5  ce",& !  "-0.1292","0.1292"
                                     "ce  ha","ha  ce",& !  "0.0500","-0.0500"
                                     "ce  n2","n2  ce",& !  "-0.2877","0.2877"
                                     "ce  ne","ne  ce",& !  "-0.1406","0.1406"
                                     "ce  p2","p2  ce",& !  "-0.2496","0.2496"
                                     "ce  p3","p3  ce",& !  "-0.6836","0.6836"
                                     "ce  pe","pe  ce",& !  "-0.2986","0.2986"
                                     "ce  py","py  ce",& !  "-0.4154","0.4154"
                                     "ce  sx","sx  ce",& !  "-0.4307","0.4307"
                                     "ce  sy","sy  ce",& !  "-0.4509","0.4509"
                                     " c   f"," f   c",& !  "-0.1115","0.1115"
                                     "cf  cx","cx  cf",& !  "0.0042","-0.0042"
                                     "cg  n1","n1  cg",& !  "-0.4150","0.4150"
                                     " c  h4","h4   c",& !  "-0.0928","0.0928"
                                     " c  h5","h5   c",& !  "-0.0928","0.0928"
                                     " c  hx","hx   c",& !  "-0.0928","0.0928"
                                     " c   i"," i   c",& !  "-0.2601","0.2601"
                                     " c   n"," n   c",& !  "0.0432","-0.0432"
                                     " c  nc","nc   c",& !  "-0.1394","0.1394"
                                     " c  ne","ne   c",& !  "-0.1394","0.1394"
                                     " c   o"," o   c",& !  "-0.2391","0.2391"
                                     " c  oh","oh   c",& !  "-0.0901","0.0901"
                                     " c  os","os   c",& !  "-0.0901","0.0901"
                                     "cp  cp","cp  cp",& !  "0.1075","-0.1075"
                                     " c  pd","pd   c",& !  "-0.2828","0.2828"
                                     "cp  nb","nb  cp",& !  "-0.2630","0.2630"
                                     " c   s"," s   c",& !  "-0.2834","0.2834"
                                     " c  s4","s4   c",& !  "-0.4319","0.4319"
                                     " c  sh","sh   c",& !  "-0.1826","0.1826"
                                     "cu  cx","cx  cu",& !  "0.0042","-0.0042"
                                     "cu  ha","ha  cu",& !  "0.0500","-0.0500"
                                     "cv  cy","cy  cv",& !  "-0.0753","0.0753"
                                     "cv  h4","h4  cv",& !  "-0.1292","0.1292"
                                     "cv  ne","ne  cv",& !  "-0.2877","0.2877"
                                     "cx   c"," c  cx",& !  "0.0500","-0.0500"
                                     "cx  ca","ca  cx",& !  "-0.0073","0.0073"
                                     "cx  h1","h1  cx",& !  "-0.0393","0.0393"
                                     "cx  hc","hc  cx",& !  "-0.0393","0.0393"
                                     "cx  ni","ni  cx",& !  "-0.0374","0.0374"
                                     "cx  np","np  cx",& !  "-0.1582","0.1582"
                                     "cx  op","op  cx",& !  "-0.0950","0.0950"
                                     "cx  sp","sp  cx",& !  "-0.2300","0.2300"
                                     "cy   c"," c  cy",& !  "0.0500","-0.0500"
                                     "cy  h1","h1  cy",& !  "-0.0393","0.0393"
                                     "cy  hc","hc  cy",& !  "-0.0393","0.0393"
                                     "cy  nj","nj  cy",& !  "-0.0374","0.0374"
                                     "cy  nn","nn  cy",& !  "-0.1582","0.1582"
                                     "cy  nq","nq  cy",& !  "-0.1582","0.1582"
                                     "cy  oq","oq  cy",& !  "-0.0950","0.0950"
                                     "cz  nh","nh  cz",& !  "-0.0388","0.0388"
                                     "n1  c2","c2  n1",& !  "0.1624","-0.1624"
                                     "n1  hn","hn  n1",& !  "0.1634","-0.1634"
                                     "n2  br","br  n2",& !  "-0.0192","0.0192"
                                     "n2  c2","c2  n2",& !  "0.2877","-0.2877"
                                     "n2  c3","c3  n2",& !  "0.1252","-0.1252"
                                     "n2  cl","cl  n2",& !  "0.0603","-0.0603"
                                     "n2   f"," f  n2",& !  "0.0554","-0.0554"
                                     "n2  hn","hn  n2",& !  "0.2444","-0.2444"
                                     "n2   i"," i  n2",& !  "-0.1171","0.1171"
                                     "n2  nh","nh  n2",& !  "0.1794","-0.1794"
                                     "n2   o"," o  n2",& !  "0.0467","-0.0467"
                                     "n2  oh","oh  n2",& !  "0.0985","-0.0985"
                                     "n2  p3","p3  n2",& !  "-0.1287","0.1287"
                                     "n2  p5","p5  n2",& !  "-0.4287","0.4287"
                                     "n2  s4","s4  n2",& !  "-0.1731","0.1731"
                                     "n2  sh","sh  n2",& !  "-0.0315","0.0315"
                                     "n2  ss","ss  n2",& !  "-0.0315","0.0315"
                                     "n3  c3","c3  n3",& !  "0.1582","-0.1582"
                                     "n3  hn","hn  n3",& !  "0.2600","-0.2600"
                                     "n4  br","br  n4",& !  "-0.0876","0.0876"
                                     "n4  c1","c1  n4",& !  "0.0558","-0.0558"
                                     "n4  c2","c2  n4",& !  "0.0820","-0.0820"
                                     "n4  c3","c3  n4",& !  "0.1582","-0.1582"
                                     "n4  ca","ca  n4",& !  "0.2200","-0.2200"
                                     "n4  cl","cl  n4",& !  "0.0369","-0.0369"
                                     "n4   f"," f  n4",& !  "0.0204","-0.0204"
                                     "n4  hn","hn  n4",& !  "0.2600","-0.2600"
                                     "n4   i"," i  n4",& !  "-0.1898","0.1898"
                                     "n4  oh","oh  n4",& !  "0.0517","-0.0517"
                                     "n4  p3","p3  n4",& !  "-0.2527","0.2527"
                                     "n4  p5","p5  n4",& !  "-0.2947","0.2947"
                                     "n4  s6","s6  n4",& !  "-0.3359","0.3359"
                                     "n4  sh","sh  n4",& !  "-0.0757","0.0757"
                                     "n4  Si","Si  n4",& !  "-0.1037","0.1037"
                                     "na  br","br  na",& !  "-0.1802","0.1802"
                                     "na  c3","c3  na",& !  "0.0100","-0.0100"
                                     "na  ca","ca  na",& !  "-0.0750","0.0750"
                                     "na  cc","cc  na",& !  "0.0547","-0.0547"
                                     "na  cl","cl  na",& !  "-0.0642","0.0642"
                                     "na   f"," f  na",& !  "-0.0561","0.0561"
                                     "na  p3","p3  na",& !  "-0.2538","0.2538"
                                     "na  p5","p5  na",& !  "-0.4175","0.4175"
                                     "na  ss","ss  na",& !  "-0.2024","0.2024"
                                     "nb  ca","ca  nb",& !  "0.2630","-0.2630"
                                     " n  br","br   n",& !  "-0.0838","0.0838"
                                     " n  c3","c3   n",& !  "0.0374","-0.0374"
                                     " n  ca","ca   n",& !  "-0.0074","0.0074"
                                     "nc  cd","cd  nc",& !  "0.2877","-0.2877"
                                     " n  cl","cl   n",& !  "0.0015","-0.0015"
                                     "nc  ss","ss  nc",& !  "-0.0419","0.0419"
                                     "nd  cd","cd  nd",& !  "0.2630","-0.2630"
                                     "nd  ss","ss  nd",& !  "-0.0419","0.0419"
                                     "ne  c2","c2  ne",& !  "0.2877","-0.2877"
                                     "ne   c"," c  ne",& !  "0.1394","-0.1394"
                                     "ne  ce","ce  ne",& !  "0.1406","-0.1406"
                                     "ne  py","py  ne",& !  "-0.1498","0.1498"
                                     " n   f"," f   n",& !  "0.0155","-0.0155"
                                     "nh  c2","c2  nh",& !  "0.0820","-0.0820"
                                     "nh  c3","c3  nh",& !  "0.1582","-0.1582"
                                     "nh  hn","hn  nh",& !  "0.2600","-0.2600"
                                     " n  hn","hn   n",& !  "0.0865","-0.0865"
                                     "nh  n2","n2  nh",& !  "-0.1731","0.1731"
                                     "nh  oh","oh  nh",& !  "0.0517","-0.0517"
                                     " n   i"," i   n",& !  "-0.2067","0.2067"
                                     "ni  hn","hn  ni",& !  "0.0865","-0.0865"
                                     "nj  hn","hn  nj",& !  "0.0865","-0.0865"
                                     " n  na","na   n",& !  "0.0327","-0.0327"
                                     "nn  ca","ca  nn",& !  "0.2200","-0.2200"
                                     "no   o"," o  no",& !  "-0.0400","0.0400"
                                     " n  p3","p3   n",& !  "-0.1682","0.1682"
                                     " n  p5","p5   n",& !  "-0.3046","0.3046"
                                     "np  c3","c3  np",& !  "0.1582","-0.1582"
                                     "np  hn","hn  np",& !  "0.2600","-0.2600"
                                     "nq  c3","c3  nq",& !  "0.1582","-0.1582"
                                     "nq  hn","hn  nq",& !  "0.2600","-0.2600"
                                     " n  sh","sh   n",& !  "-0.1593","0.1593"
                                     "oh  c3","c3  oh",& !  "0.0950","-0.0950"
                                     "oh  ho","ho  oh",& !  "0.2400","-0.2400"
                                     "oh  p3","p3  oh",& !  "-0.2229","0.2229"
                                     "os  c3","c3  os",& !  "0.0950","-0.0950"
                                     "p2  c2","c2  p2",& !  "0.2496","-0.2496"
                                     "p2  c3","c3  p2",& !  "0.2579","-0.2579"
                                     "p2  hp","hp  p2",& !  "0.1100","-0.1100"
                                     "p3  br","br  p3",& !  "0.1309","-0.1309"
                                     "p3  c2","c2  p3",& !  "0.2986","-0.2986"
                                     "p3  c3","c3  p3",& !  "0.2579","-0.2579"
                                     "p3   c"," c  p3",& !  "0.2828","-0.2828"
                                     "p3  ca","ca  p3",& !  "0.3270","-0.3270"
                                     "p3  cl","cl  p3",& !  "0.2065","-0.2065"
                                     "p3   f"," f  p3",& !  "0.2769","-0.2769"
                                     "p3  hp","hp  p3",& !  "0.1100","-0.1100"
                                     "p3   i"," i  p3",& !  "-0.0181","0.0181"
                                     "p3  n2","n2  p3",& !  "0.1287","-0.1287"
                                     "p3  n3","n3  p3",& !  "0.2527","-0.2527"
                                     "p3  nh","nh  p3",& !  "0.2538","-0.2538"
                                     "p3  sh","sh  p3",& !  "0.1072","-0.1072"
                                     "p4  c3","c3  p4",& !  "0.2500","-0.2500"
                                     "p4   o"," o  p4",& !  "0.5000","-0.5000"
                                     "p5  c2","c2  p5",& !  "0.6836","-0.6836"
                                     "p5  c3","c3  p5",& !  "0.2500","-0.2500"
                                     "p5  hp","hp  p5",& !  "0.3756","-0.3756"
                                     "p5  n3","n3  p5",& !  "0.2947","-0.2947"
                                     "p5   n"," n  p5",& !  "0.3046","-0.3046"
                                     "p5  n4","n4  p5",& !  "0.2947","-0.2947"
                                     "p5  nh","nh  p5",& !  "0.2947","-0.2947"
                                     "p5   o"," o  p5",& !  "0.5000","-0.5000"
                                     "p5  oh","oh  p5",& !  "0.2336","-0.2336"
                                     "pb  ca","ca  pb",& !  "0.2240","-0.2240"
                                     "pe  c2","c2  pe",& !  "0.2496","-0.2496"
                                     "pe  ce","ce  pe",& !  "0.2986","-0.2986"
                                     "py  c2","c2  py",& !  "0.6836","-0.6836"
                                     "py  ca","ca  py",& !  "0.3895","-0.3895"
                                     "py  hp","hp  py",& !  "0.3756","-0.3756"
                                     "py  ne","ne  py",& !  "0.1498","-0.1498"
                                     "py   o"," o  py",& !  "0.5000","-0.5000"
                                     "py  oh","oh  py",& !  "0.2336","-0.2336"
                                     "s4  c2","c2  s4",& !  "0.4307","-0.4307"
                                     "s4  c3","c3  s4",& !  "0.4263","-0.4263"
                                     "s4  hs","hs  s4",& !  "0.4040","-0.4040"
                                     "s4   o"," o  s4",& !  "0.2450","-0.2450"
                                     "s4  oh","oh  s4",& !  "0.2152","-0.2152"
                                     "s6   o"," o  s6",& !  "0.3500","-0.3500"
                                     "s6  oh","oh  s6",& !  "0.2093","-0.2093"
                                     "sh  hs","hs  sh",& !  "0.1718","-0.1718"
                                     "Si  c3","c3  Si",& !  "0.1540","-0.1540"
                                     "Si  ha","ha  Si",& !  "0.0258","-0.0258"
                                     "ss  c3","c3  ss",& !  "0.2300","-0.2300"
                                     "ss   c"," c  ss",& !  "0.1826","-0.1826"
                                     "ss  os","os  ss",& !  "0.0983","-0.0983"
                                     "ss  p5","p5  ss",& !  "-0.3626","0.3626"
                                     "sx  c3","c3  sx",& !  "0.4263","-0.4263"
                                     "sy  c3","c3  sy",& !  "0.3500","-0.3500"
                                     "sy   o"," o  sy",& !  "0.3500","-0.3500"
                                     "sy  oh","oh  sy" ] !  "0.2093","-0.2093" 
    bcc = [character(len=7) :: "-0.2338","0.2338",&
                               "-0.0899","0.0899",&
                               "-0.0021","0.0021",&
                               "0.0300","-0.0300",&
                               "-0.2886","0.2886",&
                               "-0.4150","0.4150",&
                               "-0.0062","0.0062",&
                               "-0.0558","0.0558",&
                               "0.0543","-0.0543",&
                               "0.0543","-0.0543",&
                               "-0.2335","0.2335",&
                               "-0.0286","0.0286",&
                               "-0.0286","0.0286",&
                               "-0.3987","0.3987",&
                               "-0.3545","0.3545",&
                               "-0.4586","0.4586",&
                               "-0.4018","0.4018",&
                               "-0.2251","0.2251",&
                               "-0.2343","0.2343",&
                               "-0.1257","0.1257",&
                               "0.0042","-0.0042",&
                               "-0.1600","0.1600",&
                               "-0.0625","0.0625",&
                               "0.0500","-0.0500",&
                               "-0.1292","0.1292",&
                               "0.0500","-0.0500",&
                               "0.0500","-0.0500",&
                               "-0.2728","0.2728",&
                               "-0.1624","0.1624",&
                               "-0.0026","0.0026",&
                               "-0.2877","0.2877",&
                               "-0.2877","0.2877",&
                               "-0.0820","0.0820",&
                               "-0.0441","0.0441",&
                               "-0.2496","0.2496",&
                               "-0.3529","0.3529",&
                               "-0.2496","0.2496",&
                               "-0.2406","0.2406",&
                               "-0.2406","0.2406",&
                               "-0.2100","0.2100",&
                               "0.0500","-0.0500",&
                               "0.0269","-0.0269",&
                               "-0.0042","0.0042",&
                               "-0.0073","0.0073",&
                               "-0.0042","0.0042",&
                               "-0.1500","0.1500",&
                               "-0.0900","0.0900",&
                               "-0.0393","0.0393",&
                               "-0.0393","0.0393",&
                               "-0.0393","0.0393",&
                               "-0.0393","0.0393",&
                               "-0.0393","0.0393",&
                               "-0.2950","0.2950",&
                               "-0.0374","0.0374",&
                               "-0.1252","0.1252",&
                               "-0.1582","0.1582",&
                               "-0.1582","0.1582",&
                               "-0.1582","0.1582",&
                               "-0.0100","0.0100",&
                               "-0.0950","0.0950",&
                               "-0.0950","0.0950",&
                               "-0.2579","0.2579",&
                               "-0.2500","0.2500",&
                               "-0.4263","0.4263",&
                               "-0.3500","0.3500",&
                               "-0.2300","0.2300",&
                               "-0.1540","0.1540",&
                               "-0.2300","0.2300",&
                               "-0.1401","0.1401",&
                               "0.0206","-0.0206",&
                               "0.0073","-0.0073",&
                               "0.0118","-0.0118",&
                               "0.0040","-0.0040",&
                               "-0.1700","0.1700",&
                               "0.0073","-0.0073",&
                               "-0.0700","0.0700",&
                               "-0.0180","0.0180",&
                               "-0.0180","0.0180",&
                               "-0.4230","0.4230",&
                               "0.0074","-0.0074",&
                               "-0.2200","0.2200",&
                               "0.0750","-0.0750",&
                               "-0.2630","0.2630",&
                               "-0.1394","0.1394",&
                               "-0.2200","0.2200",&
                               "-0.0451","0.0451",&
                               "-0.4597","0.4597",&
                               "-0.2240","0.2240",&
                               "-0.3895","0.3895",&
                               "-0.5416","0.5416",&
                               "-0.1000","0.1000",&
                               "-0.1938","0.1938",&
                               "-0.4445","0.4445",&
                               "-0.1106","0.1106",&
                               "-0.0500","0.0500",&
                               "-0.0206","0.0206",&
                               "0.0693","-0.0693",&
                               "-0.0866","0.0866",&
                               "-0.0192","0.0192",&
                               "0.0308","-0.0308",&
                               "0.0500","-0.0500",&
                               "-0.1369","0.1369",&
                               "0.0500","-0.0500",&
                               "-0.0486","0.0486",&
                               "0.0271","-0.0271",&
                               "-0.2630","0.2630",&
                               "-0.2630","0.2630",&
                               "-0.0850","0.0850",&
                               "-0.2496","0.2496",&
                               "-0.0500","0.0500",&
                               "-0.0693","0.0693",&
                               "0.0073","-0.0073",&
                               "0.0118","-0.0118",&
                               "-0.1292","0.1292",&
                               "-0.1369","0.1369",&
                               "0.0500","-0.0500",&
                               "-0.2630","0.2630",&
                               "-0.2200","0.2200",&
                               "0.0042","-0.0042",&
                               "-0.0118","0.0118",&
                               "0.0866","-0.0866",&
                               "-0.0302","0.0302",&
                               "0.0500","-0.0500",&
                               "-0.1292","0.1292",&
                               "0.0500","-0.0500",&
                               "-0.2877","0.2877",&
                               "-0.1406","0.1406",&
                               "-0.2496","0.2496",&
                               "-0.6836","0.6836",&
                               "-0.2986","0.2986",&
                               "-0.4154","0.4154",&
                               "-0.4307","0.4307",&
                               "-0.4509","0.4509",&
                               "-0.1115","0.1115",&
                               "0.0042","-0.0042",&
                               "-0.4150","0.4150",&
                               "-0.0928","0.0928",&
                               "-0.0928","0.0928",&
                               "-0.0928","0.0928",&
                               "-0.2601","0.2601",&
                               "0.0432","-0.0432",&
                               "-0.1394","0.1394",&
                               "-0.1394","0.1394",&
                               "-0.2391","0.2391",&
                               "-0.0901","0.0901",&
                               "-0.0901","0.0901",&
                               "0.1075","-0.1075",&
                               "-0.2828","0.2828",&
                               "-0.2630","0.2630",&
                               "-0.2834","0.2834",&
                               "-0.4319","0.4319",&
                               "-0.1826","0.1826",&
                               "0.0042","-0.0042",&
                               "0.0500","-0.0500",&
                               "-0.0753","0.0753",&
                               "-0.1292","0.1292",&
                               "-0.2877","0.2877",&
                               "0.0500","-0.0500",&
                               "-0.0073","0.0073",&
                               "-0.0393","0.0393",&
                               "-0.0393","0.0393",&
                               "-0.0374","0.0374",&
                               "-0.1582","0.1582",&
                               "-0.0950","0.0950",&
                               "-0.2300","0.2300",&
                               "0.0500","-0.0500",&
                               "-0.0393","0.0393",&
                               "-0.0393","0.0393",&
                               "-0.0374","0.0374",&
                               "-0.1582","0.1582",&
                               "-0.1582","0.1582",&
                               "-0.0950","0.0950",&
                               "-0.0388","0.0388",&
                               "0.1624","-0.1624",&
                               "0.1634","-0.1634",&
                               "-0.0192","0.0192",&
                               "0.2877","-0.2877",&
                               "0.1252","-0.1252",&
                               "0.0603","-0.0603",&
                               "0.0554","-0.0554",&
                               "0.2444","-0.2444",&
                               "-0.1171","0.1171",&
                               "0.1794","-0.1794",&
                               "0.0467","-0.0467",&
                               "0.0985","-0.0985",&
                               "-0.1287","0.1287",&
                               "-0.4287","0.4287",&
                               "-0.1731","0.1731",&
                               "-0.0315","0.0315",&
                               "-0.0315","0.0315",&
                               "0.1582","-0.1582",&
                               "0.2600","-0.2600",&
                               "-0.0876","0.0876",&
                               "0.0558","-0.0558",&
                               "0.0820","-0.0820",&
                               "0.1582","-0.1582",&
                               "0.2200","-0.2200",&
                               "0.0369","-0.0369",&
                               "0.0204","-0.0204",&
                               "0.2600","-0.2600",&
                               "-0.1898","0.1898",&
                               "0.0517","-0.0517",&
                               "-0.2527","0.2527",&
                               "-0.2947","0.2947",&
                               "-0.3359","0.3359",&
                               "-0.0757","0.0757",&
                               "-0.1037","0.1037",&
                               "-0.1802","0.1802",&
                               "0.0100","-0.0100",&
                               "-0.0750","0.0750",&
                               "0.0547","-0.0547",&
                               "-0.0642","0.0642",&
                               "-0.0561","0.0561",&
                               "-0.2538","0.2538",&
                               "-0.4175","0.4175",&
                               "-0.2024","0.2024",&
                               "0.2630","-0.2630",&
                               "-0.0838","0.0838",&
                               "0.0374","-0.0374",&
                               "-0.0074","0.0074",&
                               "0.2877","-0.2877",&
                               "0.0015","-0.0015",&
                               "-0.0419","0.0419",&
                               "0.2630","-0.2630",&
                               "-0.0419","0.0419",&
                               "0.2877","-0.2877",&
                               "0.1394","-0.1394",&
                               "0.1406","-0.1406",&
                               "-0.1498","0.1498",&
                               "0.0155","-0.0155",&
                               "0.0820","-0.0820",&
                               "0.1582","-0.1582",&
                               "0.2600","-0.2600",&
                               "0.0865","-0.0865",&
                               "-0.1731","0.1731",&
                               "0.0517","-0.0517",&
                               "-0.2067","0.2067",&
                               "0.0865","-0.0865",&
                               "0.0865","-0.0865",&
                               "0.0327","-0.0327",&
                               "0.2200","-0.2200",&
                               "-0.0400","0.0400",&
                               "-0.1682","0.1682",&
                               "-0.3046","0.3046",&
                               "0.1582","-0.1582",&
                               "0.2600","-0.2600",&
                               "0.1582","-0.1582",&
                               "0.2600","-0.2600",&
                               "-0.1593","0.1593",&
                               "0.0950","-0.0950",&
                               "0.2400","-0.2400",&
                               "-0.2229","0.2229",&
                               "0.0950","-0.0950",&
                               "0.2496","-0.2496",&
                               "0.2579","-0.2579",&
                               "0.1100","-0.1100",&
                               "0.1309","-0.1309",&
                               "0.2986","-0.2986",&
                               "0.2579","-0.2579",&
                               "0.2828","-0.2828",&
                               "0.3270","-0.3270",&
                               "0.2065","-0.2065",&
                               "0.2769","-0.2769",&
                               "0.1100","-0.1100",&
                               "-0.0181","0.0181",&
                               "0.1287","-0.1287",&
                               "0.2527","-0.2527",&
                               "0.2538","-0.2538",&
                               "0.1072","-0.1072",&
                               "0.2500","-0.2500",&
                               "0.5000","-0.5000",&
                               "0.6836","-0.6836",&
                               "0.2500","-0.2500",&
                               "0.3756","-0.3756",&
                               "0.2947","-0.2947",&
                               "0.3046","-0.3046",&
                               "0.2947","-0.2947",&
                               "0.2947","-0.2947",&
                               "0.5000","-0.5000",&
                               "0.2336","-0.2336",&
                               "0.2240","-0.2240",&
                               "0.2496","-0.2496",&
                               "0.2986","-0.2986",&
                               "0.6836","-0.6836",&
                               "0.3895","-0.3895",&
                               "0.3756","-0.3756",&
                               "0.1498","-0.1498",&
                               "0.5000","-0.5000",&
                               "0.2336","-0.2336",&
                               "0.4307","-0.4307",&
                               "0.4263","-0.4263",&
                               "0.4040","-0.4040",&
                               "0.2450","-0.2450",&
                               "0.2152","-0.2152",&
                               "0.3500","-0.3500",&
                               "0.2093","-0.2093",&
                               "0.1718","-0.1718",&
                               "0.1540","-0.1540",&
                               "0.0258","-0.0258",&
                               "0.2300","-0.2300",&
                               "0.1826","-0.1826",&
                               "0.0983","-0.0983",&
                               "-0.3626","0.3626",&
                               "0.4263","-0.4263",&
                               "0.3500","-0.3500",&
                               "0.3500","-0.3500",&
                               "0.2093","-0.2093" ]
    do i=1,n
       charge(i)=0.d0
       write(3,*)
       write(3,45) i,types(i),conn(i)
45     format(15x,i5,5x,a2,3x, "conn="i1)
!      write(6,'(i3,i5,a4,2x,a4)') i,conn(i),types(i),ato2(i)
       do j=1,conn(i)
          jj=c(i,j)
          bcc_real=0.d0
          do k=1,size(atype)
             bond=types(i)//"  "//types(jj)
             call stripspaces(bond)
             call stripspaces(atype(k))
             read( bcc(k), '(f10.4)' )  bcc_tmp
!             write(6,*) atype(k),"  ", bond
             if(bond.eq.atype(k)) THEN
                bcc_real=bcc_tmp
                write(3,50) types(i),types(jj),bcc_real
50              format(25x,a2,"--",a2,"  bcc= ",f8.4)
                exit
             end if
          end do
          if(bcc_real.eq.0.d0) write(3,50) types(i),types(jj),bcc_real
!          write(6,'(3x,i3,2x,a6,f10.4)') jj,bond,bcc_real
          charge(i)=charge(i)+bcc_real
       end do
       write(3,40) i,types(i),charge(i)
40     format(15x,i5,5x,A2," Total bcc =",f8.4)
    end do
    
    return
  end subroutine bcc_abcg2
  
  subroutine find_bound2(i,obound,sbound,nbound,pbound,jo,js,jn,jp,c,conn,ato2,n)
    !args
    integer i,c(n,7),conn(n),n,jo,js,jn,jp
    character*2 ato2(n)
    logical obound,sbound,nbound,pbound
    ! local 
    integer cj
    character*1  ato
    obound=.false.
    sbound=.false.
    nbound=.false.
    pbound=.false.
    jo=0
    js=0
    jn=0
    jp=0
    do j=1,conn(i)
       cj = conn(c(i,j))
       ato=ato2(c(i,j))(1:1)
       if(ato.eq."o".and.cj.le.2) THEN 
          obound=.true.
          jo=cj
       end if
       if(ato.eq."s".and.cj.le.2) THEN 
          sbound=.true.
          js=cj
       end if
       if(ato.eq."n".and.cj.le.2) THEN 
          nbound=.true.
          jn=cj
       end if
       if(ato.eq."p".and.cj.le.2) THEN 
          pbound=.true.
          jp=cj
       end if
    end do
    return
  end subroutine find_bound2

