subroutine bcc(n,ato2,conn,c,types,iring,x,y,z,bcc_types,bcc_index,bcc_bond,bcc_bond_index,charge) 
    implicit none 
! args
    integer n,conn(n),c(n,7),bcc_index(n),bcc_bond_index(n,7),iring(n)
    character*2 ato2(n),bcc_types(n),bcc_bond(n,7), types(n)
    real*8 x(n),y(n),z(n),charge(n)
!local 
    integer i,j,jj,ci,iat1,iat2,ib
    logical obound,sbound,nbound,pbound,lc1,lc2,lc3,lc4
    character*1 a1,a2
    real*8  dd
    character*2  ti,tj
    character*6 bcc_string
    integer  bcc_code(354)
    real*8   bcc_charges(354),bcc_array(26,7,26)

! bond charges are stored in a data statement
! ---------------executable starts below ----------------------------------------

!   assign bcc atomic types----
    do i=1,n
       ti=types(i)
       if(ti.eq."c3".or.ti.eq."cx".or.ti.eq."cy".or.ti.eq."cp".or.ti.eq."cq") THEN 
          bcc_types(i)="11"
          bcc_index(i)=1
       else if(ti.eq."c".or.ti.eq."ce".or.ti.eq."cf".or.ti.eq."cc".or.ti.eq."cd".or.ti.eq."c2".or.ti.eq."cv".or.ti.eq."cu".or.ti.eq."cz".or.ti.eq."cs") THEN
          call find_bound(i,obound,sbound,nbound,pbound,c,conn,ato2,n)
          if(obound.or.sbound) THEN 
             bcc_types(i)="14"
             bcc_index(i)=4
          else  if(nbound.or.pbound) THEN 
             bcc_types(i)="13"
             bcc_index(i)=3
          else
             bcc_types(i)="12"
             bcc_index(i)=2
          end if
       else if (ti.eq."c1") THEN 
          bcc_types(i)="15"
          bcc_index(i)=5
       else if (ti.eq."ca") THEN 
          call find_bound(i,obound,sbound,nbound,pbound,c,conn,ato2,n)
          if(obound.or.nbound) THEN 
             bcc_types(i)="17"
             bcc_index(i)=7
          else if(sbound) THEN
             bcc_types(i)="14"
             bcc_index(i)=4
          else if(pbound) THEN
             bcc_types(i)="13"
             bcc_index(i)=3
          else
             bcc_types(i)="16"
             bcc_index(i)=6
          end if
       else if (ti.eq."nh") THEN           
          bcc_types(i)="21"
          bcc_index(i)=8
       else if (ti.eq."n3".or.ti.eq."na".or.ti.eq."nc".or.ti.eq."nd") THEN           
          bcc_types(i)="22"
          bcc_index(i)=9
       else if (ti.eq."nb") THEN 
          bcc_types(i)="23"
          bcc_index(i)=10
       else if (ti(1:1).eq."n") THEN 
          bcc_types(i)="23"
          bcc_index(i)=10
       else if (ti.eq."nf".or.ti.eq."ne") THEN 
          bcc_types(i)="22"
          bcc_index(i)=9
       else if (ti.eq."n2") THEN 
          bcc_types(i)="24"
          bcc_index(i)=11
       else if (ti.eq."n1") THEN 
          bcc_types(i)="25"
          bcc_index(i)=12
       else if (ti.eq."os".or.ti.eq."oh") THEN 
          bcc_types(i)="31"
          bcc_index(i)=13
       else if (ti.eq."o") THEN 
          do j=1,conn(i)
             jj=c(i,j)
             if(types(jj)(1:1).eq."s") THEN
                bcc_types(i)="31"
                bcc_index(i)=13
             else
                if(iring(jj).eq.0) THEN
                   bcc_types(i)="32"
                   bcc_index(i)=14
                else
                   bcc_types(i)="33"
                   bcc_index(i)=15
                end if
             end if
          end do
       else if (ti.eq."p2".or.ti.eq."p3") THEN 
          bcc_types(i)="41"
          bcc_index(i)=16
       else if (ti.eq."p4".or.ti.eq."p5".or.ti.eq."pb".or.ti.eq."pc".or.ti.eq."pd") THEN 
          bcc_types(i)="42"
          bcc_index(i)=17
       else if (ti.eq."ss".or.ti.eq."sh".or.ti.eq."s2".or.ti.eq."s ") THEN 
          bcc_types(i)="51"
          bcc_index(i)=18
       else if (ti.eq."s4") THEN
          bcc_types(i)="52"
          bcc_index(i)=19
       else if (ti.eq."s6") THEN
          bcc_types(i)="53"
          bcc_index(i)=20
       else if (ti.eq."si") THEN
          bcc_types(i)="61"
          bcc_index(i)=21
       else if (ti(1:1).eq."f") THEN
          bcc_types(i)="71"
          bcc_index(i)=22
       else if (ti.eq."cl") THEN
          bcc_types(i)="72"
          bcc_index(i)=23
       else if (ti.eq."br") THEN
          bcc_types(i)="73"
          bcc_index(i)=24
       else if (ti(1:1).eq."i") THEN
          bcc_types(i)="74"
          bcc_index(i)=25
       else if(ti(1:1).eq."h") THEN
          bcc_types(i)="91"
          bcc_index(i)=26
       end if
    end do

!   assign bcc atomic bonds ----

    
    write(3,24) 
24  format(20x," bond list with assignment based on atomic type"// &
         15x,"   bond   ",5x,"  types  ",1x,"bond_type")

    do i=1,n 
       ci=conn(i)
       a1=ato2(i)(1:1)
       call up_low(a1,1)
       ti=types(i)
       do j=1,ci
          jj=c(i,j)
          a2=ato2(jj)(1:1)
          call up_low(a1,1)
          tj=types(jj)
          lc1=a1.eq."c".or.a1.eq."n".or.a1.eq."o"
          lc2=a2.eq."c".or.a2.eq."n".or.a2.eq."o"
          if(lc1.and.lc2) THEN 
             dd=sqrt( (x(i)-x(jj))**2 +   (y(i)-y(jj))**2 +   (z(i)-z(jj))**2 )
             if(dd.ge.1.38) THEN     !  single cno-cno bond
                if((ti.eq."ca".or.ti.eq."nb").and.(tj.eq."ca".or.tj.eq."nb")) THEN  
                   bcc_bond(i,j)="07"             !  aro c-c single bond
                   bcc_bond_index(i,j)=5
                else
                   bcc_bond(i,j)="01"
                   bcc_bond_index(i,j)=1
                end if
             else  if(dd.lt.1.38.and.dd.gt.1.20) THEN 
                if((ti.eq."ca".or.ti.eq."nb").and.(tj.eq."ca".or.tj.eq."nb")) THEN  
                   bcc_bond(i,j)="08"             !  aro c-c double bond
                   bcc_bond_index(i,j)=5
                else if(ti.eq."os".or.tj.eq."os") THEN  
                   bcc_bond(i,j)="01"             !  os-ca single bond
                   bcc_bond_index(i,j)=1
                else
                   bcc_bond(i,j)="02"             !  double  cno-cno bond
                   bcc_bond_index(i,j)=2
                end if
             else
                bcc_bond(i,j)="03"                ! triple cno-cno bond
                bcc_bond_index(i,j)=3
             end if
          end if
          lc1=a1.eq."c".and.a2.eq."p"
          lc2=a1.eq."p".and.a2.eq."c"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."c".and.a2.eq."s"
          lc2=a1.eq."s".and.a2.eq."c"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."n".and.a2.eq."p"
          lc2=a1.eq."p".and.a2.eq."n"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."o".and.a2.eq."p"
          lc2=a1.eq."p".and.a2.eq."o"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."o".and.a2.eq."a"
          lc2=a1.eq."a".and.a2.eq."o"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."s".and.a2.eq."p"
          lc2=a1.eq."p".and.a2.eq."s"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."o".and.a2.eq."s"
          lc2=a1.eq."s".and.a2.eq."o"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="02"                
             bcc_bond_index(i,j)=2
          end if
          lc1=a1.eq."n".and.a2.eq."s"
          lc2=a1.eq."s".and.a2.eq."n"
          if(lc1.or.lc2) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."s".and.a2.eq."s"
          if(lc1) THEN 
             bcc_bond(i,j)="02"                
             bcc_bond_index(i,j)=2
          end if
          lc1=a1.eq."p".and.a2.eq."p"
          if(lc1) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."o".and.a2.eq."o"
          if(lc1) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=a1.eq."h".or.a2.eq."h"  ! all h-X are single
          if(lc1) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          lc1=ato2(i).eq."cl".or.ato2(jj).eq."cl" !all X-* are single with X halogen 
          lc2=ato2(i).eq."br".or.ato2(jj).eq."br"
          lc3=a1.eq."f".or.a2.eq."f"
          lc4=a1.eq."i".or.a2.eq."i"
          if(lc1.or.lc2.or.lc3.or.lc4) THEN 
             bcc_bond(i,j)="01"                
             bcc_bond_index(i,j)=1
          end if
          write(3,25) i,jj,types(i),types(jj),bcc_bond(i,j),bcc_bond_index(i,j)
25        format(15x,I3" --",I3,5x,2(2x,A2),5x,A2,"=",i1)
       end do
    end do
!   assign_bond charges
    bcc_charges=0.d0
    call bcc_data(bcc_code,bcc_charges)
    bcc_array=0.d0
    do i=1,354
       iat1=1
       iat2=1
       ib=1
       write(bcc_string,"(I6)") bcc_code(i)
!      atom i 
       if(bcc_string(1:2).eq."11") THEN 
          iat1=1
       else if(bcc_string(1:2).eq."12") THEN 
          iat1=2
       else if(bcc_string(1:2).eq."13") THEN 
          iat1=3
       else if(bcc_string(1:2).eq."14") THEN 
          iat1=4
       else if(bcc_string(1:2).eq."15") THEN 
          iat1=5
       else if(bcc_string(1:2).eq."16") THEN 
          iat1=6
       else if(bcc_string(1:2).eq."17") THEN 
          iat1=7
       else if(bcc_string(1:2).eq."21") THEN 
          iat1=8
       else if(bcc_string(1:2).eq."22") THEN 
          iat1=9
       else if(bcc_string(1:2).eq."23") THEN 
          iat1=10
       else if(bcc_string(1:2).eq."24") THEN 
          iat1=11
       else if(bcc_string(1:2).eq."25") THEN 
          iat1=12
       else if(bcc_string(1:2).eq."31") THEN 
          iat1=13
       else if(bcc_string(1:2).eq."32") THEN 
          iat1=14
       else if(bcc_string(1:2).eq."33") THEN 
          iat1=15
       else if(bcc_string(1:2).eq."41") THEN 
          iat1=16
       else if(bcc_string(1:2).eq."42") THEN 
          iat1=17
       else if(bcc_string(1:2).eq."51") THEN 
          iat1=18
       else if(bcc_string(1:2).eq."52") THEN 
          iat1=19
       else if(bcc_string(1:2).eq."53") THEN 
          iat1=20
       else if(bcc_string(1:2).eq."61") THEN 
          iat1=21
       else if(bcc_string(1:2).eq."71") THEN 
          iat1=22
       else if(bcc_string(1:2).eq."72") THEN 
          iat1=23
       else if(bcc_string(1:2).eq."73") THEN 
          iat1=24
       else if(bcc_string(1:2).eq."74") THEN 
          iat1=25
       else if(bcc_string(1:2).eq."91") THEN 
          iat1=26
       end if

!      bond 
       if(bcc_string(3:4).eq."01") THEN 
          ib=1
       else if(bcc_string(3:4).eq."02") THEN 
          ib=2
       else if(bcc_string(3:4).eq."03") THEN 
          ib=3
       else if(bcc_string(3:4).eq."06") THEN 
          ib=4
       else if(bcc_string(3:4).eq."07") THEN 
          ib=5
       else if(bcc_string(3:4).eq."08") THEN 
          ib=6
       else if(bcc_string(3:4).eq."09") THEN 
          ib=7
       end if

!      atom j 
       if(bcc_string(5:6).eq."11") THEN 
          iat2=1
       else if(bcc_string(5:6).eq."12") THEN 
          iat2=2
       else if(bcc_string(5:6).eq."13") THEN 
          iat2=3
       else if(bcc_string(5:6).eq."14") THEN 
          iat2=4
       else if(bcc_string(5:6).eq."15") THEN 
          iat2=5
       else if(bcc_string(5:6).eq."16") THEN 
          iat2=6
       else if(bcc_string(5:6).eq."17") THEN 
          iat2=7
       else if(bcc_string(5:6).eq."21") THEN 
          iat2=8
       else if(bcc_string(5:6).eq."22") THEN 
          iat2=9
       else if(bcc_string(5:6).eq."23") THEN 
          iat2=10
       else if(bcc_string(5:6).eq."24") THEN 
          iat2=11
       else if(bcc_string(5:6).eq."25") THEN 
          iat2=12
       else if(bcc_string(5:6).eq."31") THEN 
          iat2=13
       else if(bcc_string(5:6).eq."32") THEN 
          iat2=14
       else if(bcc_string(5:6).eq."33") THEN 
          iat2=15
       else if(bcc_string(5:6).eq."41") THEN 
          iat2=16
       else if(bcc_string(5:6).eq."42") THEN 
          iat2=17
       else if(bcc_string(5:6).eq."51") THEN 
          iat2=18
       else if(bcc_string(5:6).eq."52") THEN 
          iat2=19
       else if(bcc_string(5:6).eq."53") THEN 
          iat2=20
       else if(bcc_string(5:6).eq."61") THEN 
          iat2=21
       else if(bcc_string(5:6).eq."71") THEN 
          iat2=22
       else if(bcc_string(5:6).eq."72") THEN 
          iat2=23
       else if(bcc_string(5:6).eq."73") THEN 
          iat2=24
       else if(bcc_string(5:6).eq."74") THEN 
          iat2=25
       else if(bcc_string(5:6).eq."91") THEN 
          iat2=26
       end if
       bcc_array(iat1,ib,iat2)= bcc_charges(i)
       bcc_array(iat2,ib,iat1)=-bcc_charges(i)
    end do

    write(3,34) 
34  format(//,20x," bond charges on atoms")
    do i=1,n
       iat1=bcc_index(i)
       charge(i)=0.d0
       write(3,*)
       write(3,45) i,types(i)
45     format(15x,i5,5x,a2)
       
       do j=1,conn(i)
          jj=c(i,j)
          iat2=bcc_index(jj)
          ib=bcc_bond_index(i,j)
          write(3,50) types(i),types(jj),iat1,ib,iat2,bcc_types(i),bcc_bond(i,j),bcc_types(jj),bcc_array(iat1,ib,iat2)
50        format(25x,a2,"--",a2,3x,3i2.2,"=",3a2,3x,"bcc=",f8.4) 
          charge(i)=charge(i)+bcc_array(iat1,ib,iat2)
       end do
       write(3,40) i,types(i),charge(i)
40     format(15x,i5,5x,A2," Total bcc =",f8.4)
    end do
    
    return
  end subroutine bcc

  subroutine find_bound(i,obound,sbound,nbound,pbound,c,conn,ato2,n)
    !args
    integer i,c(n,7),conn(n),n
    character*2 ato2(n)
    logical obound,sbound,nbound,pbound
    ! local 
    integer cj
    character*1  ato
    obound=.false.
    sbound=.false.
    nbound=.false.
    pbound=.false.
    do j=1,conn(i)
       cj = conn(c(i,j))
       ato=ato2(c(i,j))(1:1)
       if(ato.eq."o".and.cj.le.2) THEN 
          obound=.true.
       end if
       if(ato.eq."s".and.cj.le.2) THEN 
          sbound=.true.
       end if
       if(ato.eq."n".and.cj.le.2) THEN 
          nbound=.true.
       end if
       if(ato.eq."p".and.cj.le.2) THEN 
          pbound=.true.
       end if
    end do
    return
  end subroutine find_bound
