subroutine abcg2_bcc_data(bcc_code_r,bcc_charges_r)
  integer nt
  parameter(nt=443)
  character*6  bcc_code(nt)
  real*8  bcc_charges(nt)
  character*6  bcc_code_r(nt )
  real*8  bcc_charges_r(nt )
! Jakalian 2002 atomic and bond types     
!C4	Tetravalent carbon	                                                  11
!C 	Trivalent carbon, double bonded to carbon	                          12
!C 	Trivalent carbon, double bonded to nitrogen or phosphorus	          13
!C 	Trivalent carbon, double bonded to oxygen or sulfur	                  14
!C1,2	Univalent or divalent carbon	                                          15
!Car	Aromatic carbon	                                                          16
!C 	Aromatic carbon bonded to an aromatic oxygen or nitrogen with a lone pair 17
!N 	Amine nitrogen	                                                          21
!N 	Trivalent nitrogen with a delocalized lone pair	                          22
!N 	Trivalent nitrogen with a highly delocalized lone pair	                  23
!N2	Neutral divalent nitrogen	                                          24
!N 	Univalent or cationic divalent nitrogen	                                  25
!O1,2	Univalent or divalent oxygen	                                          31
!O 	Double-bonded oxygen in an ester or acid	                          32
!O 	Double-bonded oxygen in a lactone or lactam	                          33
!P2,3	Divalent or trivalent phosphorus	                                  41
!P 	Trivalent or tetravalent double-bonded phosphorus	                  42
!S1,2	Univalent or divalent sulfur	                                          51
!S3	Trivalent sulfur	                                                  52
!S4	Tetravalent sulfur	                                                  53
!Si4	Tetravalent silicon	                                                  61
!F1	Fluorine	                                                          71
!Cl1	Chlorine	                                                          72
!Br1	Bromine	                                                                  73
!I1	Iodine	                                                                  74
!H1	Hydrogen	                                                          91
!Single bond	                                                                  01
!Double bond	                                                                  02
!Triple bond	                                                                  03
!Dative bond	                                                                  06
!Aromatic single bond	                                                          07
!Aromatic double bond	                                                          08
!Single bond with charge or delocalized bond	                                  09

! bond_charge arrays taken from He 2025 (amber.org) 

  
! CORR    2X   21     #for ammonium nitrogen
! CORR    2F   21     #for nitrogen connecting to anthraquinone (anthracenedione)
! CORR    2Y   23     #for nitrogen in arginine ion, forming double bond
! CORR    20   23     #for nitrogen in -NO2
! CORR    2W   22     #for nitrogen in -N-C(=O)-c in a ring
! CORR    2V   22     #for nitrogen in -N-C(=O)-benzene
! CORR    2U   22     #for nitrogen in -N-C(=O)-n in a ring
! CORR    2T   22     #for nitrogen in benzene-N-C(=O)
! CORR    2A   24     #for nitrogen in -N=C=O
! CORR    2B   24     #for nitrogen in -N=C=S
! CORR    2C   24     #
! CORR    2D   24     #for nitrogen in -N=N-
! CORR    2E   24     #for nitrogen in -O-N=C-
! CORR    29   24     #for nitrogen in -N=C-
! CORR    28   24     #for nitrogen in -N= in 5-member rings 
! CORR    27   24     #for nitrogen in -N=C-N= in 6-member rings
! CORR    26   24     #for nitrogen in -N=C-C=N- in 6-member rings 
! CORR    3X   31     #for both oxygen atoms in neutral acids
! CORR    3Y   31     #for both oxygen atoms in charged carboxylic acid 
! CORR    30   31     #for oxygen in poly-alcohols
! CORR    34   31     #for oxygen in -O-C(OC)-O-C-
! CORR    3F   31     #for oxygen in O=P of -P(=O)-F
! CORR    3P   31     #for oxygen in -O- of -P(=O)-O-
! CORR    3Q   31     #for oxygen in -O- of -P(=S)-O-
! CORR    3S   31     #for oxygen in -OH of -O-S(=O)(=O)-OH
! CORR    18   11     #for carbon in terminal -CH3
! CORR    19   11     #for carbon in tertiary alkanes R1-C(R2)(R3)-R4
! CORR    1A   14     #for carbon connecting two bezene rings ph-C(=O)-ph
! CORR    43   42     #for P in -P(=O)- or -P(=S)-
! CORR    44   42     #for P in -P(=S)-ph
! CORR    50   51     #for S in 3-membered ring -C1SC1-
! CORR    54   51     #for S in -S-P(=O)- or -S-P(=S)-
! CORR    7X   71     #for F in -CF3
! CORR    7Y   72     #for Cl in -CCl3
! CORR    7Z   73     #for Br in -CBr3
! CORR    7W   74     #for I  in -CI3
 
  
  data bcc_code / &
! type specification is given in a six digits code as a1/bn/a2 where 
! a1 and a2 specify the bonded atoms and bn the bond type (single/double/resonant etc) 

! end of type specification
"110111",&  ! 0.0000,&   
"110112",&  ! 0.0042,&   
"110113",&  ! -0.0753,&  
"110114",&  ! -0.0500,&  
"110115",&  ! -0.0269,&  
"110116",&  ! 0.0073,&   
"110117",&  ! -0.0943,&  
"110121",&  ! 0.1582,&   
"110122",&  ! 0.0374,&   
"110123",&  ! 0.0100,&   
"110124",&  ! 0.1252,&   
"110125",&  ! 0.1825,&   
"110134",&  ! 0.0600,&   
"110131",&  ! 0.0950,&   
"11013P",&  ! 0.0950,&   
"11013Q",&  ! -0.1050,&  
"110141",&  ! 0.2579,&   
"110142",&  ! 0.2500,&   
"110150",&  ! 0.1500,&   
"110151",&  ! 0.2300,&   
"110154",&  ! 0.0900,&   
"110152",&  ! 0.4263,&   
"110153",&  ! 0.3500,&   
"110161",&  ! 0.1540,&   
"11017X",&  ! -0.0500,&  
"110171",&  ! 0.0900,&   
"11017Y",&  ! 0.1500,&   
"110172",&  ! 0.1500,&   
"11017Z",&  ! 0.2400,&   
"110173",&  ! 0.2100,&   
"11017W",&  ! 0.4900,&   
"110174",&  ! 0.2950,&   
"110191",&  ! 0.0393,&   
"120112",&  ! 0.0000,&   
"120113",&  ! -0.0866,&  
"120114",&  ! -0.0192,&  
"120115",&  ! 0.0333,&   
"120116",&  ! 0.0118,&   
"120117",&  ! -0.1098,&  
"120121",&  ! 0.0820,&   
"120122",&  ! 0.0026,&   
"120123",&  ! -0.0271,&  
"120124",&  ! 0.1406,&   
"120125",&  ! 0.4897,&   
"120131",&  ! 0.0441,&   
"120141",&  ! 0.2986,&   
"120142",&  ! 0.4154,&   
"120151",&  ! 0.2406,&   
"120152",&  ! 0.4307,&   
"120153",&  ! 0.4509,&   
"120161",&  ! 0.2128,&   
"120171",&  ! 0.0625,&   
"120172",&  ! 0.1600,&   
"120173",&  ! 0.1257,&   
"120174",&  ! 0.2728,&   
"120191",&  ! -0.0500,&  
"130113",&  ! 0.0000,&   
"130114",&  ! 0.0693,&   
"130115",&  ! 0.0302,&   
"130116",&  ! 0.0839,&   
"130117",&  ! -0.0297,&  
"130121",&  ! 0.1522,&   
"130122",&  ! 0.0069,&   
"130123",&  ! 0.0388,&   
"130124",&  ! 0.2193,&   
"130125",&  ! 0.2406,&   
"130131",&  ! 0.1336,&   
"130141",&  ! 0.3529,&   
"130142",&  ! 0.5230,&   
"130151",&  ! 0.2242,&   
"130152",&  ! 0.4296,&   
"130153",&  ! 0.5077,&   
"130171",&  ! 0.1055,&   
"130172",&  ! 0.1123,&   
"130173",&  ! 0.1253,&   
"130174",&  ! 0.2752,&   
"130191",&  ! 0.1292,&   
"140114",&  ! 0.0000,&   
"140115",&  ! -0.0308,&  
"140116",&  ! 0.0206,&   
"140117",&  ! -0.0895,&  
"140122",&  ! 0.0000,&   
"140123",&  ! -0.0432,&  
"140124",&  ! 0.1394,&   
"140125",&  ! 0.0070,&   
"140131",&  ! 0.0901,&   
"140141",&  ! 0.2828,&   
"140142",&  ! 0.4820,&   
"140151",&  ! 0.1826,&   
"140152",&  ! 0.4319,&   
"140153",&  ! 0.4840,&   
"140171",&  ! 0.1115,&   
"140172",&  ! 0.0486,&   
"140173",&  ! 0.1106,&   
"140174",&  ! 0.2601,&   
"140191",&  ! 0.0928,&   
"150115",&  ! 0.0000,&   
"150116",&  ! 0.0040,&   
"150117",&  ! -0.1070,&  
"150121",&  ! 0.0558,&   
"150122",&  ! 0.0062,&   
"150123",&  ! -0.0543,&  
"150124",&  ! 0.0520,&   
"150125",&  ! 0.0798,&   
"150131",&  ! 0.0286,&   
"150141",&  ! 0.3987,&   
"150142",&  ! 0.3545,&   
"150151",&  ! 0.2251,&   
"150152",&  ! 0.4586,&   
"150153",&  ! 0.4018,&   
"150161",&  ! 0.2343,&   
"150171",&  ! 0.0021,&   
"150172",&  ! 0.0899,&   
"150173",&  ! 0.2338,&   
"150174",&  ! 0.2886,&   
"150191",&  ! -0.0300,&  
"160116",&  ! 0.0000,&   
"160117",&  ! -0.1075,&  
"160121",&  ! 0.2200,&   
"16012T",&  ! -0.1000,&  
"160122",&  ! -0.0074,&  
"160123",&  ! -0.0452,&  
"160124",&  ! 0.1394,&   
"160125",&  ! 0.1877,&   
"160131",&  ! 0.0451,&   
"16013P",&  ! 0.0451,&   
"16013Q",&  ! -0.1000,&  
"160141",&  ! 0.3270,&   
"160142",&  ! 0.3895,&   
"160151",&  ! 0.1000,&   
"160152",&  ! 0.4285,&   
"160153",&  ! 0.4445,&   
"160161",&  ! 0.1938,&   
"160171",&  ! 0.0700,&   
"160172",&  ! 0.1700,&   
"160173",&  ! 0.1401,&   
"160174",&  ! 0.4230,&   
"160191",&  ! 0.0180,&   
"170117",&  ! 0.0000,&   
"170121",&  ! 0.1929,&   
"170122",&  ! 0.0799,&   
"170123",&  ! 0.0635,&   
"170124",&  ! 0.2190,&   
"170125",&  ! 0.2100,&   
"170131",&  ! 0.1703,&   
"170141",&  ! 0.4597,&   
"170142",&  ! 0.4543,&   
"170151",&  ! 0.3273,&   
"170152",&  ! 0.5416,&   
"170153",&  ! 0.5169,&   
"170171",&  ! 0.1402,&   
"170172",&  ! 0.1660,&   
"170173",&  ! 0.2312,&   
"170174",&  ! 0.3528,&   
"170191",&  ! 0.1369,&   
"210121",&  ! 0.0000,&   
"210122",&  ! -0.0302,&  
"210123",&  ! -0.1185,&  
"210124",&  ! 0.0867,&   
"210131",&  ! -0.0517,&  
"210141",&  ! 0.2527,&   
"210142",&  ! 0.2947,&   
"210151",&  ! 0.0757,&   
"210152",&  ! 0.3531,&   
"210153",&  ! 0.3359,&   
"210161",&  ! 0.1037,&   
"210171",&  ! -0.0204,&  
"210172",&  ! -0.0369,&  
"210173",&  ! 0.0876,&   
"210174",&  ! 0.1898,&   
"2F0191",&  ! -0.1000,&  
"210191",&  ! -0.2600,&  
"220122",&  ! 0.0000,&   
"220123",&  ! -0.0327,&  
"220124",&  ! 0.1326,&   
"220125",&  ! 0.0235,&   
"220131",&  ! -0.0059,&  
"220141",&  ! 0.1682,&   
"220142",&  ! 0.3046,&   
"220151",&  ! 0.1593,&   
"220152",&  ! 0.3657,&   
"220153",&  ! 0.3322,&   
"220171",&  ! -0.0155,&  
"220172",&  ! -0.0015,&  
"220173",&  ! 0.0838,&   
"220174",&  ! 0.2067,&   
"2U0191",&  ! -0.2000,&  
"2T0191",&  ! 0.0800,&   
"220191",&  ! -0.0865,&  
"230123",&  ! 0.0000,&   
"230124",&  ! 0.1794,&   
"230131",&  ! 0.0600,&   
"230141",&  ! 0.2538,&   
"230142",&  ! 0.4175,&   
"230151",&  ! 0.2024,&   
"230153",&  ! 0.3418,&   
"230161",&  ! 0.1766,&   
"230171",&  ! 0.0561,&   
"230172",&  ! 0.0642,&   
"230173",&  ! 0.1802,&   
"230191",&  ! -0.1000,&  
"240124",&  ! 0.0000,&   
"240125",&  ! 0.1043,&   
"2E0131",&  ! 0.0000,&   
"240131",&  ! -0.0985,&  
"240141",&  ! 0.1287,&   
"240142",&  ! 0.1498,&   
"240151",&  ! 0.0315,&   
"240152",&  ! 0.1731,&   
"240153",&  ! 0.2714,&   
"240161",&  ! 0.1150,&   
"240171",&  ! -0.0554,&  
"240172",&  ! -0.0603,&  
"240173",&  ! 0.0192,&   
"240174",&  ! 0.1171,&   
"240191",&  ! -0.2444,&  
"250191",&  ! -0.1634,&  
"310131",&  ! 0.0000,&   
"310141",&  ! 0.2229,&   
"310142",&  ! 0.2336,&   
"310151",&  ! 0.0442,&   
"310152",&  ! 0.2152,&   
"310153",&  ! 0.2093,&   
"310161",&  ! 0.0083,&   
"310171",&  ! 0.0375,&   
"310172",&  ! 0.0014,&   
"310173",&  ! 0.0699,&   
"310174",&  ! 0.1712,&   
"300191",&  ! -0.3000,&  
"310191",&  ! -0.2400,&  
"3P0191",&  ! -0.2100,&  
"3Q0191",&  ! 0.0000,&   
"3S0191",&  ! -0.1000,&  
"410141",&  ! 0.0000,&   
"410142",&  ! 0.2762,&   
"410151",&  ! -0.1072,&  
"410161",&  ! 0.0592,&   
"410171",&  ! -0.2769,&  
"410172",&  ! -0.2065,&  
"410173",&  ! -0.1309,&  
"410174",&  ! 0.0181,&   
"410191",&  ! -0.1100,&  
"420142",&  ! 0.0000,&   
"420151",&  ! -0.3626,&  
"420152",&  ! 0.0675,&   
"420171",&  ! -0.1976,&  
"420172",&  ! -0.3077,&  
"420173",&  ! -0.2425,&  
"420191",&  ! -0.3756,&  
"510151",&  ! 0.0000,&   
"510152",&  ! 0.2576,&   
"510153",&  ! 0.2971,&   
"510161",&  ! -0.0936,&  
"510171",&  ! -0.0547,&  
"510172",&  ! -0.0260,&  
"510173",&  ! 0.1105,&   
"510191",&  ! -0.1718,&  
"520152",&  ! 0.0000,&   
"520172",&  ! -0.2350,&  
"520191",&  ! -0.4040,&  
"530171",&  ! -0.2041,&  
"530172",&  ! -0.2761,&  
"530173",&  ! -0.1970,&  
"530174",&  ! -0.1490,&  
"530191",&  ! -0.4588,&  
"610172",&  ! -0.0555,&  
"610191",&  ! -0.0258,&  
"120212",&  ! 0.0000,&   
"120215",&  ! -0.0631,&  
"130223",&  ! 0.0547,&   
"130224",&  ! 0.2877,&   
"130225",&  ! 0.1624,&   
"130241",&  ! 0.2496,&   
"130242",&  ! 0.6836,&   
"1A0231",&  ! 0.2391,&   
"140231",&  ! 0.2391,&   
"140232",&  ! 0.1400,&   
"140233",&  ! 0.2000,&   
"140251",&  ! 0.2834,&   
"140252",&  ! 0.4447,&   
"140253",&  ! 0.5617,&   
"150215",&  ! 0.0000,&   
"150224",&  ! 0.2204,&   
"150231",&  ! 0.2335,&   
"150242",&  ! 0.7150,&   
"150251",&  ! 0.1200,&   
"150252",&  ! 0.3052,&   
"230224",&  ! 0.1731,&   
"240224",&  ! 0.0000,&   
"240225",&  ! 0.0040,&   
"240231",&  ! -0.0467,&  
"240241",&  ! 0.0535,&   
"240242",&  ! 0.4287,&   
"240251",&  ! 0.1684,&   
"240252",&  ! 0.3764,&   
"240253",&  ! 0.4265,&   
"250225",&  ! 0.0000,&   
"310241",&  ! 0.1315,&   
"310242",&  ! 0.5000,&   
"3F0243",&  ! 0.3500,&   
"3P0243",&  ! 0.5000,&   
"3Q0244",&  ! 0.5000,&   
"310251",&  ! 0.1583,&   
"310252",&  ! 0.2450,&   
"310253",&  ! 0.3500,&   
"410241",&  ! 0.0000,&   
"420251",&  ! -0.5630,&  
"440251",&  ! -0.8500,&  
"510252",&  ! 0.3295,&   
"150315",&  ! 0.0000,&   
"150325",&  ! 0.4150,&   
"250325",&  ! 0.0000,&   
"210631",&  ! -0.1168,&  
"220631",&  ! 0.0465,&   
"230631",&  ! 0.1317,&   
"240631",&  ! -0.0817,&  
"250631",&  ! -0.0543,&  
"250651",&  ! 0.1473,&   
"160716",&  ! 0.0000,&   
"160717",&  ! 0.0000,&   
"160723",&  ! -0.0750,&  
"160731",&  ! -0.1518,&  
"160741",&  ! 0.2240,&   
"160751",&  ! 0.1250,&   
"170717",&  ! 0.0000,&   
"170723",&  ! 0.0885,&   
"170724",&  ! 0.2630,&   
"170727",&  ! 0.0000,&   
"170731",&  ! 0.0850,&   
"170741",&  ! 0.2464,&   
"170751",&  ! 0.3144,&   
"230723",&  ! 0.0000,&   
"230724",&  ! 0.1698,&   
"230731",&  ! 0.0677,&   
"230741",&  ! 0.1806,&   
"230751",&  ! 0.1565,&   
"240724",&  ! 0.0000,&   
"240731",&  ! -0.0723,&  
"240741",&  ! 0.0456,&   
"240751",&  ! 0.0419,&   
"310741",&  ! 0.0710,&   
"310751",&  ! 0.0983,&   
"410751",&  ! 0.0587,&   
"510751",&  ! 0.0000,&   
"160816",&  ! 0.0000,&   
"160817",&  ! 0.0000,&   
"160823",&  ! -0.0243,&  
"160831",&  ! -0.1518,&  
"160841",&  ! 0.2240,&   
"160851",&  ! 0.1250,&   
"170817",&  ! 0.0000,&   
"170823",&  ! 0.0885,&   
"170824",&  ! 0.2630,&   
"170827",&  ! 0.0000,&   
"170831",&  ! 0.1294,&   
"170841",&  ! 0.2464,&   
"170851",&  ! 0.3144,&   
"230824",&  ! 0.1698,&   
"240824",&  ! 0.0000,&   
"240841",&  ! 0.0456,&   
"110931",&  ! 0.1615,&   
"110951",&  ! 0.0833,&   
"120931",&  ! 0.1844,&   
"120951",&  ! 0.1879,&   
"130931",&  ! 0.3046,&   
"130951",&  ! 0.1969,&   
"140931",&  ! 0.2653,&   
"140951",&  ! 0.1713,&   
"150931",&  ! 0.2549,&   
"150951",&  ! 0.3281,&   
"160931",&  ! 0.2797,&   
"160951",&  ! 0.2541,&   
"170931",&  ! 0.3370,&   
"170951",&  ! 0.3476,&   
"230931",&  ! 0.0400,&   
"310941",&  ! 0.2354,&   
"310942",&  ! 0.3195,&   
"310951",&  ! 0.1530,&   
"310952",&  ! 0.3916,&   
"310953",&  ! 0.3228,&   
"510953",&  ! 0.5218,&   
"161016",&  ! 0.0000,&   
"161017",&  ! -0.0653,&  
"161023",&  ! -0.0243,&  
"161031",&  ! -0.1518,&  
"161041",&  ! 0.2240,&   
"161051",&  ! 0.2699,&   
"171017",&  ! 0.0000,&   
"171023",&  ! 0.0885,&   
"171024",&  ! 0.2630,&   
"171031",&  ! 0.1294,&   
"171041",&  ! 0.2464,&   
"171051",&  ! 0.3144,&   
"231023",&  ! 0.0000,&   
"231024",&  ! 0.1698,&   
"231031",&  ! 0.0677,&   
"231041",&  ! 0.1806,&   
"231051",&  ! 0.1565,&   
"241024",&  ! 0.0000,&   
"241031",&  ! -0.0723,&  
"241041",&  ! 0.0456,&   
"241051",&  ! 0.0419,&   
"311041",&  ! 0.0710,&   
"311051",&  ! 0.0983,&   
"411051",&  ! 0.0587,&   
"511051",&  ! 0.0000,&   
"111111",&  ! 0.0000,&   
"121112",&  ! 0.0000,&   
"131113",&  ! 0.0000,&   
"141114",&  ! 0.0000,&   
"151115",&  ! 0.0000,&   
"161116",&  ! 0.0000,&   
"171117",&  ! 0.0000,&   
"211121",&  ! 0.0000,&   
"221122",&  ! 0.0000,&   
"231123",&  ! 0.0000,&   
"241124",&  ! 0.0000,&   
"251125",&  ! 0.0000,&   
"311131",&  ! 0.0000,&   
"321132",&  ! 0.0000,&   
"331133",&  ! 0.0000,&   
"411141",&  ! 0.0000,&   
"421142",&  ! 0.0000,&   
"511151",&  ! 0.0000,&   
"521152",&  ! 0.0000,&   
"531153",&  ! 0.0000,&   
"611161",&  ! 0.0000,&   
"711171",&  ! 0.0000,&   
"721172",&  ! 0.0000,&   
"731173",&  ! 0.0000,&   
"741174",&  ! 0.0000,&   
"911191",&  ! 0.0000,&   
"2X0191",&  ! -0.2600,&  
"13022Y",&  ! 0.4600,&   
"14023X",&  ! 0.1500,&   
"14013X",&  ! 0.0901,&   
"3X0191",&  ! -0.2350,&  
"14093Y",&  ! 0.1600,&   
"11012X",&  ! 0.1300/    
"14023Y",&  ! 0.2391/    
"180131",&  ! 0.0950/     
"200931",&  ! 0.0400/     
"180191" /  ! 0.0393,&   
!
! bond charges starts here 
!
data bcc_charges / &
0.0000,&    
0.0042,&
-0.0753,&
-0.0500,&
-0.0269,&
0.0073,&
-0.0943,&
0.1582,&
0.0374,&
0.0100,&
0.1252,&
0.1825,&
0.0600,&
0.0950,&
0.0950,&
-0.1050,&
0.2579,&
0.2500,&
0.1500,&
0.2300,&
0.0900,&
0.4263,&
0.3500,&
0.1540,&
-0.0500,&
0.0900,&
0.1500,&
0.1500,&
0.2400,&
0.2100,&
0.4900,&
0.2950,&
0.0393,&
0.0000,&
-0.0866,&
-0.0192,&
0.0333,&
0.0118,&
-0.1098,&
0.0820,&
0.0026,&
-0.0271,&
0.1406,&
0.4897,&
0.0441,&
0.2986,&
0.4154,&
0.2406,&
0.4307,&
0.4509,&
0.2128,&
0.0625,&
0.1600,&
0.1257,&
0.2728,&
-0.0500,&
0.0000,&
0.0693,&
0.0302,&
0.0839,&
-0.0297,&
0.1522,&
0.0069,&
0.0388,&
0.2193,&
0.2406,&
0.1336,&
0.3529,&
0.5230,&
0.2242,&
0.4296,&
0.5077,&
0.1055,&
0.1123,&
0.1253,&
0.2752,&
0.1292,&
0.0000,&
-0.0308,&
0.0206,&
-0.0895,&
0.0000,&
-0.0432,&
0.1394,&
0.0070,&
0.0901,&
0.2828,&
0.4820,&
0.1826,&
0.4319,&
0.4840,&
0.1115,&
0.0486,&
0.1106,&
0.2601,&
0.0928,&
0.0000,&
0.0040,&
-0.1070,&
0.0558,&
0.0062,&
-0.0543,&
0.0520,&
0.0798,&
0.0286,&
0.3987,&
0.3545,&
0.2251,&
0.4586,&
0.4018,&
0.2343,&
0.0021,&
0.0899,&
0.2338,&
0.2886,&
-0.0300,&
0.0000,&
-0.1075,&
0.2200,&
-0.1000,&
-0.0074,&
-0.0452,&
0.1394,&
0.1877,&
0.0451,&
0.0451,&
-0.1000,&
0.3270,&
0.3895,&
0.1000,&
0.4285,&
0.4445,&
0.1938,&
0.0700,&
0.1700,&
0.1401,&
0.4230,&
0.0180,&
0.0000,&
0.1929,&
0.0799,&
0.0635,&
0.2190,&
0.2100,&
0.1703,&
0.4597,&
0.4543,&
0.3273,&
0.5416,&
0.5169,&
0.1402,&
0.1660,&
0.2312,&
0.3528,&
0.1369,&
0.0000,&
-0.0302,&
-0.1185,&
0.0867,&
-0.0517,&
0.2527,&
0.2947,&
0.0757,&
0.3531,&
0.3359,&
0.1037,&
-0.0204,&
-0.0369,&
0.0876,&
0.1898,&
-0.1000,&
-0.2600,&
0.0000,&
-0.0327,&
0.1326,&
0.0235,&
-0.0059,&
0.1682,&
0.3046,&
0.1593,&
0.3657,&
0.3322,&
-0.0155,&
-0.0015,&
0.0838,&
0.2067,&
-0.2000,&
0.0800,&
-0.0865,&
0.0000,&
0.1794,&
0.0600,&
0.2538,&
0.4175,&
0.2024,&
0.3418,&
0.1766,&
0.0561,&
0.0642,&
0.1802,&
-0.1000,&
0.0000,&
0.1043,&
0.0000,&
-0.0985,&
0.1287,&
0.1498,&
0.0315,&
0.1731,&
0.2714,&
0.1150,&
-0.0554,&
-0.0603,&
0.0192,&
0.1171,&
-0.2444,&
-0.1634,&
0.0000,&
0.2229,&
0.2336,&
0.0442,&
0.2152,&
0.2093,&
0.0083,&
0.0375,&
0.0014,&
0.0699,&
0.1712,&
-0.3000,&
-0.2400,&
-0.2100,&
0.0000,&
-0.1000,&
0.0000,&
0.2762,&
-0.1072,&
0.0592,&
-0.2769,&
-0.2065,&
-0.1309,&
0.0181,&
-0.1100,&
0.0000,&
-0.3626,&
0.0675,&
-0.1976,&
-0.3077,&
-0.2425,&
-0.3756,&
0.0000,&
0.2576,&
0.2971,&
-0.0936,&
-0.0547,&
-0.0260,&
0.1105,&
-0.1718,&
0.0000,&
-0.2350,&
-0.4040,&
-0.2041,&
-0.2761,&
-0.1970,&
-0.1490,&
-0.4588,&
-0.0555,&
-0.0258,&
0.0000,&
-0.0631,&
0.0547,&
0.2877,&
0.1624,&
0.2496,&
0.6836,&
0.2391,&
0.2391,&
0.1400,&
0.2000,&
0.2834,&
0.4447,&
0.5617,&
0.0000,&
0.2204,&
0.2335,&
0.7150,&
0.1200,&
0.3052,&
0.1731,&
0.0000,&
0.0040,&
-0.0467,&
0.0535,&
0.4287,&
0.1684,&
0.3764,&
0.4265,&
0.0000,&
0.1315,&
0.5000,&
0.3500,&
0.5000,&
0.5000,&
0.1583,&
0.2450,&
0.3500,&
0.0000,&
-0.5630,&
-0.8500,&
0.3295,&
0.0000,&
0.4150,&
0.0000,&
-0.1168,&
0.0465,&
0.1317,&
-0.0817,&
-0.0543,&
0.1473,&
0.0000,&
0.0000,&
-0.0750,&
-0.1518,&
0.2240,&
0.1250,&
0.0000,&
0.0885,&
0.2630,&
0.0000,&
0.0850,&
0.2464,&
0.3144,&
0.0000,&
0.1698,&
0.0677,&
0.1806,&
0.1565,&
0.0000,&
-0.0723,&
0.0456,&
0.0419,&
0.0710,&
0.0983,&
0.0587,&
0.0000,&
0.0000,&
0.0000,&
-0.0243,&
-0.1518,&
0.2240,&
0.1250,&
0.0000,&
0.0885,&
0.2630,&
0.0000,&
0.1294,&
0.2464,&
0.3144,&
0.1698,&
0.0000,&
0.0456,&
0.1615,&
0.0833,&
0.1844,&
0.1879,&
0.3046,&
0.1969,&
0.2653,&
0.1713,&
0.2549,&
0.3281,&
0.2797,&
0.2541,&
0.3370,&
0.3476,&
0.0400,&
0.2354,&
0.3195,&
0.1530,&
0.3916,&
0.3228,&
0.5218,&
0.0000,&
-0.0653,&
-0.0243,&
-0.1518,&
0.2240,&
0.2699,&
0.0000,&
0.0885,&
0.2630,&
0.1294,&
0.2464,&
0.3144,&
0.0000,&
0.1698,&
0.0677,&
0.1806,&
0.1565,&
0.0000,&
-0.0723,&
0.0456,&
0.0419,&
0.0710,&
0.0983,&
0.0587,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
0.0000,&
-0.2600,&
0.4600,&
0.1500,&
0.0901,&
-0.2350,&
0.1600,&
0.1300,&
0.2391,&
0.0950,& 
0.0400,&     
0.0393 /

bcc_code_r=bcc_code
bcc_charges_r=bcc_charges
return
end subroutine abcg2_bcc_data
