#!/bin/bash

export LC_NUMERIC="en_US.UTF-8"
OLD_PATH=$PATH
orac_home=`echo $PWD | sed "s?/tools/pdbrestore/www??g"`
bin=$orac_home/bin
prima=$orac_home/tools/primadorac
prima_src=$orac_home/tools/primadorac/src
scripts=$orac_home/tools/scripts 
export PATH=$bin:$prima:$scripts:$prima_src:$OLD_PATH:
code=$1
water=$2
lig=$3
if [ -s lig.pdb ] ; then
    nlig=`awk '{nres=substr($0,23,4); if(nres!=nres_old){dr++}; nres_old=nres} END{print dr}' lig.pdb`
fi
unk="none"
metals="BE CU NI PT ZN CO PD AG CR FE MG V MN HG CD YB SN PB EU SR SM BA RA AL CR TL Y LA CE PR ND SM EU GD TB DY ER TM LU HF ZR CE U PU TH"
cofactors="HEM HEA HEC HEC HED HEF HEO BCL BPH"

# function solvate (called if water != 0) 
function solvate {
    input_file=$1
    grep -v REM ${code}_fixed.pdb > tmp.pdb
    $orac_home/tools/orient/orient
    boxsize=`grep CRYSTAL setup.tmp | awk '{print $2}'`
    linked=`grep LINKED_CELL  potential.tmp | awk '{print $2}'`
    ngrid=`grep EWALD   potential.tmp | awk '{print $4}'`
    nwat=`grep GENERATE  solvent.tmp | awk '{print $2 - int(0.08*$2)}'`
    nmolw=`echo $nwat | awk '{print $1^3}'`
    watermodel=$2
    if [ $nwat -gt  33 ]; then
       water=0 
       echo "<br> <span style="color:#FF0000"> number of water: $nmolw  </span>" 
       echo "<br> <span style="color:#FF0000"> Solvated MD exceeds max allowed mol </span>" 
    fi
    sed "s/#toinsert//g" $input_file | awk '{if ($NF!="#toremove") print}' > md.in
    sed -i "s/BOXSIZE/$boxsize/g" md.in
    sed -i "s/NLINK/$linked/g" md.in
    sed -i "s/NWAT/$nwat/g" md.in
    sed -i "s/NGRID/$ngrid/g" md.in
    sed -i "s/watermodel/$watermodel/g" md.in
    sed -i "s/pdbcode/${code}_fixed.pdb/g" md.in
    cp $orac_home/pdb/water.pdb . 
    rm *.tmp              # purge orient files 
    if [ $water != 0 ] ; then
	$orac_home/src/GNU-FFTW-OMP/orac < md.in >& md.out ;
	echo "<p> ===  NPT simulation of solvated $code done.<p> " 
    fi
    if [ -s md_1.pdb ] ; then 
	n=`tail -2 md_1.pdb | head -1  | awk '{print $2+2}'`
	tail -$n md_1.pdb > ${code}_fixed+wat.pdb
	$orac_home/tools/scripts/ora-gro_pdb.awk ${code}_fixed+wat.pdb > tmp.pdb; mv tmp.pdb ${code}_fixed+wat.pdb  
	echo "<br> <span style="color:#00FFAA"> Solvation successuful. ${code}_fixed+wat.pdb generated </span>"
    else
	echo "<br> <span style="color:#FF0000"> Solvation failed..</span>" 
    fi 
}
if [ ! -s chain.pdb ]; then
    echo " <span style="color:#FF0000"> .. FAILED "
    exit
else
    size=`wc -l chain.pdb | awk '{print $1*2}'`
    if [ $size -gt 9000 ]; then
	echo " selected chain has more than 9K atoms; no solvated protein will be produced"
	water=0
    fi
fi
if [ -s error ]; then
    echo " <span style="color:#FF0000"> <Program can't proceeds due to error on gap  </span>"
    cat error 
    exit
fi
((j=0))
cp 0.in tmp.in
sed -i "s/THREADS 1/THREADS 6/g" tmp.in   

# prepare the sequence removing first and last residue for each gap"
for i in `ls  gap_ok*.pdb` ; do
    ((j=j+1)); 
    first=`head -$j gaps | tail -1 | awk '{print $2}'`
    last=`head -$j gaps | tail -1 | awk '{print $3}'`
    awk -v n1=$first -v n2=$last '{if(NF==3 && $2=="!" ) {if($3!=n1 && $3!=n2) {print }}else {print}}' tmp.in   > tmp1.in
    mv tmp1.in tmp.in 
done
cp rec.pdb tmp.pdb
((j=0)) 
#   loop on gaps
for i in `ls  gap_ok*.pdb` ; do
    ((j=j+1)); 
    J=`echo $j | awk '{printf "%02d",$1}'`
    first=`head -$j gaps | tail -1 | awk '{print $2}'`
    last=`head -$j gaps | tail -1 | awk '{print $3}'`
    ((ng=$last + 1 ));
    awk -v n=$first '{if(int(substr($0,23,4))!=n) print }' tmp.pdb |  awk -v n=$last '{if(int(substr($0,23,4))!=n) print }' > tmp1.pdb
    cat $i  tmp1.pdb | insert_gap.awk -v ng=$ng > tmp.pdb
    if [ -s fort.101 ] ; then
	unk=`awk '{print $1}' fort.101`
	cat subseq.$J tmp.in | sed "s/$unk/ala/g" | insert_seq.awk -v ng=$ng > tmp1.in
    else
	cat subseq.$J tmp.in | insert_seq.awk -v ng=$ng > tmp1.in
    fi
    mv tmp1.in tmp.in 
done
mv tmp.pdb rec+gap.pdb
mv tmp.in 00.in
sed -i "s/TIME 1.0/TIME 300.0/g" 00.in   
sed -i "s/1.0 OPEN 2.pdb/15.0 OPEN 2.pdb/g" 00.in   
./fix_cys.bash  00.in rec+gap.pdb

# add metals (if any)

#get pdb coordinates of metals
rm metals.pdb >& /dev/null
chain=`head -1 chain.pdb | awk '{print substr($0,22,1)}'`
for i in $metals; do
    awk -v c=$chain -v mtl=$i '{if($1=="ENDMDL") {exit}; if(( substr($0,22,1)==c || substr($0,22,1)==" " ) && $1~"^HETATM" && $NF==mtl)  print }' $code.pdb >> metals.pdb
done

#get residue  type of metals
rm metals.res >& /dev/null
for i in $metals; do 
    awk -v c=$chain -v mtl=$i '{if($1=="ENDMDL") {exit}; if(( substr($0,22,1)==c || substr($0,22,1)==" " ) && $1~"^HETATM" && $NF==mtl)  print $NF}' $code.pdb | awk '{print tolower($1)}' >> metals.res
done

if [ -s metals.pdb ] ; then
    cat rec+gap.pdb metals.pdb| grep -v "END" > tmp.pdb; mv tmp.pdb rec+gap.pdb
    sed $'/endsolute/{e cat metals\.res\n}' 00.in > tmp.in # insert residue metal types BEFORE 'endsolute' in template 
    mv tmp.in 00.in
fi

# fix the ligand as last residue to avoid problems with ADD_TPG and residue numberibg    
if [ -z $lig ] ; then
    lig="NONE"
fi
LIG=`echo $lig | awk '{print tolower($1)}'`
if [ -s fort.101 -a $LIG == $unk ] ; then
    echo "!! WARNING  !! WARNING  !! WARNING "
    echo " ligand $lig is also found in the sequence SEQRES and in gaps"
else
    if [ -s lig-p1.pdb -a -s prima/prima_ok ] ; then
	echo "<br>fixing ligand"
	cat rec+gap.pdb lig-p?.pdb| grep -v "END" > tmp.pdb; mv tmp.pdb rec+gap.pdb 
	for i in $(seq 1 $nlig); do
	    sed -i '/endsolute/i lig ' 00.in
	done
	cp 00.in tmp.in
	awk '{if ($1=="&PARAMETERS") {print $0; print "   READ_TPG_ASCII lig-p.tpg"; print "   READ_PRM_ASCII lig-p.prm"} else {print}}' tmp.in > 00.in
    fi
fi
# now transform all CYS-binding metals from cysh to cysm and (possibly) hse to hsd
if [ -s metals.pdb ] ; then
    ./fix_cys_zn.bash 00.in rec+gap.pdb
fi

$orac_home/src/GNU-FFTW-OMP/orac < 00.in > 00.out
if [ -s 2.pdb ] ; then
    echo "<br><b>"
    tail -35 00.out  | grep Tstep | awk '{print "        Time/Energy = "$3,$6}'
    grep COMPLETED 00.out > test_file
    if [ ! -s test_file ]; then
	echo " <span style="color:#FF0000";> Minimization failed. Try  <a href=$code.html>  again </a> </span>"
	exit
    fi
    echo "</b>" 
    n=`tail -2 2.pdb   | head -1 | awk '{print $2+2}'`
    tail -$n 2.pdb  > ${code}_fixed.pdb
    sr=`head -1 chain.pdb | awk '{printf "%02d\n", substr($0,23,4)}'`
    if [ $sr != 1 ]; then
	awk -v sr=$sr '{if($1=="ATOM") {printf "%22s",substr($0,1,22); printf "%4d",$5+sr-1; printf "%28s\n",substr($0,27,28)}}' ${code}_fixed.pdb > tmp.pdb;
	mv tmp.pdb ${code}_fixed.pdb
    fi
    #   now do solvation if required
    if [ $water != 0 ] ; then
	size=`wc -l chain.pdb | awk '{print $1*2}'`
	if [ $size -gt 9000 ]; then
	    echo " selected chain has more than 9K atoms; no solvated protein will be produced"
	    water=0
	else
	    solvate 00.in $water
	fi
    fi
    awk '{if ($3=="endsolute") {ok=0}; if(ok==1) {print}; if($1=="JOIN" && $2=="SOLUTE")  {ok=1}}' 00.in > input_sequence
    $orac_home/tools/scripts/ora-gro_pdb.awk  ${code}_fixed.pdb > tmp.pdb; mv tmp.pdb ${code}_fixed.pdb  
    if [ -s prima/lig-min-p.pdb ]; then
	cp prima/file.itp lig-g.itp
	tar zcf uploads/${code}_fixed.tar.gz ${code}_fixed*.pdb input_sequence lig-[pg].*
    else
	tar zcf uploads/${code}_fixed.tar.gz ${code}_fixed*.pdb input_sequence
    fi
	
    if [ -s fort.101 ] ; then
	echo " "
	echo "        !! WARNING !! !! WARNING !! !! WARNING !!  "
	echo "        Unknown residue '$unk' mutated into ala"
	rm fort.101
    fi
    echo "</pre>"
    echo "<h2> <span style="color:#00AA00"> PDB fixed!!</h2> </span> "
    echo "<h3> Get it <a href=uploads/${code}_fixed.tar.gz> here! </a> " 
    echo " &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp go back to <a href=pdbrestore.html>PDBrestore</a> </h3>" 
else
    echo " <span style="color:#FF0000";> Something went awry. So sorry.... </span>" 
    echo " &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp &nbsp go back to <a href=pdbrestore.html>PDBrestore</a> and try again" 
fi

exit

