<?php
// This script fix a ligand-receptor according to user spec

// four-digit pdbcode (if chosen)  
ob_end_flush();
ob_implicit_flush();
$pdbcode = $_POST['pdbcode'];
$chain = filter_input(INPUT_POST, 'chain', FILTER_SANITIZE_STRING);
$gaps = filter_input(INPUT_POST, 'gaps', FILTER_SANITIZE_STRING);
$ligand = filter_input(INPUT_POST, 'ligand', FILTER_SANITIZE_STRING);
$water = filter_input(INPUT_POST, 'water', FILTER_SANITIZE_STRING);
echo "You selected chain: <b>";
echo $chain;     
echo "</b> <br>";
echo "You selected fill gaps: <b>";
echo $gaps ; 
echo "</b> <br>";
echo "You selected ligand: <b>";
echo $ligand ;
if($ligand==""){
    echo "No ligand selected. ";
    $ligand="NONE";
    echo "Ligand set to $ligand";      
}
echo "</b> <br>";
echo "You selected the water model: <b>";
echo $water ;
echo "</b> <br>";
echo "file to process: <b>";
echo $pdbcode ;
echo "</b> <br>";

echo "<b> <br>";
echo "PDBrestore starting ....";
echo "</b> <br>";
if($ligand!="NONE"){
    echo "  ";
    echo "Using PrimaDORAC for ligand $ligand  ";
}
shell_exec("rm end") ;

// check if someone is running 
if (shell_exec("./check_queue.bash")==0) {
    echo "<br>";
    echo "<b> PDBrestore is running.... try later </b> ";
    exit(); 
}

$output=shell_exec("./fix_pdb_code.bash $pdbcode $ligand $chain $gaps") ;
echo $output;
if (filesize('error') != 0 ) {
    echo "<br><br> <b>       END OF ALL</b> ";
    exit;
}
$ngaps=shell_exec("wc gaps | awk '{print $1}'") ;
if($ngaps==0 OR $gaps=="no") {
    $ngaps=0;
    echo "<br>no gaps specified or no gaps have been found <br>" ; 
    echo "<br>optimized PDB will be generated. It may take some time.. <br>" ; 
    $output=shell_exec("./join_gap.bash 0 $pdbcode $water $ligand") ;
    echo $output;
}
for ($i = 1; $i <= $ngaps; $i++) {
    echo "<br>";
    if (filesize('error') !=0 ) {
        break;
    }
    echo filesize('error'); 
    echo "===  Joining <b> gap $i </b> using ORAC; it may take some time" ; 
    $output=shell_exec("./join_gap.bash $i $pdbcode $water $ligand") ;
    echo $output;
}

if ($ngaps > 0) {
    echo "===  Joining all gaps using ORAC; it may take some time <p>" ; 
    $output=shell_exec("./join_allgaps.bash $pdbcode $water $ligand") ;
    echo $output;
//    $myfile = fopen("output.txt", "w") or die("Unable to open file!");
//    fwrite($myfile, $output);
//    fclose($myfile);

}
echo "<br><br> <b>       END OF ALL</b> ";
echo "<br><br>     If you find PDBrestore useful, you may want to cite the paper: <br> Piero Procacci, <em> PDBrestore: A Free Web Interface for Processing and Fixing Protein Chains From Raw PDB Files </em>, J. Comp. Chem, 2025,46:e70124 
 ";
?>

