#!/bin/bash
#
# check for disulphid bonds (rec.pdb and seq contains all cysh at this stage)
#
if [ $# == "0" ] ; then
    echo " Script is used by pdbrestore.bash for fixing metal-bound cys and his"
    echo " "
    echo " Syntax: fix_cys_zn.bash filein filepdb "
    exit
fi
filein=$1
filepdb=$2
((j=0))
rm tmp.cysm >& /dev/null
rm tmp.hse_to_hsd >& /dev/null
for i in `sed "s/ /_/g" metals.pdb` ; do
    ((j=j+1)); 
    x=`echo $i | awk '{print substr($0,31,8)}' | sed "s/_//g"`
    y=`echo $i | awk '{print substr($0,39,8)}' | sed "s/_//g"`
    z=`echo $i | awk '{print substr($0,47,8)}' | sed "s/_//g"`
    awk -v x=$x -v y=$y -v z=$z  -v j=$j '{if(substr($0,18,3)=="CYS" && $3=="SG" ) {dx=substr($0,31,8)-x; dy=substr($0,39,8)-y  ; dz=substr($0,47,8)-z ; dd=sqrt(dx^2+dy^2+dz^2); if(dd<=2.8) {print tolower(substr($0,18,3)), " ! ", substr($0,23,5), dd,j } }}' $filepdb >> tmp.cysm
    awk -v x=$x -v y=$y -v z=$z  -v j=$j '{if(substr($0,18,3)=="HSE" && $3=="NE2" ) {dx=substr($0,31,8)-x; dy=substr($0,39,8)-y  ; dz=substr($0,47,8)-z ; dd=sqrt(dx^2+dy^2+dz^2); if(dd<=2.8) {print tolower(substr($0,18,3)), " ! ", substr($0,23,5), dd,j } }}' $filepdb >> tmp.hse_to_hsd
done


# convert [possibly] cysh to cysm for metal-binding cysteines in orac input 
if [ -s tmp.cysm ]; then 
    for i in `awk '{print $3}' tmp.cysm` ; do
	awk -v ncys=$i '{if($1=="cysh" && $3==ncys) {print "cysm   ! ", ncys} else {print}}' $filein > tmp.cys.in
	mv tmp.cys.in $filein
    done
    
    for i in `awk '{print $3}' tmp.cysm` ; do
	awk -v n=$i  '{nr=int(substr($0,23,5));  if(nr==n && $3=="HG1" ) {found=1} else {print} }' $filepdb  > tmp.pdb 
	mv tmp.pdb $filepdb
    done
fi
if [ -s tmp.hse_to_hsd ]; then 
    for i in `awk '{print $3}' tmp.hse_to_hsd` ; do
	awk -v nhse=$i '{if($1=="hse" && $3==nhse) {print "hsd   ! ", nhse} else {print}}' $filein > tmp.hsd.in
	mv tmp.hsd.in $filein
    done
    
    for i in `awk '{print $3}' tmp.hse_to_hsd` ; do
	awk -v n=$i  '{nr=int(substr($0,23,5));  if(nr==n && $3=="HE2" ) {found=1} else {print} }' $filepdb  > tmp.pdb 
	mv tmp.pdb $filepdb
    done
fi


for i in `sed "s/ /_/g" metals.pdb` ; do
    ((j=j+1)); 
    x=`echo $i | awk '{print substr($0,31,8)}' | sed "s/_//g"`
    y=`echo $i | awk '{print substr($0,39,8)}' | sed "s/_//g"`
    z=`echo $i | awk '{print substr($0,47,8)}' | sed "s/_//g"`
done

