#!/usr/bin/awk -f
#
# find gaps in raw PDB file.
#
function ltrim(s) { sub(/^[ \t\r\n]+/, "", s); return s }
function rtrim(s) { sub(/[ \t\r\n]+$/, "", s); return s }
function trim(s)  { return rtrim(ltrim(s)); }
{
    if($1=="ENDMDL") {
	exit
    }
    if ($1~"^ATOM") {
	atom=trim(substr($0,13,5))
	if(atom=="CA" || atom=="C" || atom=="N") {
	    ires=substr($0,23,4);
	    name=substr($0,18,3);
	    chain=substr($0,22,1);
	    dr=ires-ires_old;
#	    print ires,atom,name,dr
	}
	if(dr>1) {
	    if(chain==chain_old) {
		j++
		printf "%5d%5s%2s%5d%5s%2s  GAP%4d%5d\n",  ires_old,name_old,chain_old,ires,name,chain,dr,j
	    }
	};
	ires_old=substr($0,23,4);
	name_old=substr($0,18,3);
	chain_old=substr($0,22,1)
    }
}
