!=====================================================================--
      subroutine printf(nparm,nc,for_file,rev_file,funcmin,funcform
     &     ,funcrevm,frangem,frange0m,frange_12m,npt,pm,m_fdist,m_rdist
     &     ,di_min,ci_min,beta,xf,fdist,rdist,ibeg,iend) 
!=====================================================================--

      implicit NONE 
!--------------------DECLARATIONS---------------------------------------

      integer nx,mparm,ng
      parameter (nx=5000,ng=10,mparm=ng*3-1)
 
!-----arguments 
      integer nc,nparm,npt,ibeg,iend
      character*80 for_file,rev_file
      real*8 funcmin,funcform,funcrevm,frangem,frange0m,frange_12m,beta
     &     ,pm(mparm)
      real*8 m_fdist(-nx:nx),m_rdist(-nx:nx),di_min(ng),ci_min(ng)
      real*8 xf(-nx:nx),xr(-nx:nx),fdist(-nx:nx),rdist(-nx:nx)

!     local variables 
      integer i
      character*80 outfor,outrev,dummychar
      real*8  x0rm,dff,dfr
      
      outfor="FOR"//trim(for_file)
      outrev="REV"//trim(for_file)
      open(unit=12,file=trim(outfor)) 
      open(unit=13,file=trim(outrev)) 
      write(12,125) funcmin,funcform,funcrevm,frangem,frange0m
     &     ,frange_12m,npt
      write(13,125) funcmin,funcform,funcrevm,frangem,frange0m
     &     ,frange_12m,npt
125   FORMAT("#  FUNC =",f10.6,/  
     &       "#  for  =",f10.6,/  
     &       "#  rev  =",f10.6,/  
     &       "#  param_range       =",f10.6,/  
     &       "#  coeff_range       =",f10.6,/
     &       "#  df df1 df2 range  =",f10.6,/ 
     &       "#  npoints           =",I6)  
      if(nc.gt.1) THEN
        write(12,130) pm(nparm)
        write(13,130) pm(nparm)
      ELSE
        write(12,130) pm(1) - beta*pm(1+nc)/2.d0
        write(13,130) pm(1) - beta*pm(1+nc)/2.d0
      END IF
130   FORMAT("# FORWARD FREE ENERGY = ",f12.5) 

      write(12,398)
      write(13,399)
398   FORMAT("#  Gaussian components forward ", /
     &      ,"#  ig",4x,"c",4x,6x,"<W>",4x,4x,"s2",9x," dff")
399   FORMAT("#  Gaussian components reverse", /
     &      ,"#  ig",4x,"d",6x,4x,"<W>",4x,4x,"s2",9x," dfr")
      do i=1,nc
        x0rm= pm(i)-beta*pm(i+nc)
        dff = pm(i) - beta*pm(i+nc)/2.d0        
        dfr = x0rm  +  beta*pm(i+nc)/2.d0
        write(12,400) i,ci_min(i),pm(i),pm(i+nc),dff
        write(13,400) i,di_min(i),x0rm,pm(i+nc),dfr
400     format("#",i3,g11.3,2f11.4,5x,f11.3)
      end do
!     write distributions
      write(12,401)
      write(13,402)
401   format(/,"#   FORWARD work distribution ",/
     &        ,"#",5x,"W",6x,6x,"Fitted",3x,6x,"Exp")
402   format(/,"#   REVERSE work distribution ",/
     &        ,"#",5x,"W",6x,6x,"Fitted",3x,6x,"Exp")
      do i=ibeg,iend 
        if(m_fdist(i).LT.1D-99) m_fdist(i)=0.d0
        write(12,134) xf(i),m_fdist(i),fdist(i)
134     format(f12.3,2G15.5)
      end do
      if(trim(rev_file).eq."NONE") THEN 
        do i=ibeg,iend
          rdist(i)=m_fdist(i)*exp(-beta*(xf(i)-pm(nparm)))
          if(rdist(i).LT.1D-99) rdist(i)=0.d0
          if(m_rdist(i).LT.1D-99) m_rdist(i)=0.d0
          write(13,134) xf(i),m_rdist(i),rdist(i)
        end do
      ELSE
        do i=ibeg,iend
          if(m_rdist(i).LT.1D-99) m_rdist(i)=0.d0
          write(13,134) xf(i),m_rdist(i),rdist(i)
        end do
      END IF
      return
      END

