!======================================================================-
      program fitgauss
!======================================================================-

      implicit none 
      integer nx,mparm,ng
      parameter (nx=25000,ng=10,mparm=ng*3-1)
      real*8 fwork(nx),rwork(nx)
      real*8 p(mparm),xg(mparm,mparm),pmax(mparm),pmin(mparm),func,ftol
      real*8 emintol,funcmin,pm(mparm),am,bm,x0rm,x1rm
      real*8 xf(-nx:nx),xr(-nx:nx),fdist(-nx:nx),rdist(-nx:nx)
      real*8 c_fdist(-nx:nx),c_rdist(-nx:nx),m_fdist(-nx:nx)
     &     ,m_rdist(-nx:nx),ci(ng),di(ng),di_min(ng),ci_min(ng)
      real*8 normf,normr,DF,dustar,duni,x,dx
      real*8 wfmax,wfmin,wrmax,wrmin
      real*8 aux,ftl,useed,beta,pi,frac
      real*8 funcfor,funcrev,frange,frange0,frange_12
      real*8 funcform,funcrevm,frangem,frange0m,frange_12m,dummy
      character*80 for_file,rev_file,outfor,outrev,dummychar
      integer i,j,itype,nparm,nc,iter,ifunc,iterrand,iterdmax,icalc
     &     ,ibeg,iend,ibin,bintot,npoint,seed,npt
      common /alldata/ xf,xr,fdist,rdist,c_fdist,c_rdist,beta,pi,pmax
     &     ,pmin,funcfor,funcrev,frange,frange0,frange_12,ci,di,ifunc
     &     ,itype,ibeg,iend,nparm,nc

!===================== INITIALIZATION =================================-
      beta = 1.d0/2.494
      pi=dsqrt(1.d0/(2*dacos(-1.d0)) )
      wfmax=-1000.d0
      wfmin= 1000.d0
      wrmax=-1000.d0
      wrmin= 1000.d0
      funcmin=10000.
      ifunc=0
      iterrand=0
      icalc=0   ! if icalc=0 call powell; else calc func, print and exit 
      itype=0   ! itype=0: both ; itype=1: for ; itype=2: rev
 
!=====================================================================--


!========================READ INPUT =================================--

      read(5,*) for_file,rev_file   ! read forward and (possibly) reverse distribution filenames
      read(5,*) nc,npoint,seed,frac ! nc=gaussian components; npoint=points in the distribution
                                    ! seed=random seed; frac=fraction of
                                    ! points for bootstrap analysis
      read(5,*) itype,icalc         ! itype=0,1,2; both, for and rev fit
                                    ! icalc=0,1; if 1 the do func and exit;
!     check dimensions 
      if(nc.gt.ng) THEN 
        write(6,*) nc,
     &       "nc OUT OF RANGE: increase ng in PARAMETER statment"
      ELSE IF(npoint.gt.nx) THEN 
        write(6,*) npoint,
     &       "npoint OUT OF RANGE: increase nx in PARAMETER statment"
      END IF

!     inizialization of variables
      if(seed.GT.0) THEN 
        useed=dustar(seed)
      ELSE
        useed=dustar(306)
      END IF
      ftol=0.0001
      iterdmax=5000
      iter=0
      nparm=3*nc-1
!     initialize gradient
      do i=1,nparm
        do j=1,nparm
          xg(i,j)=duni()
          if(i.eq.j) xg(i,j) = 1.d0
        end do
      end do
      do i=1,nparm
        read(5,*) pmin(i),pmax(i)
      end do
      df=0.5*(pmin(nparm)+pmax(nparm))  ! df guess for unknown reverse dist

!     open distribution files.
      open(unit=10,file=trim(for_file),status="OLD") 
      if(rev_file.ne."NONE") open(unit=11,file=trim(rev_file),status
     &     ="OLD") 
!->   read forward and backward works 
      do i=1,npoint
        read(10,*) fwork(i)
        if(fwork(i).GT.wfmax) wfmax=fwork(i)
        if(fwork(i).LT.wfmin) wfmin=fwork(i)
        if(rev_file.eq."NONE") THEN 
!         reverse distribution not known: assumed to be mirror symmetric
!         with respect to DF guessed from param ranges. 
          rwork(i)=-fwork(i)+df
          if(rwork(i).GT.wrmax) wrmax=rwork(i)
          if(rwork(i).LT.wrmin) wrmin=rwork(i)
        ELSE
          read(11,*) rwork(i)
          if(rwork(i).GT.wrmax) wrmax=rwork(i)
          if(rwork(i).LT.wrmin) wrmin=rwork(i)
        END IF
      end do
!     resolution is set so that one has 20 points per bin assuming a
!     uniform distribution in the range wmin wmax 
      dx=(wfmax-wfmin)/int(npoint/20)

!     now construct for and back distr
      ibeg=nint(-wrmax/dx)
      iend= nint(wfmax/dx)
      do i=ibeg,iend
        x=dx*i
        xf(i)=x
        fdist(i)=0.d0
        rdist(i)=0.d0
      end do

      if(frac.lt.1.d0) THEN 
!       do bootstrap if needed (frac < 1)  
        npt=0
        do i=1,npoint
          dummy=duni()
          if(dummy.lt.frac) THEN 
            ibin=nint(fwork(i)/dx)
            fdist(ibin)=fdist(ibin)+1.d0
            ibin=nint(-rwork(i)/dx)
            rdist(ibin)=rdist(ibin)+1.d0
            npt=npt+1
          END IF
        end do
      ELSE
!     use all points
        npt=npoint
        do i=1,npoint
          ibin=nint(fwork(i)/dx)
          fdist(ibin)=fdist(ibin)+1.d0
          ibin=nint(-rwork(i)/dx)
          rdist(ibin)=rdist(ibin)+1.d0
        end do
      END IF
      normf=0.d0
      normr=0.d0
      do i=ibeg,iend
        normf=normf+fdist(i)
        normr=normr+rdist(i)
      end do
      do i=ibeg,iend
        fdist(i)=fdist(i)/(normf*dx)
        rdist(i)=rdist(i)/(normr*dx)
      end do

!=====================================================================--

!======--INIT PARAMETERS FOR POWELL ====================================

      if(icalc.eq.0) THEN 
        do i=1,nparm
          p(i)= pmin(i)+ 0.5*(pmax(i)-pmin(i))
        end do
      ELSE
        do i=1,nparm
          p(i)= pmin(i)
        end do
      END IF

!=====================================================================--

!============--CALL POWELL HERE=======================================--

1005  aux=func(p) 
      ftl=0.05

!      write(6,*) " Calling Powell.."
      if(icalc.eq.0) call powell(p,Xg,nparm,mparm,FTL,ITER,aux)
504   format( " ITERATION", i3,2A15)

!=====================================================================--
  !     randomize parameters and call again powell
  
      if(aux.lt.funcmin) then 
        funcmin=aux
        funcform=funcfor
        funcrevm=funcrev
        frangem=frange
        frange0m=frange0
        frange_12m=frange_12
        do i=1,nparm
          pm(i)=p(i)
        end do
        do i=ibeg,iend
          m_fdist(i)=c_fdist(i)
        end do
        do i=ibeg,iend
          m_rdist(i)=c_rdist(i)
        end do
        do i=1,nc
          ci_min(i)=ci(i)
          di_min(i)=di(i)
        end do
      end if
      if(icalc.eq.0.and.funcmin.gt.ftol.and.iterrand.lt.iterdmax) THEN 
        iterrand=iterrand+1
!       reset all values
        do i=1,nparm
          p(i)= pmin(i)+ duni()*(pmax(i)-pmin(i))
        end do
        if(mod(iterrand,1000).eq.0) write(6,1022) iterrand,funcmin,
     &       (p(i),i=1,nparm)
1022    FORMAT( '   ITER = ', i5, ' EMIN = ', G12.3,/ 
     &          '   EMIN GT 1: PARAMETERS REINITIALIZATED RANDOMLY',/
     &          '   P = ', 30f8.2) 
        do i=1,nparm
          do j=1,nparm
            xg(i,j)=0.d0
            if(i.eq.j) xg(i,j) = 1.d0
          end do
        end do
        go to 1005
      end if
!=====================================================================--
      write(6,118) funcmin,frangem,npt
118   FORMAT(" EXIT-->  FUNC =",G12.5 ," Ranges =",G12.5, " npoints ="
     &     ,i5)

!============-- FINAL PRINTOUTS =======================================-


      call printf(nparm,nc,for_file,rev_file,funcmin,funcform,funcrevm
     &     ,frangem,frange0m,frange_12m,npt,pm,m_fdist,m_rdist,di_min
     &     ,ci_min,beta,xf,fdist,rdist,ibeg,iend)  
      STOP
      END
