#!/bin/bash
# usage: dcd2pdb.bash <pdbfile> <dcdfile> [replica index]
exe=../src/dcd2pdb
pdb=$1
dcd=$2
if [ -e $pdb ] 
then
    echo "pdb file: " $pdb 1>&2
else
    echo "pdb file not found" 1>&2; exit 1
fi
if [ -e $dcd ] 
then
    echo "dcd file: " $dcd 1>&2
else
    echo "dcd file not found" 1>&2; exit 1
fi

if [ $# -eq 2 ]
then
    $exe -pdb $pdb -dcd $dcd
elif [ $# -eq 3 ]
then
    index=$3
    if ! [[ "$index" =~ ^[0-9]+$ ]] ; then
	echo "error: Not a number" 1>&2; exit 1
    fi

    awk -v r=$3 '{if ($2 == r) print NR}' $dcd.rem > frames; 
    $exe -pdb $pdb -dcd $dcd -f frames
else
    echo "usage: dcd2pdb.bash <pdbfile> <dcdfile> [replica index]"
    exit
fi

exit 0
