PROGRAM BENNETT

  IMPLICIT NONE

  INTEGER :: NF, NPA, J, N, I, NPATHS, NREALIZ, N_FORW, N_BACKW

! NUMERO DI PUNTI NELLA CURVA PMF
  PARAMETER ( NF = 33 )

  PARAMETER ( NPA = 10000 )

  REAL(8) :: R2, WRK, X, C, B, A, RGAS, TEMP, OFFSET
  REAL(8) :: WRK_R, WRK_F, DF_AQ_J, DF_BQ_J, DF_AB
  REAL(8) :: BETA, DF_AQ_EQ8, DF_AQ_EQ9, DF_AQ_EQ16, DF_AQ_MINH, DF_AQ_PMFB, DF_AQ_PMFA
  REAL(8) :: TIME(NF), W_F(NPA,NF), W_R(NPA,NF), R1(NPA,NF)
  REAL, EXTERNAL :: FUNC2, FUNC8, FUNC9, FUNC16, FUNCA, FUNCB, ZBRENT, FUNC_MINH
  REAL :: TOL, X1, X2
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW

! NUMERO MASSIMO DI REALIZZAZIONI
  READ(*,*) NREALIZ


  OPEN(UNIT=10, FILE='forward.dat')
  OPEN(UNIT=11, FILE='backward.dat')

! TEMPERATURA
  TEMP = 300.

! COSTANTE DEI GAS PERFETTI
  RGAS = 8.314472
  BETA = 1.D0 / ( RGAS / 1000.D0 * TEMP )


! NPATHS = NUMERO DI REALIZZAZIONI
  NPATHS = 1

10 DO J = 1, NF
     READ(10,*,END=100) R1(NPATHS,J), W_F(NPATHS,J)
     READ(11,*,END=100) R2, W_R(NPATHS,J)
  ENDDO

  NPATHS = NPATHS + 1

  IF ( NPATHS > NPA .OR. NPATHS > NREALIZ ) GOTO 100

  GOTO 10

100 NPATHS = NPATHS - 1

  DO I = 1, NPATHS
     WRK_F_Ab(I) = W_F(I,NF)
     WRK_R_Ba(I) = W_R(I,NF)
  ENDDO


  N_FORW = NPATHS
  N_BACKW = NPATHS


  X1 = -300.
  X2 = 300.
  TOL = 1.E-9

! DF_AB  (Eq. 2 PRE)
  DF_AB = ZBRENT( FUNC2, X1, X2, TOL )

  WRITE(*,'(A)') '#  position,   DF_AQ_EQ8,  DF_AQ_EQ9, DF_AQ_EQ16, DF_AQ_MINH, DF_AQ_PMFA,    DF_AQ_J,    DF_BQ_J'

  DO J = 1, NF

     DO I = 1, NPATHS
        WRK_F_Aq(I) = W_F( I, J )
        WRK_R_Bq(I) = W_R( I, NF + 1 - J )
     ENDDO

! DF calcolato con Jarzynski nell direzione R
     WRK_R = 0.
     DO N = 1, N_BACKW
        WRK_R = WRK_R + DEXP( - BETA * WRK_R_Bq(N) )
     ENDDO
     DF_BQ_J = - DLOG( WRK_R / DBLE(N_BACKW) ) / BETA

! DF calcolato con Jarzynski nell direzione F
     WRK_F = 0.
     DO N = 1, N_FORW
        WRK_F = WRK_F + DEXP( - BETA * WRK_F_Aq(N) )
     ENDDO
     DF_AQ_J = - DLOG( WRK_F / DBLE(N_FORW) ) / BETA

! Eq. 8 PRE
     DF_AQ_EQ8 = ZBRENT( FUNC8, X1, X2, TOL )


! Eq. 9 PRE
     DF_AQ_EQ9 = ZBRENT( FUNC9, X1, X2, TOL )


! Eq. 16 PRE
     DF_AQ_EQ16 = ZBRENT( FUNC16, X1, X2, TOL )


! Calcolo metodo Minh
     DF_AQ_MINH = FUNC_MINH()


! Eq. PMFA
     A = EXP( -BETA * DF_AQ_J )
     B = EXP( -BETA * DF_AB )
     C = EXP( -BETA * DF_BQ_J )
     X = 2.D0 / ( A + B * C )
     DF_AQ_PMFA = DLOG ( X ) / BETA

     IF ( J == 1 ) THEN
        OFFSET = DF_AQ_PMFA
     ENDIF

     DF_AQ_PMFA = DF_AQ_PMFA - OFFSET


! Eq. PMFB
!     DF_AQ_PMFB = ZBRENT( FUNCB, X1, X2, TOL )

     WRITE(*,'(F15.7,8F12.4,10G20.10)') R1(1,J), DF_AQ_EQ8, DF_AQ_EQ9, DF_AQ_EQ16, DF_AQ_MINH, DF_AQ_PMFA, DF_AQ_J, DF_BQ_J

  ENDDO
  
  STOP
END PROGRAM BENNETT





!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC2 ( DEF )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 10000 )

  REAL :: FUNC2, DEF
  REAL(8) :: F1, F2, M, BETA, DF_AB
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_Ab(N) - DEF ) ) )
  ENDDO

  DO N = 1, NR
     F2 = F2 - 1.D0 / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_Ba(N) + DEF ) ) )
  ENDDO

  FUNC2 = F1 + F2

  RETURN
END FUNCTION FUNC2


!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC_MINH()

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 10000 )

  REAL :: FUNC_MINH
  REAL(8) :: F1, F2, BETA, DF_AB
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + DEXP( -BETA * WRK_F_Aq(N) ) / ( DBLE(NF) + DBLE(NR) * DEXP( -BETA * ( WRK_F_Ab(N) - DF_AB ) ) )
  ENDDO

  DO N = 1, NR
     F2 = F2 + DEXP( -BETA * ( WRK_R_Bq(N) - WRK_R_Ba(N) ) ) / ( DBLE(NF) + DBLE(NR) * DEXP( BETA * ( WRK_R_Ba(N) + DF_AB ) ) )
  ENDDO

  FUNC_MINH = -DLOG( F1 + F2 ) / BETA

  RETURN
END FUNCTION FUNC_MINH


!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC8 ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 10000 )

  REAL :: FUNC8, DF_AQ
  REAL(8) :: F1, F2, WRK_R, M, BETA, DF_AB, WRK_R_qa
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  WRK_R = 0.
  DO N = 1, NR
     WRK_R = WRK_R + DEXP( - BETA * WRK_R_Bq(N) )
  ENDDO
  WRK_R = WRK_R / DBLE(NR)


  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_Aq(N) - DF_AQ ) ) )
  ENDDO

  DO N = 1, NR
     WRK_R_qa = WRK_R_Ba(N) - WRK_R_Bq(N)
     F2 = F2 - DEXP( - BETA * WRK_R_Bq(N) ) / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_qa + DF_AQ ) ) ) / WRK_R
  ENDDO

  FUNC8 = F1 + F2

  RETURN
END FUNCTION FUNC8




!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC9 ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 10000 )

  REAL :: FUNC9, DF_AQ
  REAL(8) :: F1, F2, WRK_F, M, BETA, DF_AB, DF_QB, WRK_F_qb
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  DF_QB = DF_AB - DF_AQ

  WRK_F = 0.D0
  DO N = 1, NF
     WRK_F = WRK_F + DEXP( - BETA * WRK_F_Aq(N) )
  ENDDO
  WRK_F = WRK_F / DBLE(NF)

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     WRK_F_qb = WRK_F_Ab(N) - WRK_F_Aq(N)
     F1 = F1 + DEXP( - BETA * WRK_F_Aq(N) ) / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_qb - DF_QB ) ) ) / WRK_F
  ENDDO

  DO N = 1, NR
     F2 = F2 - 1.D0 / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_Bq(N) + DF_QB ) ) )
  ENDDO

  FUNC9 = F1 + F2

  RETURN
END FUNCTION FUNC9



!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNC16 ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 10000 )

  REAL :: FUNC16, DF_AQ
  REAL(8) :: F1, F2, F3, F4, WRK_F, WRK_R, M, BETA, DF_AB, WRK_F_qb, WRK_R_qa
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  WRK_R = 0.
  DO N = 1, NR
     WRK_R = WRK_R + DEXP( - BETA * WRK_R_Bq(N) )
  ENDDO
  WRK_R = WRK_R / DBLE(NR)

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + DEXP ( BETA * ( M + WRK_F_Aq(N) - DF_AQ ) ) )
  ENDDO

  DO N = 1, NR
     WRK_R_qa = WRK_R_Ba(N) - WRK_R_Bq(N)
     F2 = F2 - DEXP( - BETA * WRK_R_Bq(N) ) / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_qa + DF_AQ ) ) ) / WRK_R
  ENDDO



  WRK_F = 0.D0
  DO N = 1, NF
     WRK_F = WRK_F + DEXP( - BETA * WRK_F_Aq(N) )
  ENDDO
  WRK_F = WRK_F / DBLE(NF)

  M = DLOG ( DBLE(NF) / DBLE(NR) ) / BETA

  F3 = 0.D0
  F4 = 0.D0

  DO N = 1, NF
     WRK_F_qb = WRK_F_Ab(N) - WRK_F_Aq(N)
     F3 = F3 - DEXP( - BETA * WRK_F_Aq(N) ) / ( 1.D0 + DEXP( BETA * ( M + WRK_F_qb - DF_AB + DF_AQ ) ) ) / WRK_F
  ENDDO

  DO N = 1, NR
     F4 = F4 + 1.D0 / ( 1.D0 + DEXP( BETA * ( - M + WRK_R_Bq(N) + DF_AB - DF_AQ ) ) )
  ENDDO

  FUNC16 = F1 + F2 + F3 + F4

  RETURN
END FUNCTION FUNC16



!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FUNCTION FUNCB ( DF_AQ )

  IMPLICIT NONE

  INTEGER :: NPA, NF, NR, N

  PARAMETER ( NPA = 10000 )

  REAL :: FUNCB, DF_AQ
  REAL(8) :: F1, F2, BETA, DF_AB, WRK_F_qb, WRK_R_qa
  REAL(8) :: WRK_F_Aq(NPA), WRK_F_Ab(NPA), WRK_R_Bq(NPA), WRK_R_Ba(NPA)
  INTEGER :: N_FORW, N_BACKW

  COMMON / COMM1 / WRK_F_Aq, WRK_F_Ab, WRK_R_Bq, WRK_R_Ba
  COMMON / COMM2 / BETA, DF_AB, N_FORW, N_BACKW


  NR = N_BACKW
  NF = N_FORW

  F1 = 0.D0
  F2 = 0.D0

  DO N = 1, NF
     F1 = F1 + 1.D0 / ( 1.D0 + NF * DEXP ( BETA * ( WRK_F_Aq(N) - DF_AQ ) ) )
  ENDDO

  DO N = 1, NR
     F2 = F2 + 1.D0 / ( 1.D0 + NR * DEXP( BETA * ( WRK_R_Bq(N) + DF_AB - DF_AQ ) ) )
  ENDDO

  FUNCB = F1 + F2 - 2.D0

  RETURN
END FUNCTION FUNCB



!===========================================================
FUNCTION ZBRENT( FUNC, X1, X2, TOL )                                           

  PARAMETER (ITMAX=100,EPS=3.E-8)                                           

  A=X1                                                                      
  B=X2                                                                      
  FA=FUNC(A)                                                                
  FB=FUNC(B)                                                                

  IF(FB*FA.GT.0.) THEN
     WRITE(*,*) A, B, FA, FB
     PAUSE 'Root must be bracketed for ZBRENT.'                
  ENDIF
  FC=FB                                                                     
  DO ITER=1,ITMAX                                                        
     IF(FB*FC.GT.0.) THEN                                                    
        C=A                                                                   
        FC=FA                                                                 
        D=B-A                                                                 
        E=D                                                                   
     ENDIF
     IF(ABS(FC).LT.ABS(FB)) THEN                                             
        A=B                                                                   
        B=C                                                                   
        C=A                                                                   
        FA=FB                                                                 
        FB=FC                                                                 
        FC=FA                                                                 
     ENDIF
     TOL1=2.*EPS*ABS(B)+0.5*TOL                                              
     XM=.5*(C-B)                                                             
     IF(ABS(XM).LE.TOL1 .OR. FB.EQ.0.)THEN                                   
        ZBRENT=B                                                              
        RETURN                                                                
     ENDIF
     IF(ABS(E).GE.TOL1 .AND. ABS(FA).GT.ABS(FB)) THEN                        
        S=FB/FA                                                               
        IF(A.EQ.C) THEN                                                       
           P=2.*XM*S                                                           
           Q=1.-S                                                              
        ELSE                                                                  
           Q=FA/FC                                                             
           R=FB/FC                                                             
           P=S*(2.*XM*Q*(Q-R)-(B-A)*(R-1.))                                    
           Q=(Q-1.)*(R-1.)*(S-1.)                                              
        ENDIF
        IF(P.GT.0.) Q=-Q                                                      
        P=ABS(P)                                                              
        IF(2.*P .LT. MIN(3.*XM*Q-ABS(TOL1*Q),ABS(E*Q))) THEN                  
           E=D                                                                 
           D=P/Q                                                               
        ELSE                                                                  
           D=XM                                                                
           E=D                                                                 
        ENDIF
     ELSE                                                                    
        D=XM                                                                  
        E=D                                                                   
     ENDIF
     A=B                                                                     
     FA=FB                                                                   
     IF(ABS(D) .GT. TOL1) THEN                                               
        B=B+D                                                                 
     ELSE                                                                    
        B=B+SIGN(TOL1,XM)                                                     
     ENDIF
     FB=FUNC(B)                                                              
  ENDDO
  PAUSE 'ZBRENT exceeding maximum iterations.'                              
  ZBRENT=B                                                                  

  RETURN                                                                    
END FUNCTION ZBRENT
