program analysis
! -----syntax: analysis < <input>
! -----input file syntax:
! lines beginning with & define collective variables
! lines beginning with # are comment lines
! how to add a cv in input:
! & <variable name> [label1 label2 ...]
! -----list of collective variables:
! (copy and paste in input file)
! & atom_distance <at1> <at2>
! & atom_angle <at1> <at2> <at3>
! & atom_dihedral <at1> <at2> <at3> <at4>
! & ramachandran <res> 
! & n_hbonds <d0(pm)>
! & line_fit <at1> <at2>
! & puckering <Glc-res>
  use precision
  use units
  use input
  use output
  use pdb
  use cv
  implicit none
  integer(ki)  :: i,k
  integer(ki)  :: err
  integer(ki)  :: kpdb ! input unit
  character*64 :: fpdb ! input file name
  integer(ki)  :: nato
  logical      :: endofpdb
  real*8,      allocatable :: r(:,:) ! coordinate matrix (3 x nato)
  type(label), allocatable :: r_label(:)! pdb label array (nato)
  character*64 :: string

  ! TODO: 
  ! use assumed-shape dummy arrays in modules

  ! howto add a new collective variables: 
  ! put new cv routine in cv module 
  ! + code lines in the select case constructs in
  ! ----- comp_cv routine (cv module) 
  ! ----- read_cv routine (input module) 
  
  read_pdbname: do 
     read(5,*,iostat=err) string
     if(err /= 0) stop 'pdb file name error'
     if(string /= '#' .and. string /= '&') then 
        backspace(5)
        read(5,*,iostat=err) fpdb
        exit read_pdbname
     end if
  end do read_pdbname

  rewind(5)

  ! open pdb unit
  
  call open_pdb(kpdb,fpdb,'OLD',nato)
  
  ! compute the cvs number in input file 
  
  call count_cv(ncv) 

  ! allocate memory for cvs variables

  call allocate_cv 
  
  ! allocate memory for output variables

  call allocate_out(ncv)
  
  ! read cvs data from input
  
  k = 1
  read_loop: do 
     read(5,*,iostat=err) string
     if(err /=0) stop 'read_cv error'
     if(string == '&') then 
        backspace(5)
        call read_cv(cv_data(k)%name,cv_data(k)%list,cv_data(k)%num)
        !     if(cv_data(k)%name(1:1) == '#') cycle read_loop
        write(0,*) '# cv number: ', k
        write(0,*) '# cv type: ', cv_data(k)%name
        write(0,*) '# input parameters (e.g. atoms/residues): ', cv_data(k)%list
        write(0,*) '#'
        if(k == ncv) exit read_loop
        k = k + 1
     end if
  end do read_loop

  ! open output units

  call open_out(ncv,cv_data%name)

  ! allocate pdb array
  
  allocate(r(3,nato),r_label(nato),stat = err)
  if(err /= 0) stop "error in allocating memory (r,r_label)"

  ! loop on pdb structures
  
  pdb_loop: do 

     ! read pdb 
     
     call read_pdb(nato,kpdb,r,r_label,endofpdb)

     if(endofpdb) exit pdb_loop

     ! compute collective variables

     call comp_cv(nato,r,r_label)

     ! print results

     do i = 1,ncv
        call print_out(i,cv_data(i)%val,cv_data(i)%num)
     end do

  end do pdb_loop
  
end program analysis
