#!/bin/bash
rm fort.* *.hst x.0 >& /dev/null 
echo "starting program with BAR first guess ",$1 
if [ -e ../src/mbar ]; then
time ../src/mbar HREM.parm HREM.dat $1 $2  > weights 2> BAR-$1.LOG
else
  echo "Program mbar does not exist in dir ../src"
  echo "Compile the in dir ../src"
  exit 
fi 

echo " program finished; weights file created" 
echo " generating  energy distributions..."

if [ $1 == "T" ]  
then  for i in fort.1??; do awk '{print $3}'  $i > x.0; histog +i10 x.0 | awk '{print $1,$2}' > `echo $i | sed "s/fort\.1/Rep_Solute-Solute\./g"`;done
for i in fort.1??; do awk '{print $4}'  $i > x.0; histog +i10 x.0 | awk '{print $1,$2}' > `echo $i | sed "s/fort\.1/Rep_Solute-Solvent\./g"`;done
fi 
mkdir DISTRIBUTIONS 2> /dev/null
mv Rep* DISTRIBUTIONS
rm fort.* x.0 
echo " All done;"
echo " N.B.: file H-REM-BAR.LOG contains info on Z_k and convergence"
echo " N.B.: Dir DISTRIBUTIONS contains energy distributions"
exit 