  program qqtest
    implicit none 
    ! This subroutine implement the qq test for  work distribution
    ! (see Krishnamooorthy Handbook of Stat. dist with appl. Taylor-Fracis
    ! 2016, page 146) using the correlation coeffiecient method.
    ! The normality test is done on a series of bootstrap samples with n=100
    ! extrapolating from the R-critical values reported in the formula 
    ! obtained from MC simulations:
    ! 
    !   r(n)=1.0063-0.1288/n**0.5 - 0.6118/n + 1.3505/n**2. (alpha=0.05)
    !
    ! Null hypothesis (normality) is rejected if more than 1 of the 20 bs
    ! samples (0.05) do not pass the r-test
    
    integer i,j,k,nw,npoints, nstrap,nfailed,nb,status,seed,nmax
    character(len=32) :: arg,workfile
    real*8    ::  frac,t,wm,wm2,swm2,xmin,xmax,range,resol,intg,x,eps,errorf,pi,pifact,pmin,pmax,r_100
    real*8    ::  sq2,wmax,wmin,work,zm,zm2,r,rxy,sx,sy,a,b,alpha,dummy,sense,rxym
    real*8, allocatable :: wrk(:),wt(:),p(:),z(:)
    
    alpha=0.05   ! default value for confidence level
    r_100=0.9874
    nstrap=0
    nfailed=0
    frac=1.1
    seed=15
    pi=dacos(-1.d0)
    pifact =  1/dsqrt(2*pi)
! check args number 
    if(iargc().ne.1.and.iargc().ne.2) THEN 
       write(6,*) 
       write(6,*) "Syntax: "
       write(6,*) "        qq [frac ] workfile"
       write(6,*) "        workfile is the work file" 
       write(6,*) "           frac is an optional arguments:"         
       write(6,*) "           frac -> is the confidence level (e.g. 0.05) " 
       write(6,*) 
       go to 2
    end if

    !   parse arguments (either 1 or 3)
    if(iargc().eq.1) THEN  
       call getarg(1,workfile)  ! only the workfile is given
    else 
       call getarg(1,arg)       ! seedx and botstrap fraction are also given 
       read(arg,*) frac
       call getarg(2,workfile)
    end if

    open(unit=10,file=workfile) 
    nw=0
    status=0
    do while(status==0) 
       read(10,*,IOSTAT=status)
       nw=nw+1
    end do
    nw=nw-1
    frac=100.d0/float(nw)
    !   allocate all arrays 
    allocate(wrk(nw),wt(nw),p(nw),z(nw),stat=status) 
    if(frac.gt.0) call srand(seed) 
    dummy=rand()
    rewind(10)
    do i=1,nw
       read(10,*) wt(i)
    end do
1   nb=0
    nstrap=nstrap + 1
    wm=0.d0
    wm2=0.d0
    do i=1,nw
       dummy=rand()
       if (dummy.lt.frac) THEN
          nb=nb+1
          wrk(nb)=wt(i)
          wm=wm+wrk(nb) 
          wm2=wm2+wrk(nb)**2
       end if
    end do
    wm=wm/nb
    wm2=wm2/nb
    swm2=wm2-wm**2.
    pmin= pifact*exp(-xmin**2/2)
!   sort real numbers in ascending order 
    do i=1,nb
       do j=i,nb
          if (wrk(i) > wrk(j) )   then
             t=wrk(j)
             wrk(j)=wrk(i)
             wrk(i)=t
          end if
       end do
    end do
    

!   computes the cumulative probabilities on th sorted data
    do j=1,nb
       p(j)=(j-0.5d0 )/dfloat(nb)
    end do
    resol=p(1)/10.d0
    
    xmin=(wrk(1)-wm )/dsqrt(swm2) ! minimum value of work on a standard normal distribution (0 mean, 1 sigma)  
    xmax=(wrk(nb)-wm )/dsqrt(swm2)! minimum value of work on a standard normal distribution (0 mean, 1 sigma)  
    range=xmax-xmin
!   compute z(j)
    sq2=1.d0/dsqrt(2.d0)
    npoints=nint(range/resol)
    eps=10.d0/float(npoints)
!   computes z values using the erfc function. The z-value
!   is the abscissa for a normal distribution giving the 
!   cumulative distribution p(j).
!   tabulate complementary error function
    do j=1,nb
       errorf=2*(1.d0-p(j))
       if(errorf.gt.erfc(sq2*xmin)) THEN  ! this is done to avoid mssing first points  
          sense=-1.d0 
       else
          sense=1.d0
       ENDIF
       x=xmin
       if(errorf.gt.erfc(sq2*xmin)) THEN  ! this is done to avoid mssing first points  
          sense=-1.d0 
       else
          sense=1.d0
       ENDIF
       do k=1,npoints
          x=x+resol*sense
          if(x.gt.xmin+range) exit
           if(abs(erfc(sq2*x)-errorf).lt.eps) THEN
             z(j)=x
             xmin=x-resol
             exit
          endif
      end do
    end do
!   the z-critical value at the level 0.05    
!   the z-critical value correspond to the area for which the null
!   hypothesis is verifies, i.e. to the area comprised between the two 
!   tails for rejection     
    zm=0.d0
    zm2=0.d0
    do i=1,nb
 !     write(6,'(5f15.6)')  z(i),(wrk(i)-wm)/dsqrt(swm2),p(i),2*(1.d0-p(i)),erfc(sq2*z(i))
       zm=zm+z(i)
       zm2=zm2+z(i)**2.
    end do
 !   computes correlation coefficents
    zm=zm/nb
    zm2=zm2/nb
    sy=(wm2-wm**2)**0.5   
    sx=(zm2-zm**2)**0.5
    r=0.d0
    do i=1,nb
       r=r + (wrk(i)-wm)*(z(i)-zm)
    end do
    rxy=r/(sx*sy)/float(nb) 
    a=rxy*sy/sx
    b=wm-a*zm 
    if(rxy.lt.r_100) nfailed=nfailed+1  ! 0.9874 is the r critical value for a=0.05
    if(rxy.lt.r_100) write(6,'(i5,2f10.5, "   failed")' ) nb,rxy,r_100
    if(rxy.gt.r_100) write(6,'(i5,2f10.5, "   passed")' ) nb,rxy,r_100
    rxym=rxym+rxy
    if(nstrap.lt.40) go to 1
2   continue
    nmax=nint(0.05*nstrap)
    if(nfailed.gt.nmax) THEN 
       write(6,'(" Test Failed -> r > r_c with p > 0.05; failed attempts = ",I2, "  <r> =",f8.4 )'), nfailed,rxym/nstrap
    ELSE 
       write(6,'(" Test passed -> r <  r_c with p > 0.95; failed attempts = ",I2,"   <r> =",f8.4 )'), nfailed,rxym/nstrap
    END IF
  end program qqtest
