#! /usr/bin/awk -f
# produce COO-termini from inner residues ORAC/tpg file.
# Can be used for charmm and opls force field with standard N-ter and C-ter
# syntax: do_cter.awk -v ff=[opls|charmm] ;  
BEGIN  {
    if(ff=="charmm") {
    typec="c"; typeca="ca" ; typeo="o";   #charmm types
    } 
    if(ff=="opls") {
	typec="c235"; typeca="c224" ; typeo="o236";   #Opls types (inactive)
    }
}
{ 
    # carbonyl  carbon 
    if($1=="c" && $2==typec) {                       # CHARMM
	if(ff=="charmm") {
	    print " c    cc    0.34 "
	    print " ot1  oc   -0.67 "
	    print " ot2  oc   -0.67 "}
   	if(ff=="opls") {                               # OPLS  
	    print " c    c271    0.700 "
	    print " ot1  o272   -0.800 "    
	    print " ot2  o272   -0.800 "
	} 
    }
    # alpha carbon  (OPLS and CHARMM differ 
    else if( $1=="ca" && $2 ==typeca) {
	if(ff=="charmm") {                            # CHARMM
	    print   # comment this line if you want to generate OPLS termini
	}
	if(ff=="opls") {                              # CHARMM
	    print " ca c283  0.0400 "  
	}
    }
    else if( $1=="o" && $2 ==typeo) {
    }
    else if( $1=="termatom") {
	print "termatom n *"
    }
    else if( $1=="RESIDUE") {
	print "RESIDUE "$2"-o"
    }
    else if( $1=="+n" || $2=="+n" || $3=="+n" || $4=="+n" ) {                   # fix torsions section
         print "    ca  ot1  c   ot2"
    }
    else if( $2=="+n" || $3=="+n") {
         print "    ca  ot1  c   ot2"
    }                    
    else if ($1=="c" && $2 =="o" ) {                   # fix bonds section 
	print "   c   ot1   c   ot2"
    }
    else if ($1=="o" && $2 =="c" ) {
	print "   c   ot1   c   ot2"
    }
    else if ($3=="o" && $4=="c" ) {
	print "   c   ot1   c   ot2"
    }
    else if ($4=="o" && $3=="c" ) {
	print "   c   ot1   c   ot2"
    }
    else if ($5=="o" && $6=="c" ) {
	print "   c   ot1   c   ot2"
    }
    else if ($6=="o" && $5=="c" ) {
	print "   c   ot1   c   ot2"
    }
    else {print}
}


