#! /usr/bin/awk -f
BEGIN{
    first_bond=0
    first_im=0
    first_res=0
}
{
 if($1=="RESI" || $1=="PRES")  { 
     if(first_res==0) {
	 print "######" 
	 print "RESIDUE",tolower($2)
	 print "atoms"
	 first_res=1
     }
     else {
	 printf "\n"
	 print "end"
	 print "termatom n c" 
	 print "backbone n ca c"
	 print "RESIDUE_END"
	 print "######" 
	 print "RESIDUE",tolower($2)
	 print "atoms"
	 first_bond=0
	 first_im=0
     }
 }  
 if($1=="GROUP") {print tolower($1)} 
 if($1=="ATOM") {printf "%7s%7s%8.4f\n", tolower($2),tolower($3),$4}
 if($1=="BOND" || $1=="DOUBLE") {
     if(first_bond==0) {  
	 print "end"
	 print "bonds"
	 first_bond=1
     }
     comment=0
     for(i=2; i<=NF; i++) {
	 if(substr($i,1,1) =="!") { comment=1}
	 if(comment==0) {
	     if(substr($i,1,1)=="+" || substr($i,1,1)=="-") {
		 label=substr($i,2,length($i))
	     }
	     else  {
		 label = $i
	     }
	     printf "%7s", tolower(label)
	     if(int(int((i-1)/4))==(i-1)/4 && i < NF) {printf "\n"}
	 }
     }
     printf "\n"
 } 
 if($1=="IMPR") {
     if(first_im==0) {  
	 print "end"
	 print "imphd"
	 first_im=1
     }
     comment=0
     for(i=2; i<=NF; i++) { 
	 if(substr($i,1,1) =="!") { comment=1}
	 if(comment==0) {
#	 if(substr($i,1,1) =="!") {exit}
	     printf "%7s", tolower($i)
	     if(int(int((i-1)/4))==(i-1)/4 && i < NF) {printf "\n"}
	 }
     }
 } 
}
END { 
    printf "\n" 
    print "end"
    print "termatom n c" 
    print "backbone n ca c"
    print "RESIDUE_END"
}
