!-------------------------------------------------------------------------------------------------------
!     Computes voronoi volumes form PDB file using PBC. The PDB file is assumed to be 
!     in the ORAC format, i.e. is supposed to contain REMARK lines with CO matrix specification 
!     and END  lines  
!-------------------------------------------------------------------------------------------------------
PROGRAM VORONOI
  !-------------------------------------------------------------------------------------------------------

  IMPLICIT none

  !----------------------------- DECLARATIONS----------------------------*
  integer natoms,nfragm,maxpla,maxconf,mcut
  double precision :: cut,cut2,d22,box
  parameter (MAXPLA=60,maxconf=10000,cut=10.d0,mcut=500,BOX=302.d0)   
  INTEGER i,j,k,n,j1,i1,nconf
  double precision, allocatable :: x(:),y(:),z(:),x1(:),y1(:),z1(:),voltot(:),voltot2(:)

  double precision  pla(4,MAXPLA),vrt(3,250,MAXPLA)    ! planes and vertices 
  double precision  volume,surface,rs,ax,ay,az,bx,by,bz,cx,cy,cz,frac,abcx,abcy,abcz,vol ! local variables
  double precision  xc(mcut),yc(mcut),zc(mcut),xf(8),yf(8),zf(8),xxc(mcut),yyc(mcut),zzc(mcut),d2(mcut),xx,yy,zz
  double precision  co(3,3),oc(3,3),xxo,yyo,zzo,vm,vm2,sig
  INTEGER nver(MAXPLA),nn,ierr,way,ia
  character*5, allocatable ::  atom(:) 
  integer, allocatable ::  ibeg(:),iend(:) 
  character*20 filename 

  !----------------------- EXECUTABLE STATEMENTS ------------------------*

  frac=0.5D0
  cut2=cut*cut
  nn = maxpla-8
  !     sets the 8 far atoms 
  xf(1)=-1.01*box
  yf(1)=-1.02*box
  zf(1)=-1.00*box

  xf(2)= 1.0*box
  yf(2)=-1.1*box
  zf(2)=-1.0*box

  xf(3)=-1.011*box
  yf(3)= 1.012*box
  zf(3)=-1.000*box

  xf(4)=-1.00*box
  yf(4)=-1.05*box
  zf(4)= 1.00*box

  xf(5)=-1.011*box
  yf(5)= 1.021*box
  zf(5)= 1.000*box

  xf(6)= 1.000*box
  yf(6)=-1.037*box
  zf(6)= 1.000*box

  xf(7)= 1.000*box
  yf(7)= 1.055*box
  zf(7)=-1.001*box

  xf(8)= 1.032*box
  yf(8)= 1.045*box
  zf(8)= 1.022*box
  read(5,*) natoms,nfragm
  allocate(ibeg(nfragm),iend(nfragm),stat=ierr) 
  do i=1,nfragm
     read(5,*) ibeg(i),iend(i)
  end do
  read(5,*) filename 
  open (unit=10,file=trim(filename))
  allocate(x(natoms),y(natoms),z(natoms),x1(natoms),y1(natoms),z1(natoms),voltot(natoms),voltot2(natoms),stat=ierr) 
  allocate(atom(natoms),stat=ierr) 
  !--   read atomic coordinate 
  voltot=0.0
  voltot2=0.0
  do i1=1,maxconf
     read(10,5,END=1000)  ((co(i,j),j=1,3),i=1,3) ! read co matrix
5    FORMAT(42x,9f10.5)
     CALL matinv(3,3,co,oc,volume)
     DO i=1,natoms
        read(10,900,end=1000,err=1001) atom(i), x(i),y(i),z(i) 
        !          write(6,900) atom(i),x(i),y(i),z(i)
900     FORMAT(11x,A5,14x,3f8.3)
        way = -1
        call change_frame(co,oc,way,natoms,x,y,z,x1,y1,z1)
     end do

     read(10,*,END=1000) ! read end/ter line
     if(mod(i1,1000).eq.0) THEN 
        write(6,*) "configuration", i1, " read in; atoms" ,natoms
     end if
     !       find nearest neighbors to atom i with PBC 
     do ia=1,nfragm
        do i=ibeg(ia),iend(ia)
           k=0
           DO j=1,natoms
              if(j.ne.i) THEN 
                 xx=x1(i)-x1(j) - nint(x1(i)-x1(j))
                 yy=y1(i)-y1(j) - nint(y1(i)-y1(j))
                 zz=z1(i)-z1(j) - nint(z1(i)-z1(j))
                 xxo=co(1,1)*xx +co(1,2)*yy + co(1,3)*zz
                 yyo=co(2,1)*xx +co(2,2)*yy + co(2,3)*zz
                 zzo=co(3,1)*xx +co(3,2)*yy + co(3,3)*zz
                 d22=xxo**2+yyo**2+zzo**2
                 if(d22.lt.cut2) THEN  
                    k=k+1
                    if(k.gt.mcut) THEN 
                       write(6,*) "ERROR -Dimension exceeds: increase MCUT or reduce CUTOFF" 
                       STOP
                    end if
                    xxc(k)=xxo
                    yyc(k)=yyo
                    zzc(k)=zzo
                    d2(k)=d22
                 endif
              end if
           end do
           call srt(k,d2,xxc,yyc,zzc)
           if(k.lt.nn) THEN
              do j=k+1,nn  ! add dummy atoms up to nn
                 xxc(j)=1.d4+float(j) 
                 yyc(j)= 0.d0
                 zzc(j)= 0.d0
                 d2(j) = xxc(j)**2 
              end do
           END IF
           do j=1,nn   ! takes only the first MAXPLA-8 neighbors
              pla(1,j)=frac*xxc(j)
              pla(2,j)=frac*yyc(j)
              pla(3,j)=frac*zzc(j)
              pla(4,j)=frac*frac*d2(j)
              nver(j)=0
              !                         write(6,200) i,j,d2(j),pla(1,j),pla(2,j),pla(3,j),pla(4,j)
200           format("sorted",2i5,5g15.5) 
           END DO

           !         now add far atoms
           do j=1,8
              pla(1,nn+j)=frac*(x(i)-xf(j))
              pla(2,nn+j)=frac*(y(i)-yf(j))
              pla(3,nn+j)=frac*(z(i)-zf(j))
              d2(nn+j)=(x(i)-xf(j))**2+(y(i)-yf(j))**2 + (z(i)-zf(j))**2
              pla(4,nn+j)=frac*frac*d2(nn+j)
              !               write(6,300) i,j+nn,d2(nn+j),pla(1,nn+j),pla(2,nn+j),pla(3,nn+j),pla(4,nn+j)
300           format("add",2i5,5g15.5) 
           end do

           CALL vstart(pla,vrt,nver)
           surface=0.0D0
           volume=0.0D0
           DO j=1,MAXPLA
              IF(nver(j) .GT. 0) THEN            
                 ax=vrt(1,1,j)
                 ay=vrt(2,1,j)
                 az=vrt(3,1,J)
                 !              write(6,400) j,nver(j),ax,ay,az
                 !400           format(2i5,3f12.5)
                 vol = 0.0
                 DO k=2,nver(j)-1
                    bx   = vrt(1,k,j)
                    by   = vrt(2,k,j)
                    bz   = vrt(3,k,j)
                    cx   = vrt(1,k+1,j)
                    cy   = vrt(2,k+1,j)
                    cz   = vrt(3,k+1,j)
                    !                write(6,400) k,nver(j),cx,cy,cz
                    abcx = ax*(by*cz-bz*cy)
                    abcy = ay*(bz*cx-bx*cz)
                    abcz = az*(bx*cy-by*cx)
                    vol  = vol + DABS(abcx+abcy+abcz)
                 END DO
                 volume      = volume+vol
                 surface     =surface+vol / SQRT(d2(j))
              END IF
           END DO
           !            write(6,*) i,volume, surface
           VOLTOT(i)=VOLTOT(i)+volume/6.0D0
           VOLTOT2(i)=VOLTOT2(i)+(volume/6.0D0)**2.
        END DO
     end do
  end do
1000 nconf=i1-1
  write(6,*) " Avegares on ",nconf," configurations" 
  do ia=1,nfragm
     write(6,229) ia
229  format("===== FRAGMENT", i5)
     write(6,231)
231  format("index   atom  ",5x,"volume",9x,"+\-dvol")
     do i=ibeg(ia),iend(ia)
        vm=voltot(i)/float(nconf) 
        vm2=voltot2(i)/float(nconf)
        sig = dsqrt(vm2-vm**2.)
        write(6,230) i,atom(i), vm,sig
230     format(i5,2x,a5,2x,g15.5,3g15.5) 
     END DO
  END DO
  STOP
1001 write(6,123) filename 
123 FORMAT(" Error in reading file ",A20)  
END PROGRAM VORONOI

SUBROUTINE srt(N,ARR,xc,yc,zc)
  real*8 ARR(N),xc(N),yc(N),zc(N),A
  integer I,J,N
  DO J=2,N
     A=ARR(J)
     a1=xc(j)
     a2=yc(j)
     a3=zc(j)
     DO I=J-1,1,-1
        IF(ARR(I).LE.A)GO TO 10
        ARR(I+1)=ARR(I)
        xc(i+1)=xc(I)
        yc(i+1)=yc(I)
        zc(i+1)=zc(I)
     end do
     I=0
10   ARR(I+1)=A
     xc(I+1)= a1
     yc(I+1)= a2
     zc(I+1)= a3
  END DO
  RETURN
END SUBROUTINE srt


