#!/bin/bash
#
# This script (to be issued from varia/p38/p1t1b/bace dirs)  
# computes the ligand-recpt com-com distribution and associated pmf" 
# from the REM PARxxx dirs relative to the bound state. 
# The results are stored in the directory varia/Datap
#
xs=3.0
remove=0
reszip=0
free=0
noem=0
uwork=0
bwork=0
checkcom=0
ignore=0
dirdata="Datap"
opls=0

TOOLPATH=`which orac | sed "s?bin/orac?tools/templates?g"`


if [ ! -d Datap -o $# -eq 0 ] ; then 
    echo " Extract work data from PAR dirs and compute dissociation free energies" 
    echo " syntax: ../bin/fsdam_dirs.bash [opt] pdbcode"
    echo "          where pdbcode is the directory corresponding to the ligand-receptor system"
    echo "          N.B.: This directory can be produced with the script test_pdb_with_orac.bash "  
    echo " Options:                                                                                 " 
    echo "        -u timeu" 
    echo "          arg 'timeu' specify the duration time (growth process) for the unbound state"
    echo "        -b timeb" 
    echo "          arg 'timeb' specify the duration time (annihilation process) for the bound state"
    echo "        -x out_threshold" 
    echo "          arg 'out_threshold' specify threshold (in sigmas) for outliers in work data" 
    echo "        -f " 
    echo "          do only free energy calculations without extracting the workfiles (work files MUST be on Datap directory) " 
    echo "        -f " 
    echo "          do only free energy calculations without extracting the workfiles and without convolution (work _b/ and BU files MUST be on Datap directory) " 
    echo "        -d " 
    echo "          remove pdb files from PARxxx dirs after computing the work" 
    echo "        -z " 
    echo "          Zip data in PARxxx dirs after computing the work" 
    echo "        -o " 
    echo "          produce com-com nonequilibrium output form PARxxx xyz files"
    echo "        -O " 
    echo "          files are saved in OPLS Datap-o directory "
    echo "        -i " 
    echo "          ignore missing files error and proceed "
    echo "        -D dir" 
    echo "          use dir instead of Datap for work data "
    echo ""
    echo " N.B: give this command from varia/p38/p1p1t/bace/COVID19 dirs "
    exit
fi 

while getopts ":u:b:x:dzfFoOiD:" opt; do 
    case $opt in 
	u)
	    uwork=1
	    timeu=$OPTARG
	    ;;
	b)
	    bwork=1
	    time=$OPTARG
	    ;;
	x)
	    xs=$OPTARG
	    ;;
	d) 
	    remove=1
	    ;;
	z) 
	    reszip=1
	    ;;
	f) 
	    free=1
	    ;;
	F) 
	    noem=1
	    ;;
	o) 
	    checkcom=1
	    ;;
	O) 
	    opls=1
	    ;;
	i) 
	    ignore=1
	    ;;
	D)
	    dirdata=$OPTARG
	    ;;
    esac
done

dire=${!#}

# make some check when -f is specifed


# if input dir not found, exit
if [ ! -d ${dire} ]; then
    echo ${dire}" dir not found"; 
    exit 
fi

if [ $opls == 1 ] ; then
    dirdata="Datap-o"
    echo "OUTPUT dir is "$dirdata
fi
if [ $free == 1 ]; then 
    if [ $opls == 1 ]; then
	free=1
	echo "with OPLS free reset to 1" 
    fi
fi

if [ $free == 1 -o  $noem == 1 ]; then  
    if [ ! -e ${dire}/rem.in ]; then 
	missing=${dire}/rem.in" " 
    fi
    if [ ! -e ${dire}/Data ]; then 
	missing=$missing${dire}/Data" "
    fi
    if [ ! -e ${dire}/md.out ]; then 
	missing=$missing${dire}/md.out" "
    fi
    if [ ! -e ${dirdata}/${dire}.com.hst ]; then 
	missing=${missing}${dirdata}/${dire}.com.hst" "
    fi
    if  [ ! -e ${dirdata}/${dire}_u_${timeu}.wrk  ]; then 
	missing=${missing}${dirdata}/${dire}_u_${timeu}.wrk" "
    fi
    if [ ! -e ${dirdata}/${dire}_b_${time}.wrk  ]; then 
	missing=${missing}${dirdata}/${dire}_b_${time}.wrk" "
    fi
    if [ $noem == 1 ] ; then 
	if [ ! -e ${dirdata}/$dire.BU.$time.$timeu.wrk  ]; then 
	    missing=$dire.BU.$time.$timeu.wrk
	fi
    fi
	if [ ! -z "$missing" ]; then 
	echo " Missing files : "$missing
	exit 
    fi
fi

n=`grep ligand ${dire}/rem.in | awk '{print $3}'`

#### FUNCTION DG BEGINS HERE : this code assumes that the wrk files have been generated and evaluates 
#                              the dissociation free energy based on the EM algorithm  
function dg {
printf $dire; 
rm x.? >& /dev/null
rm ${dirdata}/${dire}_DG_gau_${time}_${timeu} >& /dev/null
rm ${dirdata}/${dire}_Qdg_gau_${time}_${timeu} >& /dev/null
rm ${dirdata}/${dire}_DG_jar_${time}_${timeu} >& /dev/null
rm ${dirdata}/${dire}_Qdg_jar_${time}_${timeu} >& /dev/null

grep DISSO ${dire}/Data | awk '{print $4}' > tmp.${dire}.x.e
dgexp=`grep DISSO ${dire}/Data | awk '{print $4}'`
printf "  DG= %6.2f" $dgexp
# number of atoms in ligandtaken from rem.in
n=`grep ligand ${dire}/rem.in | awk '{print $3}'`
printf "  nl= %3d" $n

# ionic strenght is taken from ${dire}.tpg 
is=`awk 'BEGIN{nq=0} {if(NF==3 && $3 != "*" ) {a+=$3^2; nq++}} END {print sqrt(a/nq) } ' ${dire}/${dire}.tpg`
printf " is %5.3f" $is
#echo $is

# number of normal components obtained from higher moments:
#  if (not skew  && not kurt ) ncomp=1
#  if (skew      && not kurt ) ncomp=2
#  if (not skew  && kurt )     ncomp=3
#  if (skew      && kurt )     ncomp=4

cd ${dirdata}

#rebuild work using qwrk and lwrk
#paste ${dire}_b_${time}.qwrk ${dire}_b_${time}.lwrk  |  zscore3.awk > tmp.w
zscore_rec.awk -v xs=$xs ${dire}_b_${time}.wrk > tmp.w
grep -v "#"  tmp.w > w.b 
grep    "#"  tmp.w > $dire.outliers.b 
#paste ${dire}_u_${timeu}.qwrk ${dire}_u_${timeu}.lwrk  |  zscore3.awk > tmp.w
zscore_rec.awk -v xs=$xs ${dire}_u_${timeu}.wrk > tmp.w
grep -v "#"  tmp.w > w.u 
grep    "#"  tmp.w > $dire.outliers.u 

#  GAUSSIAN MIXTURE (E.M. algorithm) 
# computes overall free energy 

volume=`awk '{if(NR>1) {dx=$1-xold}; xold=$1;  a2+=$1^2*$2*dx; a+=$1*$2*dx} END{print 4*3.14*(2*sqrt(a2-a^2))^3/3}' ${dire}.com.hst`

lchar=`grep "Solute Molecule      1" ../${dire}/md.out | awk '{printf  $3}'`
printf "  ql= %3.0f" $lchar
pchar=`grep "Solute Molecule      2" ../${dire}/md.out | awk '{printf  $3}'`
printf "  qp= %3.0f" $pchar
volumeb=`grep CRYSTAL  ../${dire}/rem.in | awk '{print $2*$3*$4}'`  
volumeu=45000  

qcorrb=`awk -v lq=$lchar -v pq=$pchar -v vl=$volumeb 'BEGIN{print 332.*3.14*(lq^2+2*pq*lq)/2/0.37^2/vl}' /dev/null`
qcorru=`awk -v lq=$lchar -v pq=$pchar -v vl=$volumeu 'BEGIN{print 332.*3.14*(lq^2)/2/0.37^2/vl}' /dev/null `

qcorr=`awk -v qu=$qcorru -v qb=$qcorrb 'BEGIN{print qb-qu} ' /dev/null`

printf "  dgq= %4.1f" $qcorr

volcor=`echo $volume | awk '{print 0.595*log($1/1660)}'`

printf "  dgv= %4.1f" $volcor

printf "  tu= %4.0f" $timeu

printf "  tb= %4.0f" $time

# computes electrostatic contribution to the free energy (gaussian approximation)
rm ${dire}_Qdg_gau_${time}_${timeu} >& /dev/null

if [ -f ${dire}_b_${time}.qwrk ] ; then 
    Free_bs.bash ${dire}_b_${time}.qwrk > tmp.${dire}b
fi
if [ -f ${dire}_u_${time}.qwrk ] ; then 
    Free_bs.bash ${dire}_u_${timeu}.qwrk > tmp.${dire}u
    paste tmp.${dire}b tmp.${dire}u  | awk '{print $2+$7,$3+$8}' > ${dire}_Qdg_gau_${time}_${timeu}
    DGq=`awk '{print $1}' ${dire}_Qdg_gau_${time}_${timeu}`
    DGqerr=`awk '{print $2}' ${dire}_Qdg_gau_${time}_${timeu}`
    
    printf " DGq= %4.1f" $DGq
    printf " %4.1f" $DGqerr
fi

#  Jarzyksi and EM exponential averages

# computes overall free energy

Free_bs.bash w.b > tmp.${dire}.x.0 
Free_bs.bash w.u > tmp.${dire}.x.1 
paste ../tmp.${dire}.x.e tmp.${dire}.x.0 tmp.${dire}.x.1 | awk -v nlig=$n -v is=$is -v vol=$volume -v ql=$lchar -v qc=$qcorr '{dvol=0.593*log(vol/1661); printf "%8.2f%8.2f %3s%5.2f%10d%10.4f%10.2f\n", $1,$5+$10+dvol+qc,"+/-",$6+$11,nlig,is,ql}' > ${dire}_DG_jar_${time}_${timeu}

#DGjar=`awk '{print $2}' ${dire}_DG_jar_${time}_${timeu}`
#DGerr=`awk '{print $4}' ${dire}_DG_jar_${time}_${timeu}`
#printf " DGj= %4.1f" $DGjar
#printf " %4.1f" $DGerr

##################################### DOUBLE SYSTEM EMULATION ######################################################

rm jar.tmp em.tmp >& /dev/null

# bootstrap loop 
if [ $noem == 0 ]; then
    nu=`wc -l w.u | awk '{print $1}'`
    nb=`wc -l w.b | awk '{print $1}'`
    for i in {1..15} ; do 
	bs_res.awk -v seed=$i w.u > u.tmp
	bs_res.awk -v seed=$i w.b > b.tmp
	cat u.tmp b.tmp  > filebu.tmp  # combine bootstrapped files
	cat u.tmp b.tmp  > filebu.tmp$i  # combine bootstrapped files
	awk -v nu=$nu -v nb=$nb '\
  {\
   if(NR<=nu)  {wu[NR]=$1} else {wb[NR-nu]=$1}\
  }\
  END{\
      for(i=1; i<=nu; i++) {\
          for(j=1; j<=nb; j++){\
             print  wu[i]+wb[j]\
          }\
      }\
}' filebu.tmp > $dire.BU.wrk
	awk '{print $1/4.184}' $dire.BU.wrk | histog +i`echo $sigmab | awk '{print $1/10}'` > $dire.BU.hst   
	free.awk $dire.BU.wrk | awk '{print $6}' >>  jar.tmp  #computes Jarzynski free energy
	em 0.3 $i $dire.BU.wrk  >> em.tmp
    done
    cp em.tmp   $dire.em.$time.$timeu
    cp jar.tmp  $dire.jr.$time.$timeu
    
    # computes full b+u distribution
    cat w.u w.b > filebu.tmp
    awk -v nu=$nu -v nb=$nb '\
  {\
   if(NR<=nu)  {wu[NR]=$1} else {wb[NR-nu]=$1}\
  }\
  END{\
      for(i=1; i<=nu; i++) {\
          for(j=1; j<=nb; j++){\
             print  wu[i]+wb[j]\
          }\
      }\
}' filebu.tmp > $dire.BU.$time.$timeu.wrk
    
    # make histog of boosted distr  
    awk '{print $1/4.184}' $dire.BU.$time.$timeu.wrk | histog +i0.05 > $dire.BU.${time}.${timeu}.hst   
    
fi
if [ $noem == 0 ]; then 
    grep "Components=  1" em.tmp |  awk '{a+=$4; a2+=$4^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' > DG.1 
    grep "Components=  2" em.tmp |  awk '{a+=$4; a2+=$4^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' > DG.2
    grep "Components=  3" em.tmp |  awk '{a+=$4; a2+=$4^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' > DG.3
    DGjar=`awk '{a+=$1; a2+=$1^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' jar.tmp > free.tmp`
else
    grep "Components=  1" $dire.em.$time.$timeu |  awk '{a+=$4; a2+=$4^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' > DG.1 
    grep "Components=  2" $dire.em.$time.$timeu |  awk '{a+=$4; a2+=$4^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' > DG.2
    grep "Components=  3" $dire.em.$time.$timeu |  awk '{a+=$4; a2+=$4^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' > DG.3
    DGjar=`awk '{a+=$1; a2+=$1^2}END{print a/NR,1.96*sqrt(a2/NR -(a/NR)^2)}' $dire.jr.$time.$timeu  > free.tmp`
fi

em 0.3 1 $dire.BU.$time.$timeu.wrk > DG.tmp

DG1=`grep "Components=  1" DG.tmp |  awk -v vol=$volcor -v qc=$qcorr '{print $4+vol+qc}'` 
DG2=`grep "Components=  2" DG.tmp |  awk -v vol=$volcor -v qc=$qcorr '{print $4+vol+qc}'` 
DG3=`grep "Components=  3" DG.tmp |  awk -v vol=$volcor -v qc=$qcorr '{print $4+vol+qc}'` 

#DG1=`awk -v vol=$volcor -v qc=$corr '{print $1+vol+qc}' DG.1`
DG1err=`awk '{print $2}' DG.1`

printf " DG1= %4.1f" $DG1
printf " %4.1f" $DG1err


#DG2=`awk -v vol=$volcor -v qc=$qcorr '{print $1+vol+qc}' DG.2`
DG2err=`awk '{print $2}' DG.2`

printf " DG2= %4.1f" $DG2
printf " %4.1f" $DG2err

#DG3=`awk -v vol=$volcor -v qc=$qcorr '{print $1+vol+qc}' DG.3`
DG3err=`awk '{print $2}' DG.3`

printf " DG3= %4.1f" $DG3
printf " %4.1f" $DG3err


paste ../tmp.${dire}.x.e  free.tmp  | awk -v nlig=$n -v is=$is -v vol=$volume -v ql=$lchar -v qc=$qcorr '{dvol=0.593*log(vol/1661); printf "%8.2f%8.2f %3s%5.2f%10d%10.4f%10.2f\n", $1,$2+dvol+qc,"+/-",$3,nlig,is,ql}' > ${dire}_DG_jar_b-u_${time}_${timeu}

DGjarM=`awk '{print $2}' ${dire}_DG_jar_b-u_${time}_${timeu}`
DGjar=`free.awk $dire.BU.$time.$timeu.wrk | awk -v vol=$volcor -v qc=$qcorr '{print $6+vol+qc}'`   

DGerr=`awk '{print $4}' ${dire}_DG_jar_b-u_${time}_${timeu}`
printf " DGj= %4.1f" $DGjar
printf " %4.1f" $DGerr

# find theoretical bias
npt=`wc -l $dire.BU.$time.$timeu.wrk | awk '{print $1}'`
sigma=`free.awk $dire.BU.$time.$timeu.wrk | awk '{print sqrt($2)}'`
bias=`find_bias.bash $sigma $npt`
DGJcorr=`echo $DGjar $bias | awk '{print $1-$2}'`
printf " DGjc= %4.1f" $DGJcorr
printf " %4.1f" $DGerr

printf " msb= " 
msb=`free.awk w.b | awk '{print $1}'`
dmsb=`free.awk w.b | awk '{print sqrt($2)}'`
printf "%4.1f" $msb 
printf "%4.1f" $dmsb 

printf " msu= " 
msu=`free.awk w.u | awk -v s=$sign '{print $1}'`
dmsu=`free.awk w.u | awk '{print sqrt($2)}'`
printf "%4.1f" $msu 
printf "%4.1f" $dmsu 

printf " ADb= " 
ADb=`qq w.b  | grep Anderson | awk '{printf " %5.2f",$8}'`
printf "%5.2f" $ADb 

printf " ADu= " 
ADu=`qq w.u  | grep Anderson | awk '{printf " %5.2f",$8}'`
printf "%5.2f" $ADu 

# print star (best) estimate (non with -F option ]
gauss=0 
if [ $noem == 1 ] ; then
    # a Gaussian work distribution  (generated with rand()) has a mean AD-test ~ 0.37 
    gauss=`AD_pvalue.awk -v x="$ADb" /dev/null | awk '{if($2>0.50) {print "1"} else {print "0"}}'` # if p_value >0.5 then distribution is Gaussian
    gaussu=`echo $ADu $dmsu | awk -v gau=$gauss '{if($1>0.8 && $2>2.0 ) {print "0"} else {print "1"}}'`
    # reset gauss to zero if sigma_u > 2.0 and AD failed 
    if [ $gauss == 1 ] ; then 
	gauss=$gaussu
    fi
    nptb=`wc -l  w.b | awk '{print $1}'` 
    nptu=`wc -l  w.u | awk '{print $1}'` 
    bias_u=`find_bias.bash $dmsu $nptu`
    if [ $gauss == 1 ] ; then
	# bound distribution is Gaussian: no convolution is used
	dgb=`free.awk w.b | awk '{print  $5}'`
	dgu=`free.awk w.u | awk '{print  $5}'`
	DGs=`echo $dgb $dgu $volcor $qcorr | awk '{print $1+$2+$3+$4}'`
	DGserr=`echo $dmsb $dmsu $nptb $nptu | awk '{ddgb=$1/($3)^0.5 + 0.5*$1^2*(2/$3)^0.5/0.596  ; ddgu = $2/($4)^0.5 + 0.5*$2^2*(2/$4)^0.5/0.596 ; print 1.96*sqrt(ddgu^2+ddgb^2)}'`
	typeE="Gb"
    else
    	DGs=`echo $DGJcorr $DGerr $DG3 $DG3err | awk '{if($1<$3) {print $1} else if($4<2) {print $3} else {print $1}}'`
    	DGserr=`echo $DGJcorr $DGerr $DG3 $DG3err | awk '{if($1<$3) {print $2} else if($4<2) {print $4} else {print $2}}'`
    	typeE=`echo $DGJcorr $DGerr $DG3 $DG3err | awk '{if($1<$3) {print "S_JC"} else if($4<2) {print "S_3"} else {print "S_JC"}}'`
    fi
    printf " DGs= %4.1f" $DGs
    printf " %4.1f" $DGserr
    printf " Type= %5s" $typeE
fi
printf "  S_o= "
printf "%4.1f" $xs
printf "\n" 

# computes electrostatic contribution to the free energy
if [ -s ${dire}_b_${time}.qwrk ] ; then 
    Free_bs.bash ${dire}_b_${time}.qwrk  > tmp.${dire}.x.0 
    Free_bs.bash ${dire}_u_${timeu}.qwrk  > tmp.${dire}.x.1 
    paste ../tmp.${dire}.x.e tmp.${dire}.x.0 tmp.${dire}.x.1 | awk -v nlig=$n -v s=$sign '{printf "%8.2f%8.2f %3s%5.2f%10d\n", $1,$5+$10,"+/-",2*($6+$11),nlig}' > ${dire}_Qdg_jar_${time}_${timeu}
fi

rm  ${dire}_${time}_${timeu}.ktsk >& /dev/null

( printf "b "; kurt+skew.bash w.b ) > ${dire}_${time}_${timeu}.ktsk.bs0.5
( printf "u "; kurt+skew.bash w.u ) >> ${dire}_${time}_${timeu}.ktsk.bs0.5

    


# end of free energy calc; go back to varia dir. 

cd ..

# cleanup tmp.files

 rm ${dirdata}/tmp*${dire}*  tmp*${dire}*   >& /dev/null

}
#### FUNCTION DG ENDS HERE ###################################################################################### 
#### FUNCTION DG ENDS HERE ###################################################################################### 
#### FUNCTION DG ENDS HERE ###################################################################################### 
#### FUNCTION DG ENDS HERE ###################################################################################### 


# launch dg on ${dirdata} files and exit
if [ $free == 1 -o $noem == 1 ]; then 
    dg
    awk '{print $1/4.184}' ${dirdata}/${dire}_b_${time}.wrk | histog +i0.5 > ${dirdata}/${dire}_b_${time}.wdist
    awk '{print $1/4.184}' ${dirdata}/${dire}_u_${timeu}.wrk | histog +i0.5 > ${dirdata}/${dire}_u_${timeu}.wdist 
    exit
fi

# if b/u subdir of input dir not found, exit
if [ ! -d ${dire}/b  ]; then
    echo ${dire}/b " dir not found; launch the command : " 
    echo "$", " make_fsdam_input.bash with -b " $timb "  -s "${dire} ; 
#    exit
fi
if [ ! -d ${dire}/u  ]; then
    echo ${dire}/u " dir not found; launch the command : " 
    echo "$", " make_fsdam_input.bash with -u 360  -s "${dire} ; 
#    exit
fi

# START com-com distribution of the target states calculation  
# gets the number of atoms of the ligand
# and the experimental (starting) ligand-receptor  com-com distance

if [ $bwork == 0 -a $ignore == 0 ] ; then  
    if [ -s ${dire}/b/PAR0001/INPUT.gz ] ; then
	n=`zcat  ${dire}/b/PAR0001/INPUT | awk '/ligand/{print $3}'`
	time=`zcat  ${dire}/b/PAR0001/INPUT | awk '/PLOT ALCHEMY/{print substr($5,1,3)}'`
	timeu=`zcat  ${dire}/u/PAR0001/INPUT | awk '/PLOT ALCHEMY/{print substr($5,1,3)}'`
    elif [ -s ${dire}/b/PAR0001/INPUT ] ; then
	n=`awk '/ligand/{print $3}' ${dire}/b/PAR0001/INPUT`
	time=`awk '/PLOT ALCHEMY/ {print substr($5,1,3)}' ${dire}/b/PAR0001/INPUT`
	timeu=`awk '/PLOT ALCHEMY/ {print substr($5,1,3)}' ${dire}/u/PAR0001/INPUT`
    else
	echo "??? INPUT file not found in dir ", ${dire}"/b/PAR0001/"
	exit
    fi
elif [ $ignore == 0 ]; then  
    if [ ! -s ${dire}/b/PAR0001/"${time}.wrk.*" ]  ; then  
	echo "??? work file not found or empty in dir ", ${dire}"/b/PAR0001/"
	exit
    fi
fi
    
echo ${dire}": " " nlig = "$n "   time u = "$timeu "   time b = " $time 


# unzip files if needed

if [[ $checkcom == 1 ]] ; then
    if [ -s ${dire}/b/PAR0132/${dire}.xyz.gz  ] ; then
	echo "unzipping xyz  files in PARxx dirs...."
	gunzip -f ${dire}/b/PAR0[1346][1357][2468]/${dire}.xyz.gz ${dire}/b/PAR0001/${dire}.xyz.gz >& /dev/null 
    fi
    echo "unzipping done; running checkcomdist.awk on a sample of alchemy xyz files"
#    run the checkcomdist.awk command on the alchmey PARs and save time record in ${dirdata} dir
    checkcomdist.awk -v n=$n -v S=0 ${dire}/b/PAR0[1346][1357][2468]/${dire}.xyz > tmp.${dire}0
    awk -v tti=$time '{tt=tti"000.00"; if($1==tt) {iold=i ; i=0; nn[i]=0}; i++ ; nn[i]++; time[i]=$1; a[i]+=$2; a2[i]+=$2^2} END {for (j=1; j<=iold ; j++) {print time[j],a[j]/nn[j], sqrt( a2[j]/nn[j] - (a[j]/nn[j])^2) }}' tmp.${dire}0 | sort -k 1n > ${dirdata}/${dire}_fsdam_com${time}.dat ; 
fi    

#unzip work files if needed
gunzip ${dire}/b/PAR*/${time}.wrk.gz >& /dev/null 
gunzip ${dire}/u/PAR*/${timeu}.wrk.gz >& /dev/null 

qtimeb=`awk '{if ($5==1.0 && $4==0.0) print $1}' $TOOLPATH/${time}.off>& /dev/null`
qtimeu=`awk '{if ($2==0.0 && $3==1.0) print $1}' $TOOLPATH/${timeu}.on>& /dev/null`

echo "computing work files and pmf for the bound state"
# construct the work file for the bound and unbound states
if [ -s ${dire}/b/PAR0001/${time}.wrk ] ; then
    ( for i in ${dire}/b/PAR*/${time}.wrk ; do tail -1 $i | awk -v time=$time '{print $6}'; done ) > ${dirdata}/${dire}_b_${time}.wrk ;
    ( for i in ${dire}/b/PAR*/${time}.wrk ; do awk -v tt=$qtimeb '{if($1==tt) print $6}' $i; done ) > ${dirdata}/${dire}_b_${time}.qwrk ;
    paste ${dirdata}/${dire}_b_${time}.qwrk ${dirdata}/${dire}_b_${time}.wrk | awk '{print $2-$1}' >  ${dirdata}/${dire}_b_${time}.lwrk
    for i in ${dire}/b/PAR*/${time}.wrk ; do timef=`tail -1 $i | awk '{print $1}'`; if [ $timef != "${time}.000" ] ; then mv $i $i-unf; fi; done 

    pmf.awk -v time=${time}".000" ${dire}/b/PAR*/${time}.wrk > ${dirdata}/${dire}_b_${time}.pmf ;
    awk '{print $1/4.184}' ${dirdata}/${dire}_b_${time}.wrk | histog +i0.5 > ${dirdata}/${dire}_b_${time}.wdist      

else 
    if [ -s ${dirdata}/${dire}_b_${time}.wrk ] ; then
	echo "work files (b) not found; using those stored in ${dirdata}" 
	awk '{print $1/4.184}' ${dirdata}/${dire}_b_${time}.wrk | histog +i0.5 > ${dirdata}/${dire}_b_${time}.wdist      
    else
	echo "work files (b) not found" 
	if [ $ignore == 0 ] ; then exit ; fi
    fi 
fi

qtimeb=`awk '{if ($5==1.0 && $4==0.0) print $1}' $TOOLPATH/${time}.off>& /dev/null`
qtimeu=`awk '{if ($2==0.0  && $3==1.0) print $1}' $TOOLPATH/${timeu}.on >& /dev/null`
echo "computing work files and pmf for the unbound state", $qtimeb $qtimeu  

if [ -s ${dire}/u/PAR0001/${timeu}.wrk ] ; then
    ( for i in ${dire}/u/PAR*/${timeu}.wrk ; do tail -1 $i | awk '{print $6}'; done ) > ${dirdata}/${dire}_u_${timeu}.wrk ;
    ( for i in ${dire}/u/PAR*/${timeu}.wrk ; do awk -v tt=$qtimeu '{if($1==tt) print $6}' $i; done ) > ${dirdata}/${dire}_u_${timeu}.lwrk ;
    paste ${dirdata}/${dire}_u_${timeu}.lwrk ${dirdata}/${dire}_u_${timeu}.wrk | awk '{print $2-$1}' >  ${dirdata}/${dire}_u_${timeu}.qwrk
    # check that all work files are complete before PMF
    for i in ${dire}/u/PAR*/${timeu}.wrk ; do timef=`tail -1 $i | awk '{print $1}'`; if [ $timef != "${timeu}.000" ] ; then mv $i $i-unf; fi; done 
    pmf.awk -v time=${timeu}".000" ${dire}/u/PAR*/${timeu}.wrk > ${dirdata}/${dire}_u_${timeu}.pmf ;
else 
    if [ -s ${dirdata}/${dire}_u_${timeu}.wrk ] ; then
	echo "work files (u) not found; using those stored in ${dirdata}" 
    else	 
	echo "work files (u) not found" 
	exit 
    fi
fi

awk '{print $1/4.184}' ${dirdata}/${dire}_u_${timeu}.wrk | histog +i0.5 > ${dirdata}/${dire}_u_${timeu}.wdist      

# compute annhilation free energies on 1/5 of bootstapped works 

if [ $ignore == 0 ] ; then 
    dg    # call the function dg with no args 
fi 

echo "Forced re-zipping xyz files in PARxx dirs. Old xyz files  will be overwritten..."
gzip -f ${dire}/b/PAR0[1346][1357][2468]/${dire}.xyz  ${dire}/b/PAR0001/${dire}.xyz   >& /dev/null
gzip -f ${dire}/u/PAR0*/${dire}.xyz >& /dev/null

if [ $remove == 1 ] ; then 
    echo "Exiting. Purging and gzipping files.. " 
    mv ${dire}/b/PAR0001/md_1.pdb ${dire}/b/PAR0001/${dire}_${time}.pdb >& /dev/null # save only one md_1.pdb
    mv ${dire}/b/PAR0001/out0001 ${dire}/b/PAR0001/${dire}_${time}.out >& /dev/null    # save only one out0000
    for i in ${dire}/b/PAR*/md_1.pdb; do 
	rm $i >&/dev/null;
    done
    for i in ${dire}/b/PAR*/out00*; do 
	rm $i >&/dev/null;
    done
    for i in ${dire}/b/PAR*/*.xyz; do 
	rm $i >&/dev/null;
    done
fi
if [ $reszip == 1 ] ; then
    echo "Re-zipping RESTART dirs...."
    for i in ${dire}/b-RSTRT/PAR* ; do 
	gzip -rf $i; 
    done
    for i in ${dire}/u-RSTRT/PAR* ; do 
	gzip -rf $i; 
    done
fi

exit
